package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import java.util.Objects;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;

@Metadata(label = "RiskFilter", versioned = false)
public class RiskFilter extends SimpleFilter {
    @Property(required = false, description = "The inclusive lower bound for risk levels to find.")
    private Integer from = 0;

    @Property(required = false, description = "The inclusive upper bound for risk levels to find or -1 for no bound.")
    private Integer to = -1;

    public RiskFilter() {

    }

    public RiskFilter(Integer from, Integer to) {
        setFrom(from);
        setTo(to);
    }

    public Integer getFrom() {
        return this.from;
    }

    public void setFrom(Integer from) {
        this.from = (from == null || from < 0) ? 0 : from;
    }

    public Integer getTo() {
        return this.to;
    }

    public void setTo(Integer to) {
        this.to = (to == null || to < -1) ? -1 : to;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final RiskFilter that = (RiskFilter) o;
        return Objects.equals(this.from, that.from) &&
                Objects.equals(this.to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), from, to);
    }

    @Override
    public String toString() {
        return "RiskFilter[" + "from=" + from + ", to=" + to + "]";
    }
}
