package com.xebialabs.xlrelease.udm.reporting.filters;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import java.util.Objects;

@Metadata(label = "EnvironmentStageFilter", versioned = false)
public class EnvironmentStageFilter extends SimpleFilter {
    @Property(description = "The ID of the environment stage to filter.")
    private String environmentStageId = "";

    public EnvironmentStageFilter() {
    }

    public EnvironmentStageFilter(String environmentStageId) {
        this.environmentStageId = environmentStageId;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final EnvironmentStageFilter that = (EnvironmentStageFilter) o;
        return Objects.equals(environmentStageId, that.environmentStageId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), environmentStageId);
    }

    @Override
    public String toString() {
        return "EnvironmentStageFilter[environmentStageId = " + environmentStageId + "]";
    }

    public String getEnvironmentStageId() {
        return environmentStageId;
    }

    public void setEnvironmentStageId(final String environmentStageId) {
        this.environmentStageId = environmentStageId;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }

}
