package com.xebialabs.xlrelease.udm.reporting.filters.impl;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.api.v1.forms.TimeFrame;
import com.xebialabs.xlrelease.udm.reporting.filters.SimpleFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.UdmReportFilterVisitor;

import java.util.Date;
import java.util.Objects;

import static com.xebialabs.xlrelease.api.v1.forms.TimeFrame.LAST_SIX_MONTHS;

@Metadata(label = "DateFilter", versioned = false)
public class DateFilter extends SimpleFilter {

    @Property(required = false, description = "Predefined time-frame to apply to the reports query.")
    private TimeFrame timeFrame = LAST_SIX_MONTHS;

    @Property(required = false, description = "Overrides the predefined time-frame with a custom from date.")
    private Date from;

    @Property(required = false, description = "Overrides the predefined time-frame with a custom to date.")
    private Date to;

    public DateFilter() {
    }

    public DateFilter(TimeFrame timeFrame, Date from, Date to) {
        this.timeFrame = timeFrame;
        this.from = from;
        this.to = to;
    }

    public DateFilter(TimeFrame timeFrame) {
        this.timeFrame = timeFrame;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        final DateFilter that = (DateFilter) o;
        return timeFrame == that.timeFrame &&
            Objects.equals(from, that.from) &&
            Objects.equals(to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), timeFrame, from, to);
    }

    @Override
    public String toString() {
        return "DateFilter[from = " + from + ", to = " + to + ", timeFrame = " + timeFrame + "]";
    }

    public TimeFrame getTimeFrame() {
        return timeFrame;
    }

    public void setTimeFrame(final TimeFrame timeFrame) {
        this.timeFrame = timeFrame;
    }

    public Date getFrom() {
        return from;
    }

    public void setFrom(final Date from) {
        this.from = from;
    }

    public Date getTo() {
        return to;
    }

    public void setTo(final Date to) {
        this.to = to;
    }

    @Override
    public <R> R accept(UdmReportFilterVisitor<R> visitor) {
        return visitor.visit(this);
    }
}
