package com.xebialabs.xlrelease.udm.reporting.repository

import com.xebialabs.xlrelease.udm.reporting.{Deployment, DeploymentHistory}


trait DeploymentRepository {

  def create(deployment: Deployment, deploymentHistory: DeploymentHistory = null): Unit

  def update(original: Deployment, deploymentHistory: DeploymentHistory): Unit

  def delete(deploymentId: String): Unit

  def exists(deploymentId: String): Boolean

  def findById(deploymentId: String): Option[Deployment]

  def findByTaskId(taskId: String): Seq[Deployment]

  def findHistoryById(deploymentId: String): Seq[DeploymentHistory]

  def findHistoryByIds(deploymentIds: Seq[String]): Map[String, Seq[DeploymentHistory]]

  def deleteAutoGeneratedDeployments(taskId: String): Unit
}

