package com.xebialabs.xlrelease.udm.reporting.upgrade

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence.hash
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.params
import com.xebialabs.xlrelease.udm.reporting.repository.sql.persistence.DeploymentSchema.DEPLOYMENTS
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.UpgradeSupport.BatchSupport
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class XLRelease220ArchiveDeploymentTableUpgrade @Autowired()(@Qualifier("reportingJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                                             @Qualifier("reportingSqlDialect") implicit val dialect: Dialect)
  extends Upgrade with PersistenceSupport with Logging with BatchSupport {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "22.0.0#0")

  override def doUpgrade(): Boolean = {
    debug("Running upgrade ENG-8200. Updating the empty taskIdHash field in DEPLOYMENTS table in archive db.")
    val deployIdTaskIdPairs = findTaskIdsToUpdate()
    doInBatch(deployIdTaskIdPairs) { batch =>
      batch.items.foreach(deployIdTaskId => {
        updateTaskIdHash(deployIdTaskId._1, deployIdTaskId._2)
      })
    }
    debug("Completed running upgrade ENG-8200.")
    true
  }

  private val STMT_SELECT_TASK_ID =
    s"""
       | SELECT ${DEPLOYMENTS.DEPLOYMENT_ID},${DEPLOYMENTS.TASK_ID} FROM ${DEPLOYMENTS.TABLE}
       | WHERE ${DEPLOYMENTS.TASK_ID_HASH} = '_'
       |""".stripMargin

  def findTaskIdsToUpdate(): Seq[(String, String)] = {
    sqlQuery(
      STMT_SELECT_TASK_ID,
      params(),
      rs => (rs.getString(DEPLOYMENTS.DEPLOYMENT_ID), rs.getString(DEPLOYMENTS.TASK_ID))
    ).toSeq
  }

  private val STMT_UPDATE_TASK_ID_HASH =
    s"""
       |UPDATE ${DEPLOYMENTS.TABLE}
       |SET ${DEPLOYMENTS.TASK_ID_HASH} = :newTaskIdHash
       |WHERE ${DEPLOYMENTS.DEPLOYMENT_ID} = :deploymentId
       |""".stripMargin

  def updateTaskIdHash(deployId: String, taskId: String): Unit = {
    sqlUpdate(STMT_UPDATE_TASK_ID_HASH,
      params("newTaskIdHash" -> hash(taskId), "deploymentId" -> deployId),
      identity)
  }
}
