import React, { useEffect } from 'react';
import { ActionCreatorWithoutPayload } from '@reduxjs/toolkit';
import { DotAutoComplete } from '@digital-ai/dot-components';
import { TaskAttributeProps } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/attributes/types';
import { WithVariables } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/task-variables/with-variables.component';
import { getTaskDrawerState } from '../../../../../../../../../../core/xlr-ui/app/features/tasks/ducks/task-drawer.reducer';
import { useAppDispatch, useAppSelector } from '../../../../../../../../../../core/xlr-ui/app/js/hooks';
import { TaskInputPropertiesVariableOrValue, TaskInputPropertyValue, VariableType, WithTitleAndId } from '../../../../../../../../../../core/xlr-ui/app/types';
import './deployment-task-facet-common.component.less';

export interface DeploymentTaskFacetCommonProps extends TaskAttributeProps {
    onInit: ActionCreatorWithoutPayload;
    options: Array<WithTitleAndId>;
}

export const DeploymentTaskFacetCommon = ({ disabled, facet, property, options, onNewVariable, onChange, onInit }: DeploymentTaskFacetCommonProps) => {
    const { allVariables } = useAppSelector(getTaskDrawerState);
    const dispatch = useAppDispatch();

    useEffect(() => {
        dispatch(onInit());
    }, [property.fqn]);

    const value = options.find((a) => a.id === facet[property.name]) || null;

    const variableOrValue = {
        value: facet[property.name],
        variable: (facet.variableMapping || {})[property.name],
    };

    const handleVariableChange = (inputValue: TaskInputPropertyValue) => {
        onChange((inputValue as TaskInputPropertiesVariableOrValue).variable);
    };

    const handleNewVariableAdd = (variableName: string, variableType: VariableType) => {
        onNewVariable(variableName, variableType);
    };

    const handleAutoCompleteChange = (selectedValue: WithTitleAndId) => {
        onChange(selectedValue ? selectedValue.id : null);
    };

    return (
        <WithVariables
            disabled={disabled}
            displayType="Text"
            helperText={property.description}
            inputId={property.fqn}
            isRequired={property.required}
            label={property.label}
            onChange={handleVariableChange}
            onNewVariableAdd={handleNewVariableAdd}
            variableOrValue={variableOrValue}
            variableType="xlrelease.StringVariable"
            variables={allVariables}
        >
            <div className="deployment-task-facet-common">
                <DotAutoComplete
                    freesolo={false}
                    helperText={property.description}
                    inputId={property.fqn}
                    label={property.label}
                    multiple={false}
                    onChange={(_e, v) => handleAutoCompleteChange(v as WithTitleAndId)}
                    options={options}
                    persistentLabel={true}
                    readOnly={disabled}
                    required={property.required}
                    value={value}
                />
            </div>
        </WithVariables>
    );
};
