/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.actors;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.utils.FolderId;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions$;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatingActionEvent;
import com.xebialabs.xlrelease.triggers.package$;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerLifecycle;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\t\u0013\u0001uA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015A\u0007\u0001\"\u0001j\u0011%\tI\u0002AI\u0001\n\u0003\tY\u0002C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011q\n\u0001\u0005\n\u0005E\u0003bBA+\u0001\u0011%\u0011q\u000b\u0005\b\u00037\u0002A\u0011BA/\u0011\u001d\tY\u0006\u0001C\u0005\u0003\u001bCq!a%\u0001\t\u0013\t)JA\tUe&<w-\u001a:Pa\u0016\u0014\u0018\r^5p]NT!a\u0005\u000b\u0002\r\u0005\u001cGo\u001c:t\u0015\t)b#\u0001\u0005ue&<w-\u001a:t\u0015\t9\u0002$A\u0005yYJ,G.Z1tK*\u0011\u0011DG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aG\u0001\u0004G>l7\u0001A\n\u0004\u0001y!\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002&U5\taE\u0003\u0002(Q\u0005)1\u000f\u001c45U*\t\u0011&\u0001\u0005he&T(\u0010\\3e\u0013\tYcEA\u0004M_\u001e<\u0017N\\4\u0002#Q\u0014\u0018nZ4feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002/c5\tqF\u0003\u00021-\u0005Q!/\u001a9pg&$xN]=\n\u0005Iz#!\u0005+sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ss\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u00059*\u0014B\u0001\u001c0\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u0011\u0011\bP\u0007\u0002u)\u00111HF\u0001\u0007KZ,g\u000e^:\n\u0005uR$!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\u0001BO]5hO\u0016\u0014H*\u001b4fGf\u001cG.\u001a\t\u0004\u0001\u0016;U\"A!\u000b\u0005\t\u001b\u0015\u0001B5na2T!\u0001\u0012\u000b\u0002\u000fM,'O^5dK&\u0011a)\u0011\u0002\u0011)JLwmZ3s\u0019&4WmY=dY\u0016\u0004\"\u0001S&\u000e\u0003%S!A\u0013\f\u0002\r\u0011|W.Y5o\u0013\ta\u0015JA\u0004Ue&<w-\u001a:\u0002\rqJg.\u001b;?)\u0015y\u0015KU*U!\t\u0001\u0006!D\u0001\u0013\u0011\u0015aS\u00011\u0001.\u0011\u0015\u0019T\u00011\u00015\u0011\u00159T\u00011\u00019\u0011\u0015qT\u00011\u0001@\u0003\u00111\u0017N\u001c3\u0015\u0005\u001d;\u0006\"\u0002-\u0007\u0001\u0004I\u0016!\u0003;sS\u001e<WM]%e!\tQ\u0016M\u0004\u0002\\?B\u0011A\fI\u0007\u0002;*\u0011a\fH\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001\u0004\u0013A\u0002)sK\u0012,g-\u0003\u0002cG\n11\u000b\u001e:j]\u001eT!\u0001\u0019\u0011\u0002\u0015\u0005$G\r\u0016:jO\u001e,'\u000f\u0006\u0002HM\")qm\u0002a\u0001\u000f\u00069AO]5hO\u0016\u0014\u0018!D;qI\u0006$X\r\u0016:jO\u001e,'\u000fF\u0004HU2l'\u000f\u001e<\t\u000b-D\u0001\u0019A$\u0002\u0011=\u0014\u0018nZ5oC2DQa\u001a\u0005A\u0002\u001dCQA\u001c\u0005A\u0002=\f\u0001B^1mS\u0012\fG/\u001a\t\u0003?AL!!\u001d\u0011\u0003\u000f\t{w\u000e\\3b]\")1\u000f\u0003a\u0001_\u0006QQ-\\5u\u000bZ,g\u000e^:\t\u000bUD\u0001\u0019A8\u0002\u0011%tG/\u001a:oC2Dqa\u001e\u0005\u0011\u0002\u0003\u0007\u00010\u0001\u0006qe>\u0004XM\u001d;jKN\u00042!\u001f@Z\u001d\tQHP\u0004\u0002]w&\t\u0011%\u0003\u0002~A\u00059\u0001/Y2lC\u001e,\u0017bA@\u0002\u0002\t\u00191+Z9\u000b\u0005u\u0004\u0003f\u0001\u0005\u0002\u0006A!\u0011qAA\u000b\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011AC1o]>$\u0018\r^5p]*!\u0011qBA\t\u0003\u001diW\r\u001e:jGNT1!a\u0005\u001b\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\f\u0003\u0013\u0011Q\u0001V5nK\u0012\fq#\u001e9eCR,GK]5hO\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005u!f\u0001=\u0002 -\u0012\u0011\u0011\u0005\t\u0005\u0003G\tY#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0002\f\u0001JA!!\f\u0002&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001b\u0011,G.\u001a;f)JLwmZ3s)\u0011\t\u0019$!\u000f\u0011\u0007}\t)$C\u0002\u00028\u0001\u0012A!\u00168ji\")qM\u0003a\u0001\u000f\"\u001a!\"!\u0002\u0002\u000f\u0015DXmY;uKR)q)!\u0011\u0002D!)qm\u0003a\u0001\u000f\"9\u0011QI\u0006A\u0002\u0005\u001d\u0013\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\r\u0001\u0015\u0011J\u0005\u0004\u0003\u0017\n%a\u0006+sS\u001e<WM]#yK\u000e,H/[8o\u0007>tG/\u001a=uQ\rY\u0011QA\u0001\u000eK:\f'\r\\3Ue&<w-\u001a:\u0015\t\u0005M\u00121\u000b\u0005\u0006O2\u0001\raR\u0001\u0011m\u0006d\u0017\u000eZ1uK\u001a{G\u000eZ3s\u0013\u0012$B!a\r\u0002Z!)q-\u0004a\u0001\u000f\u0006y1\r[3dWZ\u000bG.\u001b3bi&|g\u000e\u0006\u0004\u00024\u0005}\u0013\u0011\r\u0005\u0006O:\u0001\ra\u0012\u0005\b\u0003Gr\u0001\u0019AA3\u0003\u0011i7oZ:\u0011\r\u0005\u001d\u0014\u0011OA;\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014\u0001B;uS2T!!a\u001c\u0002\t)\fg/Y\u0005\u0005\u0003g\nIG\u0001\u0003MSN$\b\u0003BA<\u0003\u0013k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'\u0002BA@\u0003\u0003\u000b1!\u00199j\u0015\u0011\t\u0019)!\"\u0002\rAdWoZ5o\u0015\r\t9\tG\u0001\tI\u0016\u0004Hn\\=ji&!\u00111RA=\u0005E1\u0016\r\\5eCRLwN\\'fgN\fw-\u001a\u000b\u0005\u0003g\ty\t\u0003\u0004\u0002\u0012>\u0001\raR\u0001\u0003G&\fq\"\u001e9eCR,g+\u0019:jC\ndWm\u001d\u000b\u0005\u0003g\t9\nC\u0003h!\u0001\u0007q\t")
public class TriggerOperations
implements Logging {
    private final TriggerRepository triggerRepository;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerOperations triggerOperations = this;
        synchronized (triggerOperations) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Trigger find(String triggerId) {
        return this.triggerRepository.find(triggerId);
    }

    /*
     * WARNING - void declaration
     */
    public Trigger addTrigger(Trigger trigger) {
        void var2_2;
        this.validateFolderId(trigger);
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)None$.MODULE$, (ConfigurationItem)trigger);
        this.checkValidation(trigger);
        this.updateVariables(trigger);
        CiHelper.fixUpInternalReferences((ConfigurationItem)trigger);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerCreatingActionEvent(trigger));
        Trigger addedTrigger = this.triggerRepository.create(trigger);
        this.enableTrigger(trigger);
        this.eventBus.publish((XLReleaseEvent)new TriggerCreatedEvent(addedTrigger));
        return var2_2;
    }

    @Timed
    public Trigger updateTrigger(Trigger original, Trigger trigger, boolean validate, boolean emitEvents, boolean internal, Seq<String> properties) {
        Trigger updated;
        block3: {
            this.trace((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("Updating trigger ").append(original).append(" properties: '").append(properties.mkString(",")).append("'\n         |previous: ").append(package$.MODULE$.TriggerExtensions(original).toJson()).append("\n         |new: ").append(package$.MODULE$.TriggerExtensions(trigger).toJson()).toString())).stripMargin());
            Trigger toUpdate = properties.isEmpty() ? trigger : (Trigger)CiCloneHelper.cloneCi((ConfigurationItem)original);
            toUpdate.setCiUid(original.getCiUid());
            toUpdate.setFolderId(new FolderId(trigger.getFolderId()).absolute());
            toUpdate.setId(Ids.formatWithFolderId((String)trigger.getFolderId(), (String)Ids.getName((String)trigger.getId())));
            CiHelper.fixUpInternalReferences((ConfigurationItem)toUpdate);
            if (!new FolderId(original.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
                this.validateFolderId(toUpdate);
            }
            properties.foreach((Function1 & Serializable & scala.Serializable)propertyToUpdate -> {
                toUpdate.setProperty(propertyToUpdate, trigger.getProperty(propertyToUpdate));
                return BoxedUnit.UNIT;
            });
            if (validate) {
                PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)new Some((Object)original), (ConfigurationItem)toUpdate);
                this.checkValidation(toUpdate);
                this.updateVariables(toUpdate);
                this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerUpdatingActionEvent(original, toUpdate));
            }
            updated = this.triggerRepository.update(toUpdate);
            if (!internal) {
                this.enableTrigger(updated);
            }
            if (!emitEvents) break block3;
            this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedEvent(original, updated));
        }
        return updated;
    }

    public Seq<String> updateTrigger$default$6() {
        return (Seq)Nil$.MODULE$;
    }

    @Timed
    public void deleteTrigger(Trigger trigger) {
        trigger.setEnabled(false);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerDeletingActionEvent(trigger));
        this.triggerRepository.delete(trigger.getId());
        this.enableTrigger(trigger);
        this.eventBus.publish((XLReleaseEvent)new TriggerDeletedEvent(trigger));
    }

    @Timed
    public Trigger execute(Trigger trigger, TriggerExecutionContext executionContext) {
        return this.triggerLifecycle.execute(trigger, executionContext);
    }

    private void enableTrigger(Trigger trigger) {
        if (trigger.isEnabled()) {
            this.triggerLifecycle.enable(trigger);
        } else {
            this.triggerLifecycle.disable(trigger);
        }
    }

    private void validateFolderId(Trigger trigger) {
        block0: {
            if (!new FolderId(trigger.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) break block0;
            trigger.get$validationMessages().add(new ValidationMessage(trigger.getId(), "folderId", "You cannot create trigger on the root folder. The root folder path is not supported."));
        }
    }

    private void checkValidation(Trigger trigger, List<ValidationMessage> msgs) {
        Object object = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(msgs).asScala()).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)trigger.get$validationMessages().addAll(msgs)) : BoxedUnit.UNIT;
        if (((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(trigger.get$validationMessages()).asScala()).nonEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)trigger);
        }
    }

    private void checkValidation(Trigger ci) {
        this.checkValidation(ci, this.triggerLifecycle.validate(ci));
    }

    private void updateVariables(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            List variables = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.findById(releaseTrigger.getTemplate(), ResolveOptions$.MODULE$.MINIMAL()).getVariables()).asScala()).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$1(releaseTrigger, v)))).toList()).asJava();
            Release variableHolderTemplate = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate()).withVariables(variables).build();
            variableHolderTemplate.setVariableValues((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(releaseTrigger.getTemplateVariableValues(x$1 -> !x$1.isPassword())).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$3(x$2)))).asJava());
            variableHolderTemplate.setPasswordVariableValues(releaseTrigger.getTemplatePasswordVariables());
            releaseTrigger.setVariables((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(variableHolderTemplate.getVariables()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$4(x$3)))).toList()).asJava());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$1(ReleaseTrigger x2$1, Variable v) {
        return x2$1.getVariablesByKeys().containsKey(v.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 x$2) {
        return x$2._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Variable x$3) {
        return x$3.getId() != null;
    }

    public TriggerOperations(TriggerRepository triggerRepository, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, TriggerLifecycle<Trigger> triggerLifecycle) {
        this.triggerRepository = triggerRepository;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.triggerLifecycle = triggerLifecycle;
        Logging.$init$((Logging)this);
    }
}

