/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.actors;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.utils.FolderId;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions$;
import com.xebialabs.xlrelease.triggers.action.TriggerActionExecuted;
import com.xebialabs.xlrelease.triggers.action.TriggerActionResult;
import com.xebialabs.xlrelease.triggers.action.TriggerActionSkipped;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDisabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerEnabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerExecutedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerFailedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerSkippedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatingActionEvent;
import com.xebialabs.xlrelease.triggers.package$;
import com.xebialabs.xlrelease.triggers.service.impl.RunNowExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerLifecycle;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001\u0002\n\u0014\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015I\u0007\u0001\"\u0001k\u0011%\tY\u0002AI\u0001\n\u0003\ti\u0002C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003\"CA-\u0001E\u0005I\u0011BA.\u0011\u001d\ty\u0006\u0001C\u0005\u0003CBq!!\u001a\u0001\t\u0013\t9\u0007C\u0004\u0002f\u0001!I!a&\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \n\tBK]5hO\u0016\u0014x\n]3sCRLwN\\:\u000b\u0005Q)\u0012AB1di>\u00148O\u0003\u0002\u0017/\u0005AAO]5hO\u0016\u00148O\u0003\u0002\u00193\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00035m\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003q\t1aY8n\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0006g24GG\u001b\u0006\u0002U\u0005AqM]5{u2,G-\u0003\u0002-O\t9Aj\\4hS:<\u0017!\u0005;sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ssB\u0011qFM\u0007\u0002a)\u0011\u0011gF\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001a1\u0005E!&/[4hKJ\u0014V\r]8tSR|'/_\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bCA\u00187\u0013\t9\u0004GA\tSK2,\u0017m]3SKB|7/\u001b;pef\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003uuj\u0011a\u000f\u0006\u0003y]\ta!\u001a<f]R\u001c\u0018B\u0001 <\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u0011iJLwmZ3s\u0019&4WmY=dY\u0016\u00042!\u0011$I\u001b\u0005\u0011%BA\"E\u0003\u0011IW\u000e\u001d7\u000b\u0005\u0015+\u0012aB:feZL7-Z\u0005\u0003\u000f\n\u0013\u0001\u0003\u0016:jO\u001e,'\u000fT5gK\u000eL8\r\\3\u0011\u0005%cU\"\u0001&\u000b\u0005-;\u0012A\u00023p[\u0006Lg.\u0003\u0002N\u0015\n9AK]5hO\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003Q%N#V\u000b\u0005\u0002R\u00015\t1\u0003C\u0003.\u000b\u0001\u0007a\u0006C\u00035\u000b\u0001\u0007Q\u0007C\u00039\u000b\u0001\u0007\u0011\bC\u0003@\u000b\u0001\u0007\u0001)\u0001\u0003gS:$GC\u0001%Y\u0011\u0015If\u00011\u0001[\u0003%!(/[4hKJLE\r\u0005\u0002\\E:\u0011A\f\u0019\t\u0003;\u0006j\u0011A\u0018\u0006\u0003?v\ta\u0001\u0010:p_Rt\u0014BA1\"\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\f\u0013AC1eIR\u0013\u0018nZ4feR\u0011\u0001j\u001a\u0005\u0006Q\u001e\u0001\r\u0001S\u0001\biJLwmZ3s\u00035)\b\u000fZ1uKR\u0013\u0018nZ4feR9\u0001j[7ogV<\b\"\u00027\t\u0001\u0004A\u0015\u0001C8sS\u001eLg.\u00197\t\u000b!D\u0001\u0019\u0001%\t\u000b=D\u0001\u0019\u00019\u0002\u0011Y\fG.\u001b3bi\u0016\u0004\"\u0001I9\n\u0005I\f#a\u0002\"p_2,\u0017M\u001c\u0005\u0006i\"\u0001\r\u0001]\u0001\u000bK6LG/\u0012<f]R\u001c\b\"\u0002<\t\u0001\u0004\u0001\u0018\u0001C5oi\u0016\u0014h.\u00197\t\u000faD\u0001\u0013!a\u0001s\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u0007i|(L\u0004\u0002|{:\u0011Q\f`\u0005\u0002E%\u0011a0I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t!a\u0001\u0003\u0007M+\u0017O\u0003\u0002\u007fC!\u001a\u0001\"a\u0002\u0011\t\u0005%\u0011qC\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005E\u00111C\u0001\b[\u0016$(/[2t\u0015\r\t)bG\u0001\tG>$\u0017\r[1mK&!\u0011\u0011DA\u0006\u0005\u0015!\u0016.\\3e\u0003])\b\u000fZ1uKR\u0013\u0018nZ4fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0002 )\u001a\u00110!\t,\u0005\u0005\r\u0002\u0003BA\u0013\u0003[i!!a\n\u000b\t\u0005%\u00121F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0004\"\u0013\u0011\ty#a\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007eK2,G/\u001a+sS\u001e<WM\u001d\u000b\u0005\u0003k\tY\u0004E\u0002!\u0003oI1!!\u000f\"\u0005\u0011)f.\u001b;\t\u000b!T\u0001\u0019\u0001%)\u0007)\t9!A\u0004fq\u0016\u001cW\u000f^3\u0015\u000b!\u000b\u0019%!\u0012\t\u000b!\\\u0001\u0019\u0001%\t\u000f\u0005\u001d3\u00021\u0001\u0002J\u0005\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0004\u0003\u0006-\u0013bAA'\u0005\n9BK]5hO\u0016\u0014X\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0015\u0004\u0017\u0005\u001d\u0011!D3oC\ndW\r\u0016:jO\u001e,'\u000f\u0006\u0004\u00026\u0005U\u0013q\u000b\u0005\u0006Q2\u0001\r\u0001\u0013\u0005\bi2\u0001\n\u00111\u0001q\u0003])g.\u00192mKR\u0013\u0018nZ4fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002^)\u001a\u0001/!\t\u0002!Y\fG.\u001b3bi\u00164u\u000e\u001c3fe&#G\u0003BA\u001b\u0003GBQ\u0001\u001b\bA\u0002!\u000bqb\u00195fG.4\u0016\r\\5eCRLwN\u001c\u000b\u0007\u0003k\tI'a\u001b\t\u000b!|\u0001\u0019\u0001%\t\u000f\u00055t\u00021\u0001\u0002p\u0005!Qn]4t!\u0019\t\t(a\u001f\u0002\u00005\u0011\u00111\u000f\u0006\u0005\u0003k\n9(\u0001\u0003vi&d'BAA=\u0003\u0011Q\u0017M^1\n\t\u0005u\u00141\u000f\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0002\u0006MUBAAB\u0015\u0011\t))a\"\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0003\u0002\n\u0006-\u0015aA1qS*!\u0011QRAH\u0003\u0019\u0001H.^4j]*\u0019\u0011\u0011S\r\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!&\u0002\u0004\n\tb+\u00197jI\u0006$\u0018n\u001c8NKN\u001c\u0018mZ3\u0015\t\u0005U\u0012\u0011\u0014\u0005\u0007\u00037\u0003\u0002\u0019\u0001%\u0002\u0005\rL\u0017aD;qI\u0006$XMV1sS\u0006\u0014G.Z:\u0015\t\u0005U\u0012\u0011\u0015\u0005\u0006QF\u0001\r\u0001\u0013")
public class TriggerOperations
implements Logging {
    private final TriggerRepository triggerRepository;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerOperations triggerOperations = this;
        synchronized (triggerOperations) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Trigger find(String triggerId) {
        return this.triggerRepository.find(triggerId);
    }

    /*
     * WARNING - void declaration
     */
    public Trigger addTrigger(Trigger trigger) {
        void var2_2;
        this.validateFolderId(trigger);
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)None$.MODULE$, (ConfigurationItem)trigger);
        this.checkValidation(trigger);
        this.updateVariables(trigger);
        CiHelper.fixUpInternalReferences((ConfigurationItem)trigger);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerCreatingActionEvent(trigger));
        Trigger addedTrigger = this.triggerRepository.create(trigger);
        this.eventBus.publish((XLReleaseEvent)new TriggerCreatedEvent(addedTrigger));
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        return var2_2;
    }

    @Timed
    public Trigger updateTrigger(Trigger original, Trigger trigger, boolean validate, boolean emitEvents, boolean internal, Seq<String> properties) {
        Trigger updated;
        block5: {
            Trigger trigger2;
            this.trace((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("Updating trigger ").append(original).append(" properties: '").append(properties.mkString(",")).append("'\n         |previous: ").append(package$.MODULE$.TriggerExtensions(original).toJson()).append("\n         |new: ").append(package$.MODULE$.TriggerExtensions(trigger).toJson()).toString())).stripMargin());
            if (properties.isEmpty()) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(trigger.getInternalProperties()).asScala()).foreach((Function1 & Serializable & scala.Serializable)internalProperty -> {
                    trigger.setProperty(internalProperty, original.getProperty(internalProperty));
                    return BoxedUnit.UNIT;
                });
                trigger2 = trigger;
            } else {
                trigger2 = (Trigger)CiCloneHelper.cloneCi((ConfigurationItem)original);
            }
            Trigger toUpdate = trigger2;
            toUpdate.setCiUid(original.getCiUid());
            toUpdate.setFolderId(new FolderId(trigger.getFolderId()).absolute());
            toUpdate.setId(Ids.formatWithFolderId((String)trigger.getFolderId(), (String)Ids.getName((String)trigger.getId())));
            CiHelper.fixUpInternalReferences((ConfigurationItem)toUpdate);
            if (!new FolderId(original.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
                this.validateFolderId(toUpdate);
            }
            properties.foreach((Function1 & Serializable & scala.Serializable)propertyToUpdate -> {
                toUpdate.setProperty(propertyToUpdate, trigger.getProperty(propertyToUpdate));
                return BoxedUnit.UNIT;
            });
            if (validate) {
                PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)new Some((Object)original), (ConfigurationItem)toUpdate);
                this.checkValidation(toUpdate);
                this.updateVariables(toUpdate);
                this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerUpdatingActionEvent(original, toUpdate));
            }
            updated = this.triggerRepository.update(toUpdate);
            if (!internal) {
                boolean emitStateEvent = emitEvents && (!Objects.equal((Object)BoxesRunTime.boxToBoolean((boolean)original.isEnabled()), (Object)BoxesRunTime.boxToBoolean((boolean)updated.isEnabled())) || properties.contains((Object)"enabled"));
                this.enableTrigger(updated, emitStateEvent);
            }
            if (!emitEvents) break block5;
            this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedEvent(original, updated));
        }
        return updated;
    }

    public Seq<String> updateTrigger$default$6() {
        return (Seq)Nil$.MODULE$;
    }

    @Timed
    public void deleteTrigger(Trigger trigger) {
        trigger.setEnabled(false);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerDeletingActionEvent(trigger));
        this.triggerRepository.delete(trigger.getId());
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        this.eventBus.publish((XLReleaseEvent)new TriggerDeletedEvent(trigger));
    }

    /*
     * Unable to fully structure code
     */
    @Timed
    public Trigger execute(Trigger trigger, TriggerExecutionContext executionContext) {
        block6: {
            block4: {
                block5: {
                    var7_3 = this.triggerLifecycle.execute(trigger, executionContext);
                    if (var7_3 == null) {
                        throw new MatchError(var7_3);
                    }
                    maybeExecutedTrigger = var7_3.trigger();
                    result = var7_3.results();
                    var5_6 = new Tuple2((Object)maybeExecutedTrigger, result);
                    var6_7 = var5_6;
                    maybeExecutedTrigger = (Trigger)var6_7._1();
                    var12_10 = result = (Try)var6_7._2();
                    if (var12_10 instanceof Failure) {
                        var13_11 = (Failure)var12_10;
                        e = var13_11.exception();
                        this.eventBus.publish((XLReleaseEvent)new TriggerFailedEvent(trigger, e.getMessage(), executionContext.getExecutionDataId()));
                        throw e;
                    }
                    if (!(var12_10 instanceof Success)) break block4;
                    var15_13 = (Success)var12_10;
                    actionResult = (TriggerActionResult)var15_13.value();
                    var17_15 = actionResult;
                    if (!(var17_15 instanceof TriggerActionExecuted)) break block5;
                    var18_16 = (TriggerActionExecuted)var17_15;
                    result = var18_16.result();
                    this.eventBus.publish((XLReleaseEvent)new TriggerExecutedEvent(maybeExecutedTrigger, result, executionContext.getExecutionDataId()));
                    var4_18 = BoxedUnit.UNIT;
                    break block6;
                }
                if (!(var17_15 instanceof TriggerActionSkipped)) ** GOTO lbl-1000
                var20_21 = (TriggerActionSkipped)var17_15;
                message = var20_21.message();
                if (executionContext instanceof RunNowExecutionContext) {
                    this.eventBus.publish((XLReleaseEvent)new TriggerSkippedEvent(maybeExecutedTrigger, message));
                    var4_19 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    var4_20 = BoxedUnit.UNIT;
                }
                break block6;
            }
            throw new MatchError((Object)var12_10);
        }
        var3_23 = maybeExecutedTrigger;
        return var3_23;
    }

    private void enableTrigger(Trigger trigger, boolean emitEvents) {
        block1: {
            block0: {
                if (!trigger.isEnabled()) break block0;
                this.triggerLifecycle.enable(trigger);
                if (!emitEvents) break block1;
                this.eventBus.publish((XLReleaseEvent)new TriggerEnabledEvent(trigger));
                break block1;
            }
            this.triggerLifecycle.disable(trigger);
            if (!emitEvents) break block1;
            this.eventBus.publish((XLReleaseEvent)new TriggerDisabledEvent(trigger));
        }
    }

    private boolean enableTrigger$default$2() {
        return true;
    }

    private void validateFolderId(Trigger trigger) {
        block0: {
            if (!new FolderId(trigger.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) break block0;
            trigger.get$validationMessages().add(new ValidationMessage(trigger.getId(), "folderId", "You cannot create trigger on the root folder. The root folder path is not supported."));
        }
    }

    private void checkValidation(Trigger trigger, List<ValidationMessage> msgs) {
        Object object = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(msgs).asScala()).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)trigger.get$validationMessages().addAll(msgs)) : BoxedUnit.UNIT;
        if (((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(trigger.get$validationMessages()).asScala()).nonEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)trigger);
        }
    }

    private void checkValidation(Trigger ci) {
        this.checkValidation(ci, this.triggerLifecycle.validate(ci));
    }

    private void updateVariables(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            List variables = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.findById(releaseTrigger.getTemplate(), ResolveOptions$.MODULE$.MINIMAL()).getVariables()).asScala()).filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$1(releaseTrigger, v)))).toList()).asJava();
            Release variableHolderTemplate = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate()).withVariables(variables).build();
            variableHolderTemplate.setVariableValues((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(releaseTrigger.getTemplateVariableValues(x$2 -> !x$2.isPassword())).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$3(x$3)))).asJava());
            variableHolderTemplate.setPasswordVariableValues(releaseTrigger.getTemplatePasswordVariables());
            releaseTrigger.setVariables((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(variableHolderTemplate.getVariables()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$4(x$4)))).toList()).asJava());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$1(ReleaseTrigger x2$1, Variable v) {
        return x2$1.getVariablesByKeys().containsKey(v.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 x$3) {
        return x$3._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Variable x$4) {
        return x$4.getId() != null;
    }

    public TriggerOperations(TriggerRepository triggerRepository, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, TriggerLifecycle<Trigger> triggerLifecycle) {
        this.triggerRepository = triggerRepository;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.triggerLifecycle = triggerLifecycle;
        Logging.$init$((Logging)this);
    }
}

