/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.repository.TriggerPersistenceHelper$;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerPersistence;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001\u0002\b\u0010\u0001iA\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tu\u0001\u0011\t\u0011)A\u0005i!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u00159\b\u0001\"\u0011y\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!9\u0011Q\u0002\u0001\u0005B\u0005=\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBq!a\u001c\u0001\t\u0003\n\tH\u0001\u000bTc2$&/[4hKJ\u0014V\r]8tSR|'/\u001f\u0006\u0003!E\t!B]3q_NLGo\u001c:z\u0015\t\u00112#\u0001\u0005ue&<w-\u001a:t\u0015\t!R#A\u0005yYJ,G.Z1tK*\u0011acF\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001G\u0001\u0004G>l7\u0001A\n\u0005\u0001m\tc\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\u0011j\u0011a\t\u0006\u0003!MI!!J\u0012\u0003#Q\u0013\u0018nZ4feJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002(U1j\u0011\u0001\u000b\u0006\u0003S\r\n1a]9m\u0013\tY\u0003FA\u000bJ]R,'oY3qi\u0016$'+\u001a9pg&$xN]=\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=\u001a\u0012A\u00023p[\u0006Lg.\u0003\u00022]\t9AK]5hO\u0016\u0014\u0018A\u0005;sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016,\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0003o=\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011\u0011H\u000e\u0002\u0013)JLwmZ3s!\u0016\u00148/[:uK:\u001cW-A\nue&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\u0006dS&#7+\u001a:wS\u000e,W#A\u001f\u0011\u0005y\nU\"A \u000b\u0005\u0001\u001b\u0012aB:feZL7-Z\u0005\u0003\u0005~\u00121bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"2A\u0012%J!\t9\u0005!D\u0001\u0010\u0011\u0015\u0011T\u00011\u00015\u0011\u0015YT\u00011\u0001>\u0003\u00111\u0017N\u001c3\u0016\u00051{ECA'V!\tqu\n\u0004\u0001\u0005\u000bA3!\u0019A)\u0003\u0003Q\u000b\"A\u0015\u0017\u0011\u0005q\u0019\u0016B\u0001+\u001e\u0005\u001dqu\u000e\u001e5j]\u001eDQA\u0016\u0004A\u0002]\u000b\u0011\u0002\u001e:jO\u001e,'/\u00133\u0011\u0005a{fBA-^!\tQV$D\u0001\\\u0015\ta\u0016$\u0001\u0004=e>|GOP\u0005\u0003=v\ta\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011a,\b\u0015\u0003\r\r\u0004\"\u0001\u001a6\u000e\u0003\u0015T!AZ4\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003S!T!![\n\u0002\u0005\u0011\u0014\u0017BA6f\u0005)I5OU3bI>sG.\u001f\u0015\u0003\r5\u0004\"A\\;\u000e\u0003=T!\u0001]9\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002sg\u00069Q.\u001a;sS\u000e\u001c(B\u0001;\u0018\u0003!\u0019w\u000eZ1iC2,\u0017B\u0001<p\u0005\u0015!\u0016.\\3e\u0003\u0019\u0019'/Z1uKV\u0011\u0011p\u001f\u000b\u0003ur\u0004\"AT>\u0005\u000bA;!\u0019A)\t\u000bu<\u0001\u0019\u0001>\u0002\u000fQ\u0014\u0018nZ4fe\"\u0012q!\\\u0001\u0007kB$\u0017\r^3\u0016\t\u0005\r\u0011q\u0001\u000b\u0005\u0003\u000b\tI\u0001E\u0002O\u0003\u000f!Q\u0001\u0015\u0005C\u0002ECa! \u0005A\u0002\u0005\u0015\u0001F\u0001\u0005n\u0003\u0019!W\r\\3uKR!\u0011\u0011CA\f!\ra\u00121C\u0005\u0004\u0003+i\"\u0001B+oSRDQAV\u0005A\u0002]C#!C7\u0002\u001d\u0019Lg\u000e\u001a\"z\r>dG-\u001a:JIRA\u0011qDA\u001b\u0003s\t\u0019\u0005E\u0003\u0002\"\u0005EB&\u0004\u0002\u0002$)\u0019q&!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0005I\u0006$\u0018M\u0003\u0003\u0002,\u00055\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005=\u0012aA8sO&!\u00111GA\u0012\u0005\u0011\u0001\u0016mZ3\t\r\u0005]\"\u00021\u0001X\u0003!1w\u000e\u001c3fe&#\u0007bBA\u001e\u0015\u0001\u0007\u0011QH\u0001\u000e]\u0016\u001cH/\u001a3G_2$WM]:\u0011\u0007q\ty$C\u0002\u0002Bu\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002F)\u0001\r!a\u0012\u0002\u0011A\fw-Z1cY\u0016\u0004B!!\t\u0002J%!\u00111JA\u0012\u0005!\u0001\u0016mZ3bE2,\u0007F\u0001\u0006dQ\tQQ.\u0001\rok6\u0014WM](g)\u0016l\u0007\u000f\\1uKR\u0013\u0018nZ4feN$B!!\u0016\u0002\\A\u0019A$a\u0016\n\u0007\u0005eSDA\u0002J]RDa!!\u0018\f\u0001\u00049\u0016A\u0003;f[Bd\u0017\r^3JI\"\u00121b\u0019\u0015\u0003\u00175\f\u0001CZ5oI\nKH+Z7qY\u0006$X-\u00133\u0015\r\u0005}\u0011qMA5\u0011\u0019\ti\u0006\u0004a\u0001/\"9\u0011Q\t\u0007A\u0002\u0005\u001d\u0003F\u0001\u0007dQ\taQ.\u0001\u0006gS:$')\u001f+za\u0016$b!a\b\u0002t\u0005\u0005\u0006bBA;\u001b\u0001\u0007\u0011qO\u0001\fiJLwmZ3s)f\u0004X\r\u0005\u0004\u0002z\u0005\r\u0015\u0011\u0012\b\u0005\u0003w\nyHD\u0002[\u0003{J\u0011AH\u0005\u0004\u0003\u0003k\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\u000b9I\u0001\u0003MSN$(bAAA;A!\u00111RAO\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015a\u0002:fM2,7\r\u001e\u0006\u0005\u0003'\u000b)*A\u0002ba&TA!a&\u0002\u001a\u00061\u0001\u000f\\;hS:T1!a'\u0016\u0003!!W\r\u001d7ps&$\u0018\u0002BAP\u0003\u001b\u0013A\u0001V=qK\"9\u0011QI\u0007A\u0002\u0005\u001d\u0003FA\u0007dQ\tiQ\u000eK\u0002\u0001\u0003S\u00032\u0001ZAV\u0013\r\ti+\u001a\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlTriggerRepository
implements TriggerRepository {
    private final TriggerPersistence triggerPersistence;
    private final CiIdService ciIdService;
    private Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors;

    public void registerPersistenceInterceptor(PersistenceInterceptor<Trigger> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Trigger>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    @IsReadOnly
    public <T extends Trigger> T find(String triggerId) {
        Option maybeTrigger = this.triggerPersistence().findById(Ids.getName((String)triggerId));
        return (T)((Trigger)maybeTrigger.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{triggerId});
        }));
    }

    @Timed
    public <T extends Trigger> T create(T trigger) {
        if (!Ids.isTriggerId((String)trigger.getId())) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Trigger Id [").append(trigger.getId()).append("] is not valid").toString());
        }
        TriggerPersistenceHelper$.MODULE$.fixPropertyIds(trigger, this.ciIdService());
        this.interceptCreate((ConfigurationItem)trigger);
        this.triggerPersistence().insert(trigger);
        this.afterCreate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public <T extends Trigger> T update(T trigger) {
        TriggerPersistenceHelper$.MODULE$.fixPropertyIds(trigger, this.ciIdService());
        this.interceptUpdate((ConfigurationItem)trigger);
        this.triggerPersistence().update(trigger);
        this.afterUpdate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public void delete(String triggerId) {
        this.interceptDelete(triggerId);
        this.triggerPersistence().delete(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId))));
        this.afterDelete(triggerId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByFolderId(String folderId, boolean nestedFolders, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setFolderId(folderId);
        filter.setNestedFolders(Predef$.MODULE$.boolean2Boolean(nestedFolders));
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int numberOfTemplateTriggers(String templateId) {
        return this.triggerPersistence().numberOfTemplateTriggers(templateId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByTemplateId(String templateId, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTemplateId(templateId);
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByType(List<Type> triggerType, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTriggerType((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)triggerType.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), List$.MODULE$.canBuildFrom())).asJava());
        return this.triggerPersistence().findBy(filter, pageable);
    }

    public SqlTriggerRepository(TriggerPersistence triggerPersistence, CiIdService ciIdService) {
        this.triggerPersistence = triggerPersistence;
        this.ciIdService = ciIdService;
        InterceptedRepository.$init$((InterceptedRepository)this);
    }
}

