/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.triggers.event_based.EventFilter;
import com.xebialabs.xlrelease.triggers.event_based.EventFilterExpressionItem;
import com.xebialabs.xlrelease.triggers.event_based.ExpressionEventFilter;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\t\u0013\u0001uA\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005o!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003A\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002\"\u0001!\t%a\t\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z!9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0004bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003[\u0003A\u0011BAX\u0011\u001d\t\u0019\f\u0001C\u0005\u0003kCq!!2\u0001\t\u0013\t9M\u0001\u000bTc2$&/[4hKJ\u0014V\r]8tSR|'/\u001f\u0006\u0003'Q\t!B]3q_NLGo\u001c:z\u0015\t)b#\u0001\u0005ue&<w-\u001a:t\u0015\t9\u0002$A\u0005yYJ,G.Z1tK*\u0011\u0011DG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aG\u0001\u0004G>l7\u0001A\n\u0005\u0001y!\u0013\u0006\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K\u001dj\u0011A\n\u0006\u0003'YI!\u0001\u000b\u0014\u0003#Q\u0013\u0018nZ4feJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002+[=j\u0011a\u000b\u0006\u0003Y\u0019\n1a]9m\u0013\tq3FA\u000bJ]R,'oY3qi\u0016$'+\u001a9pg&$xN]=\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I2\u0012A\u00023p[\u0006Lg.\u0003\u00025c\t9AK]5hO\u0016\u0014\u0018A\u0005;sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016,\u0012a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003uI\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011A(\u000f\u0002\u0013)JLwmZ3s!\u0016\u00148/[:uK:\u001cW-A\nue&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\u0006dS&#7+\u001a:wS\u000e,W#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r3\u0012aB:feZL7-Z\u0005\u0003\u000b\n\u00131bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"2!S&M!\tQ\u0005!D\u0001\u0013\u0011\u0015)T\u00011\u00018\u0011\u0015qT\u00011\u0001A\u0003\u00111\u0017N\u001c3\u0016\u0005=\u0013FC\u0001)Y!\t\t&\u000b\u0004\u0001\u0005\u000bM3!\u0019\u0001+\u0003\u0003Q\u000b\"!V\u0018\u0011\u0005}1\u0016BA,!\u0005\u001dqu\u000e\u001e5j]\u001eDQ!\u0017\u0004A\u0002i\u000b\u0011\u0002\u001e:jO\u001e,'/\u00133\u0011\u0005m\u0013gB\u0001/a!\ti\u0006%D\u0001_\u0015\tyF$\u0001\u0004=e>|GOP\u0005\u0003C\u0002\na\u0001\u0015:fI\u00164\u0017BA2e\u0005\u0019\u0019FO]5oO*\u0011\u0011\r\t\u0015\u0003\r\u0019\u0004\"aZ7\u000e\u0003!T!!\u001b6\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003Y-T!\u0001\u001c\f\u0002\u0005\u0011\u0014\u0017B\u00018i\u0005)I5OU3bI>sG.\u001f\u0015\u0003\rA\u0004\"!\u001d=\u000e\u0003IT!a\u001d;\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002vm\u00069Q.\u001a;sS\u000e\u001c(BA<\u001b\u0003!\u0019w\u000eZ1iC2,\u0017BA=s\u0005\u0015!\u0016.\\3e\u0003\u0019\u0019'/Z1uKV\u0011AP \u000b\u0003{~\u0004\"!\u0015@\u0005\u000bM;!\u0019\u0001+\t\r\u0005\u0005q\u00011\u0001~\u0003\u001d!(/[4hKJD#a\u00029\u0002\rU\u0004H-\u0019;f+\u0011\tI!!\u0004\u0015\t\u0005-\u0011q\u0002\t\u0004#\u00065A!B*\t\u0005\u0004!\u0006bBA\u0001\u0011\u0001\u0007\u00111\u0002\u0015\u0003\u0011A\fa\u0001Z3mKR,G\u0003BA\f\u0003;\u00012aHA\r\u0013\r\tY\u0002\t\u0002\u0005+:LG\u000fC\u0003Z\u0013\u0001\u0007!\f\u000b\u0002\na\u0006qa-\u001b8e\u0005f4u\u000e\u001c3fe&#G\u0003CA\u0013\u0003w\ty$!\u0013\u0011\u000b\u0005\u001d\u0012qG\u0018\u000e\u0005\u0005%\"b\u0001\u001a\u0002,)!\u0011QFA\u0018\u0003\u0011!\u0017\r^1\u000b\t\u0005E\u00121G\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011QG\u0001\u0004_J<\u0017\u0002BA\u001d\u0003S\u0011A\u0001U1hK\"1\u0011Q\b\u0006A\u0002i\u000b\u0001BZ8mI\u0016\u0014\u0018\n\u001a\u0005\b\u0003\u0003R\u0001\u0019AA\"\u00035qWm\u001d;fI\u001a{G\u000eZ3sgB\u0019q$!\u0012\n\u0007\u0005\u001d\u0003EA\u0004C_>dW-\u00198\t\u000f\u0005-#\u00021\u0001\u0002N\u0005A\u0001/Y4fC\ndW\r\u0005\u0003\u0002(\u0005=\u0013\u0002BA)\u0003S\u0011\u0001\u0002U1hK\u0006\u0014G.\u001a\u0015\u0003\u0015\u0019D#A\u00039\u000219,XNY3s\u001f\u001a$V-\u001c9mCR,GK]5hO\u0016\u00148\u000f\u0006\u0003\u0002\\\u0005\u0005\u0004cA\u0010\u0002^%\u0019\u0011q\f\u0011\u0003\u0007%sG\u000f\u0003\u0004\u0002d-\u0001\rAW\u0001\u000bi\u0016l\u0007\u000f\\1uK&#\u0007FA\u0006gQ\tY\u0001/\u0001\tgS:$')\u001f+f[Bd\u0017\r^3JIR1\u0011QEA7\u0003_Ba!a\u0019\r\u0001\u0004Q\u0006bBA&\u0019\u0001\u0007\u0011Q\n\u0015\u0003\u0019\u0019D#\u0001\u00049\u0002\u0015\u0019Lg\u000e\u001a\"z)f\u0004X\r\u0006\u0004\u0002&\u0005e\u0014q\u0015\u0005\b\u0003wj\u0001\u0019AA?\u0003-!(/[4hKJ$\u0016\u0010]3\u0011\r\u0005}\u0014\u0011RAH\u001d\u0011\t\t)!\"\u000f\u0007u\u000b\u0019)C\u0001\"\u0013\r\t9\tI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY)!$\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u000f\u0003\u0003\u0003BAI\u0003Gk!!a%\u000b\t\u0005U\u0015qS\u0001\be\u00164G.Z2u\u0015\u0011\tI*a'\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u001e\u0006}\u0015A\u00029mk\u001eLgNC\u0002\u0002\"b\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003K\u000b\u0019J\u0001\u0003UsB,\u0007bBA&\u001b\u0001\u0007\u0011Q\n\u0015\u0003\u001b\u0019D#!\u00049\u0002\u001d\u0019L\u0007\u0010\u0015:pa\u0016\u0014H/_%egR!\u0011qCAY\u0011\u0019\t\tA\u0004a\u0001_\u00051b-\u001b=Va6\u000b\u0007\u000f]3e!J|\u0007/\u001a:us&#7\u000f\u0006\u0003\u0002\u0018\u0005]\u0006bBA\u0001\u001f\u0001\u0007\u0011\u0011\u0018\t\u0005\u0003w\u000b\t-\u0004\u0002\u0002>*\u0019\u0011q\u0018\u000b\u0002\u0017\u00154XM\u001c;`E\u0006\u001cX\rZ\u0005\u0005\u0003\u0007\fiLA\tFm\u0016tGOQ1tK\u0012$&/[4hKJ\f1CZ5y+B,e/\u001a8u\r&dG/\u001a:JIN$B!a\u0006\u0002J\"9\u0011\u0011\u0001\tA\u0002\u0005e\u0006f\u0001\u0001\u0002NB\u0019q-a4\n\u0007\u0005E\u0007NA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class SqlTriggerRepository
implements TriggerRepository {
    private final TriggerPersistence triggerPersistence;
    private final CiIdService ciIdService;
    private Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors;

    public void registerPersistenceInterceptor(PersistenceInterceptor<Trigger> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Trigger>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    @IsReadOnly
    public <T extends Trigger> T find(String triggerId) {
        Option maybeTrigger = this.triggerPersistence().findById(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId))));
        return (T)((Trigger)maybeTrigger.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{triggerId});
        }));
    }

    @Timed
    public <T extends Trigger> T create(T trigger) {
        if (!Ids.isTriggerId((String)trigger.getId())) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Trigger Id [").append(trigger.getId()).append("] is not valid").toString());
        }
        this.fixPropertyIds(trigger);
        this.interceptCreate((ConfigurationItem)trigger);
        this.triggerPersistence().insert(trigger);
        this.afterCreate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public <T extends Trigger> T update(T trigger) {
        this.fixPropertyIds(trigger);
        this.interceptUpdate((ConfigurationItem)trigger);
        this.triggerPersistence().update(trigger);
        this.afterUpdate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public void delete(String triggerId) {
        this.interceptDelete(triggerId);
        this.triggerPersistence().delete(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId))));
        this.afterDelete(triggerId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByFolderId(String folderId, boolean nestedFolders, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setFolderId(folderId);
        filter.setNestedFolders(Predef$.MODULE$.boolean2Boolean(nestedFolders));
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int numberOfTemplateTriggers(String templateId) {
        return this.triggerPersistence().numberOfTemplateTriggers(templateId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByTemplateId(String templateId, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTemplateId(templateId);
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByType(List<Type> triggerType, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTriggerType((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)triggerType.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), List$.MODULE$.canBuildFrom())).asJava());
        return this.triggerPersistence().findBy(filter, pageable);
    }

    private void fixPropertyIds(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            VariablePersistenceHelper$.MODULE$.fixUpVariableIds(releaseTrigger.getId(), releaseTrigger.getVariables(), this.ciIdService());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (trigger2 instanceof EventBasedTrigger) {
            EventBasedTrigger eventBasedTrigger = (EventBasedTrigger)trigger2;
            this.fixUpMappedPropertyIds(eventBasedTrigger);
            this.fixUpEventFilterIds(eventBasedTrigger);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void fixUpMappedPropertyIds(EventBasedTrigger trigger) {
        Set ids = Set$.MODULE$.empty();
        trigger.getMappedProperties().forEach(mappedProperty -> {
            if (!StringUtils.hasText((String)mappedProperty.getId())) {
                String id = this.ciIdService().getUniqueId(Type.valueOf(MappedProperty.class), trigger.getId(), ids.toSet());
                ids.add((Object)id);
                mappedProperty.setId(id);
            } else {
                mappedProperty.setId(new StringBuilder(1).append(trigger.getId()).append("/").append(Ids.getName((String)mappedProperty.getId())).toString());
            }
        });
    }

    private void fixUpEventFilterIds(EventBasedTrigger trigger) {
        Option$.MODULE$.apply((Object)trigger.eventFilter()).foreach((Function1 & Serializable & scala.Serializable)eventFilter -> {
            SqlTriggerRepository.$anonfun$fixUpEventFilterIds$1(this, trigger, eventFilter);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$fixUpEventFilterIds$1(SqlTriggerRepository $this, EventBasedTrigger trigger$2, EventFilter eventFilter) {
        if (!StringUtils.hasText((String)eventFilter.getId())) {
            String id = $this.ciIdService().getUniqueId(Type.valueOf(EventFilter.class), trigger$2.getId());
            eventFilter.setId(id);
        } else {
            eventFilter.setId(new StringBuilder(1).append(trigger$2.getId()).append("/").append(Ids.getName((String)eventFilter.getId())).toString());
        }
        EventFilter eventFilter2 = eventFilter;
        if (eventFilter2 instanceof ExpressionEventFilter) {
            ExpressionEventFilter expressionEventFilter = (ExpressionEventFilter)eventFilter2;
            Set ids = Set$.MODULE$.empty();
            expressionEventFilter.expressions().forEach(expressionItem -> {
                if (!StringUtils.hasText((String)expressionItem.getId())) {
                    String id = $this.ciIdService().getUniqueId(Type.valueOf(EventFilterExpressionItem.class), eventFilter.getId(), ids.toSet());
                    ids.add((Object)id);
                    expressionItem.setId(id);
                } else {
                    expressionItem.setId(new StringBuilder(1).append(eventFilter.getId()).append("/").append(Ids.getName((String)expressionItem.getId())).toString());
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public SqlTriggerRepository(TriggerPersistence triggerPersistence, CiIdService ciIdService) {
        this.triggerPersistence = triggerPersistence;
        this.ciIdService = ciIdService;
        InterceptedRepository.$init$((InterceptedRepository)this);
    }
}

