/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.events.handler;

import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.FolderAction;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.FolderMovingAction;
import com.xebialabs.xlrelease.domain.events.TemplateDeletingAction;
import com.xebialabs.xlrelease.domain.events.TemplateMovingAction;
import com.xebialabs.xlrelease.domain.events.TemplateVariablesChangedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerLifecycle;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001\u0002\b\u0010\u0001qA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000bI\u0003A\u0011A*\t\u000bm\u0003A\u0011\u0001/\t\u000b5\u0004A\u0011\u00018\t\u000bU\u0004A\u0011\u0001<\t\u000bq\u0004A\u0011A?\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u0011Q\u0003\u0001\u0005\n\u0005]!a\u0005+sS\u001e<WM]#wK:$\b*\u00198eY\u0016\u0014(B\u0001\t\u0012\u0003\u001dA\u0017M\u001c3mKJT!AE\n\u0002\r\u00154XM\u001c;t\u0015\t!R#\u0001\u0005ue&<w-\u001a:t\u0015\t1r#A\u0005yYJ,G.Z1tK*\u0011\u0001$G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AG\u0001\u0004G>l7\u0001A\n\u0004\u0001u\u0019\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%S5\tQE\u0003\u0002'O\u0005)1\u000f\u001c45U*\t\u0001&\u0001\u0005he&T(\u0010\\3e\u0013\tQSEA\u0004M_\u001e<\u0017N\\4\u0002#Q\u0014\u0018nZ4feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002.a5\taF\u0003\u00020+\u0005Q!/\u001a9pg&$xN]=\n\u0005Er#!\u0005+sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ss\u0006\u0001bm\u001c7eKJ\u0014V\r]8tSR|'/\u001f\t\u0003[QJ!!\u000e\u0018\u0003!\u0019{G\u000eZ3s%\u0016\u0004xn]5u_JL\u0018aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"\u0001O\u001e\u000e\u0003eR!AO\u000b\u0002\u000fM,'O^5dK&\u0011A(\u000f\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\bue&<w-\u001a:TKJ4\u0018nY3\u0011\u0005}\nU\"\u0001!\u000b\u0005i\u001a\u0012B\u0001\"A\u00059!&/[4hKJ\u001cVM\u001d<jG\u0016\f\u0001\u0003\u001e:jO\u001e,'\u000fT5gK\u000eL8\r\\3\u0016\u0003\u0015\u00032AR%L\u001b\u00059%B\u0001%A\u0003\u0011IW\u000e\u001d7\n\u0005);%\u0001\u0005+sS\u001e<WM\u001d'jM\u0016\u001c\u0017p\u00197f!\tau*D\u0001N\u0015\tqU#\u0001\u0004e_6\f\u0017N\\\u0005\u0003!6\u0013q\u0001\u0016:jO\u001e,'/A\tue&<w-\u001a:MS\u001a,7-_2mK\u0002\na\u0001P5oSRtDC\u0002+W/bK&\f\u0005\u0002V\u00015\tq\u0002C\u0003,\u000f\u0001\u0007A\u0006C\u00033\u000f\u0001\u00071\u0007C\u00037\u000f\u0001\u0007q\u0007C\u0003>\u000f\u0001\u0007a\bC\u0003D\u000f\u0001\u0007Q)\u0001\fp]R+W\u000e\u001d7bi\u00164\u0016M]5bE2,7+\u001f8d)\ti\u0006\r\u0005\u0002\u001f=&\u0011ql\b\u0002\u0005+:LG\u000fC\u0003b\u0011\u0001\u0007!-A\u0003fm\u0016tG\u000f\u0005\u0002dK6\tAM\u0003\u0002\u0013\u001b&\u0011a\r\u001a\u0002\u001e)\u0016l\u0007\u000f\\1uKZ\u000b'/[1cY\u0016\u001c8\t[1oO\u0016$WI^3oi\"\u0012\u0001\u0002\u001b\t\u0003S.l\u0011A\u001b\u0006\u0003%UI!\u0001\u001c6\u0003\u0013M+(m]2sS\n,\u0017AD8o\r>dG-\u001a:N_ZLgn\u001a\u000b\u0003;>DQ\u0001]\u0005A\u0002E\fa!Y2uS>t\u0007CA2s\u0013\t\u0019HM\u0001\nG_2$WM]'pm&tw-Q2uS>t\u0007FA\u0005i\u0003AygNR8mI\u0016\u0014H)\u001a7fi&tw\r\u0006\u0002^o\")\u0001O\u0003a\u0001qB\u00111-_\u0005\u0003u\u0012\u0014ACR8mI\u0016\u0014H)\u001a7fi&tw-Q2uS>t\u0007F\u0001\u0006i\u0003Ayg\u000eV3na2\fG/Z'pm&tw\r\u0006\u0002^}\")\u0001o\u0003a\u0001\u007fB\u00191-!\u0001\n\u0007\u0005\rAM\u0001\u000bUK6\u0004H.\u0019;f\u001b>4\u0018N\\4BGRLwN\u001c\u0015\u0003\u0017!\f!c\u001c8UK6\u0004H.\u0019;f\t\u0016dW\r^5oOR\u0019Q,a\u0003\t\rAd\u0001\u0019AA\u0007!\r\u0019\u0017qB\u0005\u0004\u0003#!'A\u0006+f[Bd\u0017\r^3EK2,G/\u001b8h\u0003\u000e$\u0018n\u001c8)\u00051A\u0017\u0001F2iK\u000e\\gi\u001c7eKJ|\u0005/\u001a:bi&|g\u000eF\u0003^\u00033\t\t\u0003\u0003\u0004q\u001b\u0001\u0007\u00111\u0004\t\u0004G\u0006u\u0011bAA\u0010I\naai\u001c7eKJ\f5\r^5p]\"9\u00111E\u0007A\u0002\u0005\u0015\u0012!C8qKJ\fG/[8o!\u0011\t9#!\u000e\u000f\t\u0005%\u0012\u0011\u0007\t\u0004\u0003WyRBAA\u0017\u0015\r\tycG\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Mr$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\tID\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003gy\u0002f\u0001\u0001\u0002>A\u0019\u0011.a\u0010\n\u0007\u0005\u0005#NA\u0007Fm\u0016tG\u000fT5ti\u0016tWM\u001d")
public class TriggerEventHandler
implements Logging {
    private final TriggerRepository triggerRepository;
    private final CiIdService ciIdService;
    private final TriggerService triggerService;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerEventHandler triggerEventHandler = this;
        synchronized (triggerEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public TriggerLifecycle<Trigger> triggerLifecycle() {
        return this.triggerLifecycle;
    }

    @Subscribe
    public void onTemplateVariableSync(TemplateVariablesChangedEvent event) {
        String templateId = event.templateId();
        Buffer releaseTriggers = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.triggerRepository.findByTemplateId(templateId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).getContent()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TriggerEventHandler.$anonfun$onTemplateVariableSync$1(x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> (ReleaseTrigger)x$2, Buffer$.MODULE$.canBuildFrom());
        releaseTriggers.foreach((Function1 & Serializable & scala.Serializable)trigger -> {
            TriggerEventHandler.$anonfun$onTemplateVariableSync$3(this, event, trigger);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onFolderMoving(FolderMovingAction action) {
        this.checkFolderOperation((FolderAction)action, "move");
    }

    @Subscribe
    public void onFolderDeleting(FolderDeletingAction action) {
        this.checkFolderOperation((FolderAction)action, "delete");
    }

    @Subscribe
    public void onTemplateMoving(TemplateMovingAction action) {
        int numberOfTemplateTriggers = this.triggerRepository.numberOfTemplateTriggers(action.templateId());
        if (numberOfTemplateTriggers > 0) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Tried to move template ").append(action.templateId()).append(" with triggers").toString());
            throw new ItemInUseException("You cannot move the template because it is being used by one or more triggers", new Object[0]);
        }
    }

    @Subscribe
    public void onTemplateDeleting(TemplateDeletingAction action) {
        block0: {
            int numberOfTemplateTriggers = this.triggerRepository.numberOfTemplateTriggers(action.templateId());
            if (numberOfTemplateTriggers <= 0) break block0;
            this.triggerRepository.findByTemplateId(action.templateId(), (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).forEach(t -> $this.triggerService.deleteTrigger(t.getId()));
        }
    }

    private void checkFolderOperation(FolderAction action, String operation) {
        PageRequest all = PageRequest.of((int)0, (int)Integer.MAX_VALUE);
        Buffer triggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.triggerRepository.findByFolderId(action.folderId(), true, (Pageable)all).getContent()).asScala();
        if (triggers.nonEmpty()) {
            String triggerTitles = ((TraversableOnce)triggers.map((Function1 & Serializable & scala.Serializable)t -> t.getTitle(), Buffer$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"");
            throw new ItemInUseException(new StringBuilder(72).append("You cannot ").append(operation).append(" this folder. The folder or its subfolders contain triggers: ").append(triggerTitles).toString(), new Object[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$onTemplateVariableSync$1(Trigger x$1) {
        return x$1 instanceof ReleaseTrigger;
    }

    public static final /* synthetic */ void $anonfun$onTemplateVariableSync$3(TriggerEventHandler $this, TemplateVariablesChangedEvent event$1, ReleaseTrigger trigger) {
        Map templateVarsMap = (Map)Map$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(event$1.templateVariables()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.getKey()), v), Buffer$.MODULE$.canBuildFrom()));
        Buffer triggerVariablesNeededForTemplate = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(trigger.getVariables()).asScala()).filter((Function1 & Serializable & scala.Serializable)trigVar -> BoxesRunTime.boxToBoolean((boolean)templateVarsMap.contains((Object)trigVar.getKey())));
        Buffer updatedTriggerVars = (Buffer)triggerVariablesNeededForTemplate.flatMap((Function1 & Serializable & scala.Serializable)triggerVar -> Option$.MODULE$.option2Iterable(templateVarsMap.remove((Object)triggerVar.getKey()).map((Function1 & Serializable & scala.Serializable)templateVar -> {
            block0: {
                if (triggerVar.isValueEmpty()) break block0;
                templateVar.setUntypedValue(triggerVar.getValue());
            }
            return templateVar;
        })), Buffer$.MODULE$.canBuildFrom());
        Iterable newVariables = templateVarsMap.values();
        List newTriggerVars = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(updatedTriggerVars.$plus$plus((GenTraversableOnce)newVariables)).asJava();
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(trigger.getId(), newTriggerVars, $this.ciIdService);
        trigger.setVariables(newTriggerVars);
        $this.triggerService.updateVariables((Trigger)trigger);
    }

    public TriggerEventHandler(TriggerRepository triggerRepository, FolderRepository folderRepository, CiIdService ciIdService, TriggerService triggerService, TriggerLifecycle<Trigger> triggerLifecycle) {
        this.triggerRepository = triggerRepository;
        this.ciIdService = ciIdService;
        this.triggerService = triggerService;
        this.triggerLifecycle = triggerLifecycle;
        Logging.$init$((Logging)this);
    }
}

