/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.activity.ActivityOps;
import com.xebialabs.xlrelease.domain.ActivityCategory;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.triggers.events.TriggerEvent;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public enum TriggerActivity implements ActivityOps
{
    TRIGGER_ADDED("Added trigger '%s'", ActivityCategory.TRIGGER_EDIT),
    TRIGGER_EDITED("Edited trigger '%s'", ActivityCategory.TRIGGER_EDIT),
    TRIGGER_DELETED("Deleted trigger '%s'", ActivityCategory.TRIGGER_EDIT),
    TRIGGER_CREATE_NEW_RELEASE("Trigger '%s' created new release '%s' from template '%s'", ActivityCategory.IMPORTANT),
    OTHER("", ActivityCategory.OTHER);

    private String message;
    private Set<ActivityCategory> categories;
    private static final Map<String, TriggerActivity> BY_NAME;

    private TriggerActivity(String message, ActivityCategory ... categories) {
        this.message = message;
        LinkedHashSet myCategories = Sets.newLinkedHashSet();
        if (categories != null) {
            Collections.addAll(myCategories, categories);
        }
        this.categories = Collections.unmodifiableSet(myCategories);
    }

    public ActivityLogEntry create(Date eventTime, String username, Type targetType, String targetId, Object ... parameters) {
        return this.create(eventTime, this.name(), username, targetType, targetId, this.message, parameters);
    }

    public ActivityLogEntry create(TriggerEvent ev, BaseConfigurationItem target, Object ... parameters) {
        return this.create(ev.timestamp(), ev.username(), target.getType(), target.getId(), parameters);
    }

    public Set<ActivityCategory> getCategories() {
        return this.categories;
    }

    public static TriggerActivity safeValueOf(String name) {
        TriggerActivity activity = BY_NAME.get(name);
        return activity == null ? OTHER : activity;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TriggerActivity value : TriggerActivity.values()) {
            builder.put((Object)value.name(), (Object)value);
        }
        BY_NAME = builder.build();
    }
}

