/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutedEvent;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy(value=false)
public class ReleaseTriggerSubscriber {
    private ReleaseActorService releaseActorService;
    private XLReleaseEventBus eventBus;

    @Autowired
    public ReleaseTriggerSubscriber(ReleaseActorService releaseActorService, XLReleaseEventBus eventBus) {
        this.releaseActorService = releaseActorService;
        this.eventBus = eventBus;
    }

    @PostConstruct
    public void postConstruct() {
        this.eventBus.register((Object)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.eventBus.deregister((Object)this);
    }

    @Subscribe
    public void releaseExecuted(ReleaseExecutedEvent releaseExecutedEvent) {
        this.releaseActorService.stopSchedulerPolling(releaseExecutedEvent.release().getId());
        if (releaseExecutedEvent.release().isCreatedFromTrigger()) {
            String originTemplateId = releaseExecutedEvent.release().getOriginTemplateId();
            this.releaseActorService.decrementRunningReleasesCount(originTemplateId);
        }
    }
}

