/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\b\u0011\u0001mA\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005k!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015A\b\u0001\"\u0011z\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!a\u0004\u0001\t\u0003\n\t\u0002C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u0011Q\r\u0001\u0005B\u0005\u001d\u0004bBA9\u0001\u0011\u0005\u00131\u000f\u0005\b\u0003S\u0003A\u0011BAV\u0005Q\u0019\u0016\u000f\u001c+sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ss*\u0011\u0011CE\u0001\u000be\u0016\u0004xn]5u_JL(BA\n\u0015\u0003!!(/[4hKJ\u001c(BA\u000b\u0017\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u00181\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00023\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\b\u0012(!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111%J\u0007\u0002I)\u0011\u0011\u0003F\u0005\u0003M\u0011\u0012\u0011\u0003\u0016:jO\u001e,'OU3q_NLGo\u001c:z!\rA3&L\u0007\u0002S)\u0011!\u0006J\u0001\u0004gFd\u0017B\u0001\u0017*\u0005UIe\u000e^3sG\u0016\u0004H/\u001a3SKB|7/\u001b;pef\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u000b\u0002\r\u0011|W.Y5o\u0013\t\u0011tFA\u0004Ue&<w-\u001a:\u0002%Q\u0014\u0018nZ4feB+'o]5ti\u0016t7-Z\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001\bE\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0002;o\t\u0011BK]5hO\u0016\u0014\b+\u001a:tSN$XM\\2f\u0003M!(/[4hKJ\u0004VM]:jgR,gnY3!\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u000b\u0002\u000fM,'O^5dK&\u00111\t\u0011\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0007dS&#7+\u001a:wS\u000e,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004\u000f&S\u0005C\u0001%\u0001\u001b\u0005\u0001\u0002\"B\u001a\u0006\u0001\u0004)\u0004\"\u0002\u001f\u0006\u0001\u0004q\u0014\u0001\u00024j]\u0012,\"!\u0014)\u0015\u000593\u0006CA(Q\u0019\u0001!Q!\u0015\u0004C\u0002I\u0013\u0011\u0001V\t\u0003'6\u0002\"!\b+\n\u0005Us\"a\u0002(pi\"Lgn\u001a\u0005\u0006/\u001a\u0001\r\u0001W\u0001\niJLwmZ3s\u0013\u0012\u0004\"!\u00171\u000f\u0005is\u0006CA.\u001f\u001b\u0005a&BA/\u001b\u0003\u0019a$o\\8u}%\u0011qLH\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`=!\u0012a\u0001\u001a\t\u0003K.l\u0011A\u001a\u0006\u0003O\"\f1\u0002\u001e:b]N\f7\r^5p]*\u0011!&\u001b\u0006\u0003UR\t!\u0001\u001a2\n\u000514'AC%t%\u0016\fGm\u00148ms\"\u0012aA\u001c\t\u0003_Zl\u0011\u0001\u001d\u0006\u0003cJ\f!\"\u00198o_R\fG/[8o\u0015\t\u0019H/A\u0004nKR\u0014\u0018nY:\u000b\u0005UD\u0012\u0001C2pI\u0006D\u0017\r\\3\n\u0005]\u0004(!\u0002+j[\u0016$\u0017AB2sK\u0006$X-\u0006\u0002{yR\u001110 \t\u0003\u001fr$Q!U\u0004C\u0002ICQA`\u0004A\u0002m\fq\u0001\u001e:jO\u001e,'\u000f\u000b\u0002\b]\u00061Q\u000f\u001d3bi\u0016,B!!\u0002\u0002\nQ!\u0011qAA\u0006!\ry\u0015\u0011\u0002\u0003\u0006#\"\u0011\rA\u0015\u0005\u0007}\"\u0001\r!a\u0002)\u0005!q\u0017A\u00023fY\u0016$X\r\u0006\u0003\u0002\u0014\u0005e\u0001cA\u000f\u0002\u0016%\u0019\u0011q\u0003\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006/&\u0001\r\u0001\u0017\u0015\u0003\u00139\faBZ5oI\nKhi\u001c7eKJLE\r\u0006\u0005\u0002\"\u0005]\u00121HA#!\u0015\t\u0019#a\r.\u001b\t\t)CC\u00021\u0003OQA!!\u000b\u0002,\u0005!A-\u0019;b\u0015\u0011\ti#a\f\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\r\u0002\u0007=\u0014x-\u0003\u0003\u00026\u0005\u0015\"\u0001\u0002)bO\u0016Da!!\u000f\u000b\u0001\u0004A\u0016\u0001\u00034pY\u0012,'/\u00133\t\u000f\u0005u\"\u00021\u0001\u0002@\u0005ia.Z:uK\u00124u\u000e\u001c3feN\u00042!HA!\u0013\r\t\u0019E\b\u0002\b\u0005>|G.Z1o\u0011\u001d\t9E\u0003a\u0001\u0003\u0013\n\u0001\u0002]1hK\u0006\u0014G.\u001a\t\u0005\u0003G\tY%\u0003\u0003\u0002N\u0005\u0015\"\u0001\u0003)bO\u0016\f'\r\\3)\u0005)!\u0007F\u0001\u0006o\u0003aqW/\u001c2fe>3G+Z7qY\u0006$X\r\u0016:jO\u001e,'o\u001d\u000b\u0005\u0003/\ni\u0006E\u0002\u001e\u00033J1!a\u0017\u001f\u0005\rIe\u000e\u001e\u0005\u0007\u0003?Z\u0001\u0019\u0001-\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\r\u000b\u0002\fI\"\u00121B\\\u0001\u0011M&tGMQ=UK6\u0004H.\u0019;f\u0013\u0012$b!!\t\u0002j\u0005-\u0004BBA0\u0019\u0001\u0007\u0001\fC\u0004\u0002H1\u0001\r!!\u0013)\u00051!\u0007F\u0001\u0007o\u0003)1\u0017N\u001c3CsRK\b/\u001a\u000b\u0007\u0003C\t)(a)\t\u000f\u0005]T\u00021\u0001\u0002z\u0005YAO]5hO\u0016\u0014H+\u001f9f!\u0019\tY(!\"\u0002\f:!\u0011QPAA\u001d\rY\u0016qP\u0005\u0002?%\u0019\u00111\u0011\u0010\u0002\u000fA\f7m[1hK&!\u0011qQAE\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\re\u0004\u0005\u0003\u0002\u000e\u0006}UBAAH\u0015\u0011\t\t*a%\u0002\u000fI,g\r\\3di*!\u0011QSAL\u0003\r\t\u0007/\u001b\u0006\u0005\u00033\u000bY*\u0001\u0004qYV<\u0017N\u001c\u0006\u0004\u0003;3\u0012\u0001\u00033fa2|\u00170\u001b;\n\t\u0005\u0005\u0016q\u0012\u0002\u0005)f\u0004X\rC\u0004\u0002H5\u0001\r!!\u0013)\u00055!\u0007FA\u0007o\u000391\u0017\u000e\u001f,be&\f'\r\\3JIN$B!a\u0005\u0002.\")aP\u0004a\u0001[!\u001a\u0001!!-\u0011\u0007\u0015\f\u0019,C\u0002\u00026\u001a\u0014q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlTriggerRepository
implements TriggerRepository {
    private final TriggerPersistence triggerPersistence;
    private final CiIdService ciIdService;
    private Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors;

    public void registerPersistenceInterceptor(PersistenceInterceptor<Trigger> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Trigger>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    @IsReadOnly
    public <T extends Trigger> T find(String triggerId) {
        Option maybeTrigger = this.triggerPersistence().findById(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId))));
        return (T)((Trigger)maybeTrigger.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{triggerId});
        }));
    }

    @Timed
    public <T extends Trigger> T create(T trigger) {
        if (!Ids.isTriggerId((String)trigger.getId())) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Trigger Id [").append(trigger.getId()).append("] is not valid").toString());
        }
        this.fixVariableIds(trigger);
        this.interceptCreate((ConfigurationItem)trigger);
        this.triggerPersistence().insert(trigger);
        this.afterCreate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public <T extends Trigger> T update(T trigger) {
        this.fixVariableIds(trigger);
        this.interceptUpdate((ConfigurationItem)trigger);
        this.triggerPersistence().update(trigger);
        this.afterUpdate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public void delete(String triggerId) {
        this.interceptDelete(triggerId);
        this.triggerPersistence().delete(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId))));
        this.afterDelete(triggerId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByFolderId(String folderId, boolean nestedFolders, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setFolderId(folderId);
        filter.setNestedFolders(Predef$.MODULE$.boolean2Boolean(nestedFolders));
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int numberOfTemplateTriggers(String templateId) {
        return this.triggerPersistence().numberOfTemplateTriggers(templateId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByTemplateId(String templateId, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTemplateId(templateId);
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByType(List<Type> triggerType, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTriggerType((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)triggerType.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), List$.MODULE$.canBuildFrom())).asJava());
        return this.triggerPersistence().findBy(filter, pageable);
    }

    private void fixVariableIds(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            VariablePersistenceHelper$.MODULE$.fixUpVariableIds(releaseTrigger.getId(), releaseTrigger.getVariables(), this.ciIdService());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public SqlTriggerRepository(TriggerPersistence triggerPersistence, CiIdService ciIdService) {
        this.triggerPersistence = triggerPersistence;
        this.ciIdService = ciIdService;
        InterceptedRepository.$init$((InterceptedRepository)this);
    }
}

