/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.service;

import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.service.FolderOperationValidator;
import com.xebialabs.xlrelease.validation.FolderOperationReferenceCategory$;
import com.xebialabs.xlrelease.validation.FolderOperationValidationError;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0005y4Aa\u0002\u0005\u0001'!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0011\u0015\u0011\u0004\u0001\"\u00014\u0011\u0015A\u0004\u0001\"\u0011:\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0005}!&/[4hKJ4u\u000e\u001c3fe>\u0003XM]1uS>tg+\u00197jI\u0006$xN\u001d\u0006\u0003\u0013)\tqa]3sm&\u001cWM\u0003\u0002\f\u0019\u0005AAO]5hO\u0016\u00148O\u0003\u0002\u000e\u001d\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u001fA\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003E\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u000b\u001b?A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"aG\u000f\u000e\u0003qQ!!\u0003\u0007\n\u0005ya\"\u0001\u0007$pY\u0012,'o\u00149fe\u0006$\u0018n\u001c8WC2LG-\u0019;peB\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0006g24GG\u001b\u0006\u0002I\u0005AqM]5{u2,G-\u0003\u0002'C\t9Aj\\4hS:<\u0017aF2p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z!\tIC&D\u0001+\u0015\tYC\"\u0001\u0006sKB|7/\u001b;pefL!!\f\u0016\u0003/\r{gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\u0018!\u0005;sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u0006M\u0005\u0003c)\u0012\u0011\u0003\u0016:jO\u001e,'OU3q_NLGo\u001c:z\u0003\u0019a\u0014N\\5u}Q\u0019AGN\u001c\u0011\u0005U\u0002Q\"\u0001\u0005\t\u000b\u001d\u001a\u0001\u0019\u0001\u0015\t\u000b9\u001a\u0001\u0019A\u0018\u0002+Y\fG.\u001b3bi\u0016luN^3Pa\u0016\u0014\u0018\r^5p]R!!(\u0010&M!\t)2(\u0003\u0002=-\t!QK\\5u\u0011\u0015qD\u00011\u0001@\u0003!1w\u000e\u001c3fe&#\u0007C\u0001!H\u001d\t\tU\t\u0005\u0002C-5\t1I\u0003\u0002E%\u00051AH]8pizJ!A\u0012\f\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\rZAQa\u0013\u0003A\u0002}\n1B\\3x!\u0006\u0014XM\u001c;JI\")Q\n\u0002a\u0001\u001d\u0006AQ.Z:tC\u001e,7\u000fE\u0002P)Zk\u0011\u0001\u0015\u0006\u0003#J\u000bA!\u001e;jY*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u0005\u0011a\u0015n\u001d;\u0011\u0005]SV\"\u0001-\u000b\u0005ec\u0011A\u0003<bY&$\u0017\r^5p]&\u00111\f\u0017\u0002\u001f\r>dG-\u001a:Pa\u0016\u0014\u0018\r^5p]Z\u000bG.\u001b3bi&|g.\u0012:s_J\fqC^1mS\u0012\fG/\u001a#fY\u0016$Xm\u00149fe\u0006$\u0018n\u001c8\u0015\u0007irv\fC\u0003?\u000b\u0001\u0007q\bC\u0003N\u000b\u0001\u0007a*\u0001\u0014hKRtuN\\%oQ\u0016\u0014\u0018\u000e^3e\r>dG-\u001a:Ue&<w-\u001a:SK\u001a,'/\u001a8dKN$2A\u00199r!\r\u0019\u0007N[\u0007\u0002I*\u0011QMZ\u0001\b[V$\u0018M\u00197f\u0015\t9g#\u0001\u0006d_2dWm\u0019;j_:L!!\u001b3\u0003\u0007M+G\u000f\u0005\u0002l]6\tAN\u0003\u0002n\u0019\u00051Am\\7bS:L!a\u001c7\u0003#\t\u000b7/Z\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003?\r\u0001\u0007q\bC\u0003s\r\u0001\u0007q(A\u0006oK^4w\u000e\u001c3fe&#\u0007F\u0001\u0001u!\t)H0D\u0001w\u0015\t9\b0\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016T!!\u001f>\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011a_\u0001\u0004_J<\u0017BA?w\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class TriggerFolderOperationValidator
implements FolderOperationValidator,
Logging {
    private final ConfigurationRepository configurationRepository;
    private final TriggerRepository triggerRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerFolderOperationValidator triggerFolderOperationValidator = this;
        synchronized (triggerFolderOperationValidator) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public void validateMoveOperation(String folderId, String newParentId, List<FolderOperationValidationError> messages) {
        Set<BaseConfiguration> invalidRefs = this.getNonInheritedFolderTriggerReferences(folderId, newParentId);
        if (invalidRefs.nonEmpty()) {
            invalidRefs.map((Function1 & Serializable)invalidRef -> BoxesRunTime.boxToBoolean((boolean)TriggerFolderOperationValidator.$anonfun$validateMoveOperation$1(messages, invalidRef)));
            return;
        }
    }

    public void validateDeleteOperation(String folderId, List<FolderOperationValidationError> messages) {
        PageRequest all = PageRequest.of((int)0, (int)Integer.MAX_VALUE);
        Seq triggers = CollectionConverters$.MODULE$.ListHasAsScala(this.triggerRepository.findByFolderId(folderId, true, (Pageable)all).getContent()).asScala().toSeq();
        Seq enabledTriggers = (Seq)triggers.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.isEnabled()));
        if (enabledTriggers.nonEmpty()) {
            enabledTriggers.map((Function1 & Serializable)trigger -> BoxesRunTime.boxToBoolean((boolean)TriggerFolderOperationValidator.$anonfun$validateDeleteOperation$2(messages, trigger)));
            return;
        }
    }

    private Set<BaseConfiguration> getNonInheritedFolderTriggerReferences(String folderId, String newfolderId) {
        Seq nonInheritedConfIds = this.configurationRepository.findAllNonInheritedTriggerReferences(folderId);
        Set res = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        nonInheritedConfIds.foreach((Function1 & Serializable)confId -> {
            BaseConfiguration c = $this.configurationRepository.read(confId);
            if (c.getFolderId() != null && !newfolderId.startsWith(c.getFolderId()) && !c.getFolderId().startsWith(folderId)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Object)c));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    public static final /* synthetic */ boolean $anonfun$validateMoveOperation$1(List messages$1, BaseConfiguration invalidRef) {
        FolderOperationValidationError errorMessage = new FolderOperationValidationError(invalidRef.getId(), invalidRef.getTitle(), FolderOperationReferenceCategory$.MODULE$.CONFIGURATION_CATEGORY(), "The folder or its subfolders contain configuration reference '" + invalidRef.getTitle() + "' on triggers not inherited by the destination folder");
        return messages$1.add(errorMessage);
    }

    public static final /* synthetic */ boolean $anonfun$validateDeleteOperation$2(List messages$2, Trigger trigger) {
        FolderOperationValidationError errorMessage = new FolderOperationValidationError(trigger.getId(), trigger.getTitle(), FolderOperationReferenceCategory$.MODULE$.TRIGGER_CATEGORY(), "The folder or its subfolders contain active trigger '" + trigger.getTitle() + "', please disable it before continuing");
        return messages$2.add(errorMessage);
    }

    public TriggerFolderOperationValidator(ConfigurationRepository configurationRepository, TriggerRepository triggerRepository) {
        this.configurationRepository = configurationRepository;
        this.triggerRepository = triggerRepository;
        Logging.$init$((Logging)this);
    }
}

