/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.event_based;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.webhooks.events.domain.DeploymentServerEvent;
import com.xebialabs.xlplatform.webhooks.events.domain.Event;
import com.xebialabs.xlplatform.webhooks.events.domain.EventConsumer;
import com.xebialabs.xlplatform.webhooks.events.handlers.EventConsumerHandler;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.triggers.AbstractEventTrigger;
import com.xebialabs.xlrelease.triggers.deployment_based.StatusWebhookTrigger;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTriggerConsumer;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.event_based.EventFiltering;
import com.xebialabs.xlrelease.triggers.events.TriggerFilterFailedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerFilterPassedEvent;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.webhooks.service.EventSourceOperationService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\u0006\r\u0001]A\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011!q\u0006A!A!\u0002\u0013y\u0006\"B3\u0001\t\u00031\u0007\"B7\u0001\t\u0003r\u0007\"B>\u0001\t\u0003b\bbBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0005\u0001*e/\u001a8u\u0005\u0006\u001cX\r\u001a+sS\u001e<WM]\"p]N,X.\u001a:IC:$G.\u001a:\u000b\u00055q\u0011aC3wK:$xLY1tK\u0012T!a\u0004\t\u0002\u0011Q\u0014\u0018nZ4feNT!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001\u0001D\b\u001b=!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB!q\u0004\u000b\u00161\u001b\u0005\u0001#BA\u0011#\u0003!A\u0017M\u001c3mKJ\u001c(BA\u0012%\u0003\u0019)g/\u001a8ug*\u0011QEJ\u0001\to\u0016\u0014\u0007n\\8lg*\u0011qEE\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017BA\u0015!\u0005Q)e/\u001a8u\u0007>t7/^7fe\"\u000bg\u000e\u001a7feB\u00111FL\u0007\u0002Y)\u0011QFI\u0001\u0007I>l\u0017-\u001b8\n\u0005=b#!B#wK:$\bCA\u00193\u001b\u0005a\u0011BA\u001a\r\u0005e)e/\u001a8u\u0005\u0006\u001cX\r\u001a+sS\u001e<WM]\"p]N,X.\u001a:\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014!B:mMRR'\"A\u001d\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u000f\u001c\u0003\u000f1{wmZ5oOB\u0011\u0011'P\u0005\u0003}1\u0011a\"\u0012<f]R4\u0015\u000e\u001c;fe&tw-\u0001\bue&<w-\u001a:TKJ4\u0018nY3\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rs\u0011aB:feZL7-Z\u0005\u0003\u000b\n\u0013a\u0002\u0016:jO\u001e,'oU3sm&\u001cW-\u0001\nbaBd\u0017nY1uS>t7i\u001c8uKb$\bC\u0001%P\u001b\u0005I%B\u0001&L\u0003\u001d\u0019wN\u001c;fqRT!\u0001T'\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AT\u0001\u0004_J<\u0017B\u0001)J\u0005I\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002!=\u0004XM]1uS>t7+\u001a:wS\u000e,\u0007CA*W\u001b\u0005!&BA\"V\u0015\t)\u0003#\u0003\u0002X)\nYRI^3oiN{WO]2f\u001fB,'/\u0019;j_:\u001cVM\u001d<jG\u0016\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u00035rk\u0011a\u0017\u0006\u0003GAI!!X.\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\u0005yYJ\u001cuN\u001c4jOB\u0011\u0001mY\u0007\u0002C*\u0011!\rE\u0001\u0007G>tg-[4\n\u0005\u0011\f'!\u0003-me\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q1q\r[5kW2\u0004\"!\r\u0001\t\u000b}2\u0001\u0019\u0001!\t\u000b\u00193\u0001\u0019A$\t\u000bE3\u0001\u0019\u0001*\t\u000ba3\u0001\u0019A-\t\u000by3\u0001\u0019A0\u0002%\r|gn];nKJ\u001cuN\u001c4jORK\b/Z\u000b\u0002_B\u0011\u0001/_\u0007\u0002c*\u0011!o]\u0001\be\u00164G.Z2u\u0015\t!X/A\u0002ba&T!A^<\u0002\rAdWoZ5o\u0015\tA(#\u0001\u0005eKBdw._5u\u0013\tQ\u0018O\u0001\u0003UsB,\u0017A\u00024jYR,'\u000fF\u0003~\u0003\u0003\t\u0019\u0001\u0005\u0002\u001a}&\u0011qP\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011\u0007\u00021\u00011\u0011\u0019\t)\u0001\u0003a\u0001U\u0005)QM^3oi\u00069\u0002O]8dKN\u001cHK]5hO\u0016\u0014h)\u001b7uKJLgn\u001a\u000b\u0006{\u0006-\u0011Q\u0002\u0005\u0006E&\u0001\r\u0001\r\u0005\u0007\u0003\u000bI\u0001\u0019\u0001\u0016\u0002\u0019\r|gn];nK\u00163XM\u001c;\u0015\u000bu\f\u0019\"a\u0006\t\r\u0005U!\u00021\u00011\u00035!(/[4hKJ\u001cuN\u001c4jO\"1\u0011Q\u0001\u0006A\u0002)B3\u0001AA\u000e!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011\u0017\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005\u0015\u0012q\u0004\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class EventBasedTriggerConsumerHandler
implements EventConsumerHandler<Event, EventBasedTriggerConsumer>,
Logging,
EventFiltering {
    private final TriggerService triggerService;
    private final ApplicationContext applicationContext;
    private final EventSourceOperationService operationService;
    private final XLReleaseEventBus eventBus;
    private final XlrConfig xlrConfig;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public boolean doFilter(EventBasedTrigger trigger, Event event, ApplicationContext applicationContext) {
        return EventFiltering.doFilter$(this, trigger, event, applicationContext);
    }

    @Override
    public boolean doFilter(StatusWebhookTrigger trigger, DeploymentServerEvent event) {
        return EventFiltering.doFilter$(this, trigger, event);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean consume(EventConsumer config, Event event) {
        return EventConsumerHandler.consume$((EventConsumerHandler)this, (EventConsumer)config, (Event)event);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EventBasedTriggerConsumerHandler eventBasedTriggerConsumerHandler = this;
        synchronized (eventBasedTriggerConsumerHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Type consumerConfigType() {
        return Type.valueOf(EventBasedTriggerConsumer.class);
    }

    public boolean filter(EventBasedTriggerConsumer config, Event event) {
        if (this.xlrConfig.maintenanceModeEnabled()) {
            this.logger().debug((Function0 & Serializable)() -> "[MAINTENANCE MODE] Event filtering disabled for trigger " + config.targetId());
            return false;
        }
        Event event2 = event;
        if (event2 != null) {
            Event event3 = event2;
            if (config.enabled() && event3.getType().instanceOf(config._eventType())) {
                return this.processTriggerFiltering(config, event3);
            }
        }
        return true;
    }

    private boolean processTriggerFiltering(EventBasedTriggerConsumer config, Event event) {
        boolean bl;
        AbstractEventTrigger trigger = null;
        boolean result = true;
        Type type = config.consumerType();
        if (type.instanceOf(Type.valueOf(StatusWebhookTrigger.class))) {
            StatusWebhookTrigger statusWebhookTrigger = (StatusWebhookTrigger)this.triggerService.findById(config.targetId());
            Event mappedEvent = this.operationService.executeMapScript(statusWebhookTrigger.getEndpoint(), event);
            result = this.doFilter(statusWebhookTrigger, (DeploymentServerEvent)mappedEvent);
            trigger = statusWebhookTrigger;
        } else if (type.instanceOf(Type.valueOf(EventBasedTrigger.class))) {
            trigger = (EventBasedTrigger)this.triggerService.findById(config.targetId());
            result = this.doFilter((EventBasedTrigger)trigger, event, this.applicationContext);
        } else {
            throw new MatchError((Object)type);
        }
        try {
            this.eventBus.publish((XLReleaseEvent)new TriggerFilterPassedEvent(trigger, event.getId()));
            bl = result;
        }
        catch (Throwable e) {
            this.eventBus.publish((XLReleaseEvent)new TriggerFilterFailedEvent(trigger, e.getMessage(), event.getId()));
            throw e;
        }
        return bl;
    }

    public boolean consumeEvent(EventBasedTriggerConsumer triggerConfig, Event event) {
        this.triggerService.executeSync(triggerConfig.targetId(), new EventBasedTriggerExecutionContext(event));
        return true;
    }

    public EventBasedTriggerConsumerHandler(TriggerService triggerService, ApplicationContext applicationContext, EventSourceOperationService operationService, XLReleaseEventBus eventBus, XlrConfig xlrConfig) {
        this.triggerService = triggerService;
        this.applicationContext = applicationContext;
        this.operationService = operationService;
        this.eventBus = eventBus;
        this.xlrConfig = xlrConfig;
        EventConsumerHandler.$init$((EventConsumerHandler)this);
        Logging.$init$((Logging)this);
        EventFiltering.$init$(this);
    }
}

