package com.xebialabs.xlrelease.triggers

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.documentation.{PublicApiRef, ShowOnlyPublicApiMembers}
import com.xebialabs.xlrelease.domain.ScriptHelper.HIDDEN
import com.xebialabs.xlrelease.domain.Trigger
import com.xebialabs.xlrelease.triggers.action.TriggerAction
import com.xebialabs.xlrelease.utils.FolderId
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty.StringValue

import java.util
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false, virtual = true)
abstract class AbstractEventTrigger extends Trigger {

  @BeanProperty
  @Property(asContainment = true, category = HIDDEN, description = "Trigger action property mappings")
  var mappedProperties: util.List[MappedProperty] = new util.ArrayList[MappedProperty]()

  @BeanProperty
  @Property(required = true, category = HIDDEN, description = "The action to execute when the trigger fires")
  var triggerActionType: String = _


  def instantiateAction(): TriggerAction = {
    Type.valueOf(triggerActionType).getDescriptor.newInstance(id + "/action")
  }

  def getTemplateId: Option[String] = {
    mappedProperties.asScala.find(_.targetProperty == "templateId").collect {
      case s: StringValue => s.value
    }
  }


  def getReleaseFolderId: Option[String] = {
    mappedProperties.asScala.find(_.targetProperty == "releaseFolderId").collect {
      case s: StringValue => s.value
    }
  }

  override def getContainerId: String = {
    val folderId = FolderId(this.getFolderId)
    if (folderId.isEmpty) {
      this.getTemplateId.get
    } else {
      folderId.absolute
    }
  }
}
