/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.actors;

import com.google.common.base.Objects;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.triggers.action.TriggerActionExecuted;
import com.xebialabs.xlrelease.triggers.action.TriggerActionResult;
import com.xebialabs.xlrelease.triggers.action.TriggerActionSkipped;
import com.xebialabs.xlrelease.triggers.actors.TriggerExecutionResult;
import com.xebialabs.xlrelease.triggers.actors.TriggerLifecycle;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDisabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerEnabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerExecutedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerFailedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerSkippedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatingActionEvent;
import com.xebialabs.xlrelease.triggers.package$;
import com.xebialabs.xlrelease.triggers.scheduled.ScheduledTriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionContext;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!a\u0005A!A!\u0002\u0013i\u0005\"B*\u0001\t\u0003!\u0006\"B.\u0001\t\u0003a\u0006\"\u00026\u0001\t\u0003Y\u0007\"\u00028\u0001\t\u0003y\u0007\"CA\u0017\u0001E\u0005I\u0011AA\u0018\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003\u000bBq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x!I\u0011Q\u0010\u0001\u0012\u0002\u0013%\u0011q\u0010\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!!#\u0001\t\u0013\tY\fC\u0004\u0002D\u0002!I!!2\u0003#Q\u0013\u0018nZ4fe>\u0003XM]1uS>t7O\u0003\u0002\u0017/\u00051\u0011m\u0019;peNT!\u0001G\r\u0002\u0011Q\u0014\u0018nZ4feNT!AG\u000e\u0002\u0013ad'/\u001a7fCN,'B\u0001\u000f\u001e\u0003%AXMY5bY\u0006\u00147OC\u0001\u001f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013!B:mMRR'\"\u0001\u0017\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AL\u0015\u0003\u000f1{wmZ5oO\u0006\tBO]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005MJ\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011QG\r\u0002\u0012)JLwmZ3s%\u0016\u0004xn]5u_JL\u0018!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u0007O\u0005\u0003sI\u0012\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003!)g/\u001a8u\u0005V\u001c\bC\u0001\u001f@\u001b\u0005i$B\u0001 \u001a\u0003\u0019)g/\u001a8ug&\u0011\u0001)\u0010\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018\u0001\u0005;sS\u001e<WM\u001d'jM\u0016\u001c\u0017p\u00197f!\r\u0019EIR\u0007\u0002+%\u0011Q)\u0006\u0002\u0011)JLwmZ3s\u0019&4WmY=dY\u0016\u0004\"a\u0012&\u000e\u0003!S!!S\r\u0002\r\u0011|W.Y5o\u0013\tY\u0005JA\u0004Ue&<w-\u001a:\u00029\r|gNZ5hkJ\fG/[8o-\u0006\u0014\u0018.\u00192mKN+'O^5dKB\u0011a*U\u0007\u0002\u001f*\u0011\u0001+G\u0001\bg\u0016\u0014h/[2f\u0013\t\u0011vJ\u0001\u000fD_:4\u0017nZ;sCRLwN\u001c,be&\f'\r\\3TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0019)fk\u0016-Z5B\u00111\t\u0001\u0005\u0006_\u0019\u0001\r\u0001\r\u0005\u0006m\u0019\u0001\ra\u000e\u0005\u0006u\u0019\u0001\ra\u000f\u0005\u0006\u0003\u001a\u0001\rA\u0011\u0005\u0006\u0019\u001a\u0001\r!T\u0001\u0005M&tG\r\u0006\u0002G;\")al\u0002a\u0001?\u0006IAO]5hO\u0016\u0014\u0018\n\u001a\t\u0003A\u001et!!Y3\u0011\u0005\t\u001cS\"A2\u000b\u0005\u0011|\u0012A\u0002\u001fs_>$h(\u0003\u0002gG\u00051\u0001K]3eK\u001aL!\u0001[5\u0003\rM#(/\u001b8h\u0015\t17%\u0001\u0006bI\u0012$&/[4hKJ$\"A\u00127\t\u000b5D\u0001\u0019\u0001$\u0002\u000fQ\u0014\u0018nZ4fe\u0006iQ\u000f\u001d3bi\u0016$&/[4hKJ$\u0002B\u00129sgbTHP \u0005\u0006c&\u0001\rAR\u0001\t_JLw-\u001b8bY\")Q.\u0003a\u0001\r\")A/\u0003a\u0001k\u0006Aa/\u00197jI\u0006$X\r\u0005\u0002#m&\u0011qo\t\u0002\b\u0005>|G.Z1o\u0011\u0015I\u0018\u00021\u0001v\u0003))W.\u001b;Fm\u0016tGo\u001d\u0005\u0006w&\u0001\r!^\u0001\tS:$XM\u001d8bY\")Q0\u0003a\u0001k\u0006I2\r[3dWJ+g-\u001a:f]\u000e,\u0007+\u001a:nSN\u001c\u0018n\u001c8t\u0011!y\u0018\u0002%AA\u0002\u0005\u0005\u0011A\u00039s_B,'\u000f^5fgB)\u00111AA\u0007?:!\u0011QAA\u0005\u001d\r\u0011\u0017qA\u0005\u0002I%\u0019\u00111B\u0012\u0002\u000fA\f7m[1hK&!\u0011qBA\t\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0017\u0019\u0003fA\u0005\u0002\u0016A!\u0011qCA\u0015\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011AC1o]>$\u0018\r^5p]*!\u0011qDA\u0011\u0003\u0011\u0019wN]3\u000b\t\u0005\r\u0012QE\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAA\u0014\u0003\tIw.\u0003\u0003\u0002,\u0005e!!\u0002+j[\u0016$\u0017aF;qI\u0006$X\r\u0016:jO\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\t\tD\u000b\u0003\u0002\u0002\u0005M2FAA\u001b!\u0011\t9$a\u0010\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m1%\u0003\u0003\u0002B\u0005e\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y2/\u001a;SK2,\u0017m]3Ue&<w-\u001a:Qe>\u0004XM\u001d;jKN$b!a\u0012\u0002N\u0005E\u0003c\u0001\u0012\u0002J%\u0019\u00111J\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u001fZ\u0001\u0019\u0001$\u0002\u0011Q|W\u000b\u001d3bi\u0016DQ!\\\u0006A\u0002\u0019\u000bQ\u0002Z3mKR,GK]5hO\u0016\u0014H\u0003BA$\u0003/BQ!\u001c\u0007A\u0002\u0019C3\u0001DA\u000b\u0003\u001d)\u00070Z2vi\u0016$RARA0\u0003CBQ!\\\u0007A\u0002\u0019Cq!a\u0019\u000e\u0001\u0004\t)'\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB!\u0011qMA8\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014\u0001B5na2T!\u0001U\f\n\t\u0005E\u0014\u0011\u000e\u0002\u0018)JLwmZ3s\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRD3!DA\u000b\u00035)g.\u00192mKR\u0013\u0018nZ4feR1\u0011qIA=\u0003wBQ!\u001c\bA\u0002\u0019Cq!\u001f\b\u0011\u0002\u0003\u0007Q/A\ff]\u0006\u0014G.\u001a+sS\u001e<WM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0011\u0016\u0004k\u0006M\u0012\u0001\u0005<bY&$\u0017\r^3G_2$WM]%e)\u0011\t9%a\"\t\u000b5\u0004\u0002\u0019\u0001$\u0002\u001f\rDWmY6WC2LG-\u0019;j_:$b!a\u0012\u0002\u000e\u0006=\u0005\"B7\u0012\u0001\u00041\u0005bBAI#\u0001\u0007\u00111S\u0001\u0005[N<7\u000f\u0005\u0004\u0002\u0016\u0006}\u00151U\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006!Q\u000f^5m\u0015\t\ti*\u0001\u0003kCZ\f\u0017\u0002BAQ\u0003/\u0013A\u0001T5tiB!\u0011QUA\\\u001b\t\t9K\u0003\u0003\u0002*\u0006-\u0016A\u0003<bY&$\u0017\r^5p]*!\u0011QVAX\u0003\r\t\u0007/\u001b\u0006\u0005\u0003c\u000b\u0019,\u0001\u0004qYV<\u0017N\u001c\u0006\u0004\u0003k[\u0012\u0001\u00033fa2|\u00170\u001b;\n\t\u0005e\u0016q\u0015\u0002\u0012-\u0006d\u0017\u000eZ1uS>tW*Z:tC\u001e,GCBA$\u0003{\u000b\t\r\u0003\u0004\u0002@J\u0001\rAR\u0001\u0003G&DQ! \nA\u0002U\fq\"\u001e9eCR,g+\u0019:jC\ndWm\u001d\u000b\u0005\u0003\u000f\n9\rC\u0003n'\u0001\u0007a\t")
public class TriggerOperations
implements Logging {
    private final TriggerRepository triggerRepository;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private final ConfigurationVariableService configurationVariableService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerOperations triggerOperations = this;
        synchronized (triggerOperations) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Trigger find(String triggerId) {
        return this.triggerRepository.find(triggerId);
    }

    public Trigger addTrigger(Trigger trigger) {
        this.validateFolderId(trigger);
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)None$.MODULE$, (ConfigurationItem)trigger);
        this.checkValidation(trigger, true);
        this.updateVariables(trigger);
        CiHelper.fixUpInternalReferences((ConfigurationItem)trigger);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerCreatingActionEvent(trigger));
        Trigger addedTrigger = this.triggerRepository.create(trigger);
        this.eventBus.publish((XLReleaseEvent)new TriggerCreatedEvent(addedTrigger));
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        return addedTrigger;
    }

    @Timed
    public Trigger updateTrigger(Trigger original, Trigger trigger, boolean validate2, boolean emitEvents, boolean internal, boolean checkReferencePermissions, scala.collection.immutable.Seq<String> properties) {
        Trigger updated;
        block5: {
            Trigger trigger2;
            this.trace((Function0<Object>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Updating trigger " + original + " properties: '" + properties.mkString(",") + "'\n         |previous: " + package$.MODULE$.TriggerExtensions(original).toJson() + "\n         |new: " + package$.MODULE$.TriggerExtensions(trigger).toJson())));
            if (properties.isEmpty()) {
                CollectionConverters$.MODULE$.ListHasAsScala(trigger.getInternalProperties()).asScala().foreach((Function1 & Serializable)internalProperty -> {
                    trigger.setProperty(internalProperty, original.getProperty(internalProperty));
                    return BoxedUnit.UNIT;
                });
                trigger2 = trigger;
            } else {
                trigger2 = (Trigger)CiCloneHelper.cloneCi((ConfigurationItem)original);
            }
            Trigger toUpdate = trigger2;
            toUpdate.setCiUid(original.getCiUid());
            toUpdate.setFolderId(new FolderId(trigger.getFolderId()).absolute());
            toUpdate.setId(Ids.formatWithFolderId((String)trigger.getFolderId(), (String)Ids.getName((String)trigger.getId())));
            CiHelper.fixUpInternalReferences((ConfigurationItem)toUpdate);
            if (!new FolderId(original.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
                this.validateFolderId(toUpdate);
            }
            properties.foreach((Function1 & Serializable)propertyToUpdate -> {
                toUpdate.setProperty(propertyToUpdate, trigger.getProperty(propertyToUpdate));
                return BoxedUnit.UNIT;
            });
            this.setReleaseTriggerProperties(toUpdate, trigger);
            if (validate2) {
                PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)new Some((Object)original), (ConfigurationItem)toUpdate);
                this.checkValidation(toUpdate, checkReferencePermissions);
                this.updateVariables(toUpdate);
                this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerUpdatingActionEvent(original, toUpdate));
            }
            updated = this.triggerRepository.update(toUpdate);
            if (!internal) {
                boolean emitStateEvent = emitEvents && (!Objects.equal((Object)BoxesRunTime.boxToBoolean((boolean)original.isEnabled()), (Object)BoxesRunTime.boxToBoolean((boolean)updated.isEnabled())) || properties.contains((Object)"enabled"));
                this.enableTrigger(updated, emitStateEvent);
            }
            if (!emitEvents) break block5;
            this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedEvent(original, updated));
        }
        return updated;
    }

    public scala.collection.immutable.Seq<String> updateTrigger$default$7() {
        return (scala.collection.immutable.Seq)Nil$.MODULE$;
    }

    private void setReleaseTriggerProperties(Trigger toUpdate, Trigger trigger) {
        Trigger trigger2 = toUpdate;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            releaseTrigger.setReleaseFolder(((ReleaseTrigger)trigger).getReleaseFolder());
            return;
        }
    }

    @Timed
    public void deleteTrigger(Trigger trigger) {
        trigger.setEnabled(false);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerDeletingActionEvent(trigger));
        this.triggerRepository.delete(trigger.getId());
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        this.eventBus.publish((XLReleaseEvent)new TriggerDeletedEvent(trigger));
    }

    @Timed
    public Trigger execute(Trigger trigger, TriggerExecutionContext executionContext) {
        Try result;
        Trigger x$1 = trigger;
        GlobalVariables x$2 = this.configurationVariableService.resolveFromCi$default$2();
        Function1 x$3 = this.configurationVariableService.resolveFromCi$default$3((ConfigurationItem)x$1, x$2);
        this.configurationVariableService.resolveFromCi((ConfigurationItem)x$1, x$2, x$3);
        TriggerExecutionResult<Trigger> triggerExecutionResult = this.triggerLifecycle.execute(trigger, executionContext);
        if (triggerExecutionResult == null) {
            throw new MatchError(triggerExecutionResult);
        }
        Trigger maybeExecutedTrigger = triggerExecutionResult.trigger();
        Try<TriggerActionResult> result2 = triggerExecutionResult.results();
        Tuple2 tuple2 = new Tuple2((Object)maybeExecutedTrigger, result2);
        Trigger maybeExecutedTrigger2 = (Trigger)tuple2._1();
        Try try_ = result = (Try)tuple2._2();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.eventBus.publish((XLReleaseEvent)new TriggerFailedEvent(trigger, e.getMessage(), executionContext.getExecutionDataId()));
            throw e;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            TriggerActionResult actionResult = (TriggerActionResult)success.value();
            TriggerActionResult triggerActionResult = actionResult;
            if (triggerActionResult instanceof TriggerActionExecuted) {
                TriggerActionExecuted triggerActionExecuted = (TriggerActionExecuted)triggerActionResult;
                String result3 = triggerActionExecuted.result();
                this.eventBus.publish((XLReleaseEvent)new TriggerExecutedEvent(maybeExecutedTrigger2, result3, executionContext.getExecutionDataId()));
            } else if (triggerActionResult instanceof TriggerActionSkipped) {
                TriggerActionSkipped triggerActionSkipped = (TriggerActionSkipped)triggerActionResult;
                String message = triggerActionSkipped.message();
                if (!(executionContext instanceof ScheduledTriggerExecutionContext)) {
                    this.eventBus.publish((XLReleaseEvent)new TriggerSkippedEvent(maybeExecutedTrigger2, message, executionContext.getExecutionDataId()));
                }
            }
            return maybeExecutedTrigger2;
        }
        throw new MatchError((Object)try_);
    }

    private void enableTrigger(Trigger trigger, boolean emitEvents) {
        if (trigger.isEnabled()) {
            this.triggerLifecycle.enable(trigger, true);
            if (emitEvents) {
                this.eventBus.publish((XLReleaseEvent)new TriggerEnabledEvent(trigger));
                return;
            }
            return;
        }
        this.triggerLifecycle.disable(trigger);
        if (emitEvents) {
            this.eventBus.publish((XLReleaseEvent)new TriggerDisabledEvent(trigger));
            return;
        }
    }

    private boolean enableTrigger$default$2() {
        return true;
    }

    private void validateFolderId(Trigger trigger) {
        if (new FolderId(trigger.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
            trigger.get$validationMessages().add(new ValidationMessage(trigger.getId(), "folderId", "You cannot create trigger on the root folder. The root folder path is not supported."));
            return;
        }
    }

    private void checkValidation(Trigger trigger, List<ValidationMessage> msgs) {
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(msgs).asScala().nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)trigger.get$validationMessages().addAll(msgs)) : BoxedUnit.UNIT;
        if (CollectionConverters$.MODULE$.ListHasAsScala(trigger.get$validationMessages()).asScala().nonEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)trigger);
        }
    }

    private void checkValidation(Trigger ci, boolean checkReferencePermissions) {
        this.checkValidation(ci, this.triggerLifecycle.validate(ci, checkReferencePermissions));
    }

    private void updateVariables(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            List variables = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.findById(releaseTrigger.getTemplate(), ResolveOptions$.MODULE$.WITH_DECORATORS()).getVariables()).asScala().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$1(releaseTrigger, v)))).toList()).asJava();
            Release variableHolderTemplate = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate()).withVariables(variables).build();
            variableHolderTemplate.setVariableValues(CollectionConverters$.MODULE$.MutableMapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(releaseTrigger.getTemplateVariableValues(x$2 -> !x$2.isPassword())).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$3(x$3)))).asJava());
            variableHolderTemplate.setPasswordVariableValues(releaseTrigger.getTemplatePasswordVariables());
            releaseTrigger.setVariables(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variableHolderTemplate.getVariables()).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$4(x$4)))).toList()).asJava());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$1(ReleaseTrigger x2$1, Variable v) {
        return x2$1.getVariablesByKeys().containsKey(v.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 x$3) {
        return x$3._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Variable x$4) {
        return x$4.getId() != null;
    }

    public TriggerOperations(TriggerRepository triggerRepository, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, TriggerLifecycle<Trigger> triggerLifecycle, ConfigurationVariableService configurationVariableService) {
        this.triggerRepository = triggerRepository;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.triggerLifecycle = triggerLifecycle;
        this.configurationVariableService = configurationVariableService;
        Logging.$init$((Logging)this);
    }
}

