/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.deployment_based.validators;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.triggers.TriggerValidator;
import com.xebialabs.xlrelease.triggers.deployment_based.StatusWebhookTrigger;
import com.xebialabs.xlrelease.webhooks.consumers.StatusWebhookEventSource;
import scala.;
import scala.$less$colon$less$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00054A!\u0002\u0004\u0001'!)\u0001\u0007\u0001C\u0001c!)A\u0007\u0001C!k!)1\t\u0001C\u0005\t\")1\n\u0001C\u0005\u0019\ni2\u000b^1ukN<VM\u00195p_.$&/[4hKJ4\u0016\r\\5eCR|'O\u0003\u0002\b\u0011\u0005Qa/\u00197jI\u0006$xN]:\u000b\u0005%Q\u0011\u0001\u00053fa2|\u00170\\3oi~\u0013\u0017m]3e\u0015\tYA\"\u0001\u0005ue&<w-\u001a:t\u0015\tia\"A\u0005yYJ,G.Z1tK*\u0011q\u0002E\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!E\u0001\u0004G>l7\u0001A\n\u0005\u0001QaB\u0006\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005!A.\u00198h\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\f\u0003\r=\u0013'.Z2u!\rib\u0005K\u0007\u0002=)\u0011q\u0004I\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'BA\u0011#\u0003\r\t\u0007/\u001b\u0006\u0003G\u0011\na\u0001\u001d7vO&t'BA\u0013\u000f\u0003!!W\r\u001d7ps&$\u0018BA\u0014\u001f\u0005%1\u0016\r\\5eCR|'\u000f\u0005\u0002*U5\t\u0001\"\u0003\u0002,\u0011\t!2\u000b^1ukN<VM\u00195p_.$&/[4hKJ\u0004\"!\f\u0018\u000e\u0003)I!a\f\u0006\u0003!Q\u0013\u0018nZ4feZ\u000bG.\u001b3bi>\u0014\u0018A\u0002\u001fj]&$h\bF\u00013!\t\u0019\u0004!D\u0001\u0007\u0003!1\u0018\r\\5eCR,Gc\u0001\u001c=}A\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t!QK\\5u\u0011\u0015i$\u00011\u0001)\u0003\u001d!(/[4hKJDQa\u0010\u0002A\u0002\u0001\u000bqaY8oi\u0016DH\u000f\u0005\u0002\u001e\u0003&\u0011!I\b\u0002\u0012-\u0006d\u0017\u000eZ1uS>t7i\u001c8uKb$\u0018AJ2iK\u000e\\GK]5hO\u0016\u0014hi\u001c7eKJ\fe\u000eZ*pkJ\u001cWMR8mI\u0016\u0014X*\u0019;dQR\u0019a'\u0012&\t\u000b\u0019\u001b\u0001\u0019A$\u0002\u001f\u0015DH/\u001a8eK\u0012\u001cuN\u001c;fqR\u0004\"!\b%\n\u0005%s\"!G#yi\u0016tG-\u001a3WC2LG-\u0019;j_:\u001cuN\u001c;fqRDQ!P\u0002A\u0002!\nAd\u00195fG.4\u0015\u000e\u001c;fe&twMR5fY\u0012\u001c\bK]3tK:\u001cW\rF\u00037\u001b:{E\fC\u0003G\t\u0001\u0007q\tC\u0003>\t\u0001\u0007\u0001\u0006C\u0003Q\t\u0001\u0007\u0011+\u0001\u0005baB$\u0016\u000e\u001e7f!\t\u0011\u0016L\u0004\u0002T/B\u0011A\u000bO\u0007\u0002+*\u0011aKE\u0001\u0007yI|w\u000e\u001e \n\u0005aC\u0014A\u0002)sK\u0012,g-\u0003\u0002[7\n11\u000b\u001e:j]\u001eT!\u0001\u0017\u001d\t\u000bu#\u0001\u0019\u00010\u0002%\u0011,\u0007\u000f\\8z[\u0016tGo\u0015;biV\u001cXm\u001d\t\u0004%~\u000b\u0016B\u00011\\\u0005\r\u0019V\r\u001e")
public class StatusWebhookTriggerValidator
implements Validator<StatusWebhookTrigger>,
TriggerValidator {
    @Override
    public void checkTemplatePresence(ExtendedValidationContext extendedContext, Trigger trigger, String templateId) {
        TriggerValidator.checkTemplatePresence$(this, extendedContext, trigger, templateId);
    }

    @Override
    public void checkTemplateFolderAndTriggerFolderMatch(ExtendedValidationContext extendedContext, Trigger trigger, String templateId) {
        TriggerValidator.checkTemplateFolderAndTriggerFolderMatch$(this, extendedContext, trigger, templateId);
    }

    @Override
    public void checkReleaseTitlePresence(ExtendedValidationContext extendedContext, Trigger trigger, String releaseTitle) {
        TriggerValidator.checkReleaseTitlePresence$(this, extendedContext, trigger, releaseTitle);
    }

    @Override
    public void checkMalformedVariableNamesInMappings(Trigger trigger, ExtendedValidationContext extendedContext) {
        TriggerValidator.checkMalformedVariableNamesInMappings$(this, trigger, extendedContext);
    }

    public void validate(StatusWebhookTrigger trigger, ValidationContext context) {
        ExtendedValidationContext extendedContext = (ExtendedValidationContext)context;
        StatusWebhookEventSource statusWebhookEventSource = trigger.getEndpoint();
        if (statusWebhookEventSource == null) {
            extendedContext.error((ConfigurationItem)trigger, "endpoint", "Trigger endpoint is required", new Object[0]);
        } else if (trigger.getEndpoint().getEventSource() == null) {
            extendedContext.error((ConfigurationItem)trigger, "endpoint.eventSource", "Trigger endpoint event source is required", new Object[0]);
        }
        String templateId = (String)trigger.getTemplateId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        String releaseTitle = (String)trigger.getReleaseTitle().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Set<String> deploymentStatuses = trigger.getDeploymentStatuses();
        String appTitle = trigger.getApplicationTitle();
        this.checkTemplatePresence(extendedContext, trigger, templateId);
        this.checkTemplateFolderAndTriggerFolderMatch(extendedContext, trigger, templateId);
        this.checkTriggerFolderAndSourceFolderMatch(extendedContext, trigger);
        this.checkReleaseTitlePresence(extendedContext, trigger, releaseTitle);
        this.checkFilteringFieldsPresence(extendedContext, trigger, appTitle, deploymentStatuses);
        this.checkMalformedVariableNamesInMappings(trigger, extendedContext);
    }

    private void checkTriggerFolderAndSourceFolderMatch(ExtendedValidationContext extendedContext, StatusWebhookTrigger trigger) {
        if (trigger.getEndpoint() != null && trigger.getEndpoint().getEventSource() != null) {
            String eventFolderId = (String)trigger.getEndpoint().getEventSource().getProperty("folderId");
            String endpointFolderId = trigger.getEndpoint().getFolderId();
            if (!(Strings.isNullOrEmpty((String)endpointFolderId) || Strings.isNullOrEmpty((String)eventFolderId) || eventFolderId.equals(endpointFolderId))) {
                extendedContext.error((ConfigurationItem)trigger, "eventSource", "Event source folder id does not match endpoint folder id", new Object[0]);
            }
            if (!(Strings.isNullOrEmpty((String)trigger.getFolderId()) || Strings.isNullOrEmpty((String)endpointFolderId) || Strings.isNullOrEmpty((String)eventFolderId) || trigger.getFolderId().contains(Ids.getName((String)eventFolderId)))) {
                extendedContext.error((ConfigurationItem)trigger, "eventSource", "Couldn't set eventSource that doesn't belong to the folder['" + trigger.getFolderId() + "']", new Object[0]);
                return;
            }
            return;
        }
    }

    private void checkFilteringFieldsPresence(ExtendedValidationContext extendedContext, StatusWebhookTrigger trigger, String appTitle, Set<String> deploymentStatuses) {
        if (Strings.isNullOrEmpty((String)appTitle)) {
            extendedContext.error((ConfigurationItem)trigger, "applicationTitle", "Application title is required", new Object[0]);
        }
        if (deploymentStatuses == null || deploymentStatuses.isEmpty()) {
            extendedContext.error((ConfigurationItem)trigger, "deploymentStatuses", "Trigger does not have associated statuses", new Object[0]);
            return;
        }
    }

    public StatusWebhookTriggerValidator() {
        TriggerValidator.$init$(this);
    }
}

