package com.xebialabs.xlrelease.triggers.repository

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.{ReleaseTrigger, Trigger}
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.service.CiIdService
import com.xebialabs.xlrelease.triggers.event_based.{EventBasedTrigger, EventFilter, EventFilterExpressionItem, ExpressionEventFilter}
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper.fixUpVariableIds
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty
import org.springframework.util.StringUtils.hasText

import scala.collection.mutable

object TriggerPersistenceHelper {
  def fixPropertyIds(trigger: Trigger, ciIdService: CiIdService): Unit = {
    trigger match {
      case t: ReleaseTrigger => fixUpVariableIds(t.getId, t.getVariables, ciIdService)
      case t: EventBasedTrigger =>
        fixUpMappedPropertyIds(t, ciIdService)
        fixUpEventFilterIds(t, ciIdService)
      case _ =>
    }
  }

  private def fixUpMappedPropertyIds(trigger: EventBasedTrigger, ciIdService: CiIdService): Unit = {
    val ids = mutable.Set.empty[String]

    trigger.getMappedProperties.forEach { mappedProperty =>
      if (!hasText(mappedProperty.getId)) {
        val id = ciIdService.getUniqueId(Type.valueOf(classOf[MappedProperty]), trigger.getId, ids.toSet)
        ids.add(id)
        mappedProperty.setId(id)
      } else {
        mappedProperty.setId(trigger.getId + "/" + Ids.getName(mappedProperty.getId))
      }
    }
  }

  private def fixUpEventFilterIds(trigger: EventBasedTrigger, ciIdService: CiIdService): Unit = {
    Option(trigger.eventFilter).foreach { eventFilter =>
      if (!hasText(eventFilter.getId)) {
        val id = ciIdService.getUniqueId(Type.valueOf(classOf[EventFilter]), trigger.getId)
        eventFilter.setId(id)
      } else {
        eventFilter.setId(trigger.getId + "/" + Ids.getName(eventFilter.getId))
      }

      eventFilter match {
        case filter: ExpressionEventFilter =>
          val ids = mutable.Set.empty[String]

          filter.expressions.forEach { expressionItem =>
            if (!hasText(expressionItem.getId)) {
              val id = ciIdService.getUniqueId(Type.valueOf(classOf[EventFilterExpressionItem]), eventFilter.getId, ids.toSet)
              ids.add(id)
              expressionItem.setId(id)
            } else {
              expressionItem.setId(eventFilter.getId + "/" + Ids.getName(expressionItem.getId))
            }
          }
        case _ =>
      }
    }
  }
}
