/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.events.handler;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderAction;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.TemplateDeletingAction;
import com.xebialabs.xlrelease.domain.events.TemplateMovingAction;
import com.xebialabs.xlrelease.domain.events.TemplateVariablesChangedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.TriggerConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001\u0002\u0007\u000e\u0001iA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015Q\b\u0001\"\u0001|\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000b\u00111\u0003\u0016:jO\u001e,'/\u0012<f]RD\u0015M\u001c3mKJT!AD\b\u0002\u000f!\fg\u000e\u001a7fe*\u0011\u0001#E\u0001\u0007KZ,g\u000e^:\u000b\u0005I\u0019\u0012\u0001\u0003;sS\u001e<WM]:\u000b\u0005Q)\u0012!\u0003=me\u0016dW-Y:f\u0015\t1r#A\u0005yK\nL\u0017\r\\1cg*\t\u0001$A\u0002d_6\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00051\u0013\u0001C4sSjTH.\u001a3\n\u0005!\u001a#a\u0002'pO\u001eLgnZ\u0001\u0012iJLwmZ3s%\u0016\u0004xn]5u_JL\bCA\u0016/\u001b\u0005a#BA\u0017\u0014\u0003)\u0011X\r]8tSR|'/_\u0005\u0003_1\u0012\u0011\u0003\u0016:jO\u001e,'OU3q_NLGo\u001c:z\u0003!\"(/[4hKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,\u0007+\u001a:tSN$XM\\2f!\t\u0011\u0014(D\u00014\u0015\t!T'A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0006\u0003m]\n1\u0002]3sg&\u001cH/\u001a8dK*\u0011\u0001\bL\u0001\u0004gFd\u0017B\u0001\u001e4\u0005!\"&/[4hKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,\u0007+\u001a:tSN$XM\\2f\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u001a\u0012aB:feZL7-Z\u0005\u0003\u0003z\u00121bQ5JIN+'O^5dK\u0006qAO]5hO\u0016\u00148+\u001a:wS\u000e,\u0007C\u0001#G\u001b\u0005)%BA \u0012\u0013\t9UI\u0001\bUe&<w-\u001a:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0015QE*\u0014(P!\tY\u0005!D\u0001\u000e\u0011\u0015IS\u00011\u0001+\u0011\u0015\u0001T\u00011\u00012\u0011\u0015YT\u00011\u0001=\u0011\u0015\u0011U\u00011\u0001D\u0003Yyg\u000eV3na2\fG/\u001a,be&\f'\r\\3Ts:\u001cGC\u0001*V!\ta2+\u0003\u0002U;\t!QK\\5u\u0011\u00151f\u00011\u0001X\u0003\u0015)g/\u001a8u!\tAF,D\u0001Z\u0015\t\u0001\"L\u0003\u0002\\'\u00051Am\\7bS:L!!X-\u0003;Q+W\u000e\u001d7bi\u00164\u0016M]5bE2,7o\u00115b]\u001e,G-\u0012<f]RD#AB0\u0011\u0005\u0001\u0014W\"A1\u000b\u0005A\u0019\u0012BA2b\u0005%\u0019VOY:de&\u0014W-\u0001\fp]\u000e{gNZ5hkJ\fG/[8o+B$\u0017\r^3e)\t\u0011f\rC\u0003W\u000f\u0001\u0007q\r\u0005\u0002YQ&\u0011\u0011.\u0017\u0002\u001a\u0007>tg-[4ve\u0006$\u0018n\u001c8Va\u0012\fG/\u001a3Fm\u0016tG\u000f\u000b\u0002\b?\u0006\u0001rN\u001c$pY\u0012,'\u000fR3mKRLgn\u001a\u000b\u0003%6DQA\u001c\u0005A\u0002=\fa!Y2uS>t\u0007C\u0001-q\u0013\t\t\u0018L\u0001\u000bG_2$WM\u001d#fY\u0016$\u0018N\\4BGRLwN\u001c\u0015\u0003\u0011}\u000b\u0001c\u001c8UK6\u0004H.\u0019;f\u001b>4\u0018N\\4\u0015\u0005I+\b\"\u00028\n\u0001\u00041\bC\u0001-x\u0013\tA\u0018L\u0001\u000bUK6\u0004H.\u0019;f\u001b>4\u0018N\\4BGRLwN\u001c\u0015\u0003\u0013}\u000b!c\u001c8UK6\u0004H.\u0019;f\t\u0016dW\r^5oOR\u0011!\u000b \u0005\u0006]*\u0001\r! \t\u00031zL!a`-\u0003-Q+W\u000e\u001d7bi\u0016$U\r\\3uS:<\u0017i\u0019;j_:D#AC0\u0002#\u0011|G)\u001a7fi\u0016|\u0005/\u001a:bi&|g\u000eF\u0002S\u0003\u000fAaA\\\u0006A\u0002\u0005%\u0001c\u0001-\u0002\f%\u0019\u0011QB-\u0003\u0019\u0019{G\u000eZ3s\u0003\u000e$\u0018n\u001c8)\u0007\u0001\t\t\u0002E\u0002a\u0003'I1!!\u0006b\u00055)e/\u001a8u\u0019&\u001cH/\u001a8fe\u0002")
public class TriggerEventHandler
implements Logging {
    private final TriggerRepository triggerRepository;
    private final TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence;
    private final CiIdService ciIdService;
    private final TriggerService triggerService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerEventHandler triggerEventHandler = this;
        synchronized (triggerEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void onTemplateVariableSync(TemplateVariablesChangedEvent event) {
        String templateId = event.templateId();
        Buffer releaseTriggers = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.triggerRepository.findByTemplateId(templateId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).getContent()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TriggerEventHandler.$anonfun$onTemplateVariableSync$1(x$1)))).map((Function1 & Serializable)x$2 -> (ReleaseTrigger)x$2);
        releaseTriggers.foreach((Function1 & Serializable)trigger -> {
            TriggerEventHandler.$anonfun$onTemplateVariableSync$3(this, event, trigger);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onConfigurationUpdated(ConfigurationUpdatedEvent event) {
        Seq triggers = this.triggerConfigurationReferencePersistence.getReferencingEntities(event.updated().getId());
        triggers.foreach((Function1 & Serializable)triggerRow -> {
            TriggerEventHandler.$anonfun$onConfigurationUpdated$1(this, triggerRow);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onFolderDeleting(FolderDeletingAction action) {
        this.doDeleteOperation((FolderAction)action);
    }

    @Subscribe
    public void onTemplateMoving(TemplateMovingAction action) {
        int numberOfTemplateTriggers = this.triggerRepository.numberOfTemplateTriggers(action.templateId());
        if (numberOfTemplateTriggers > 0) {
            this.logger().warn((Function0 & Serializable)() -> "Tried to move template " + action.templateId() + " with triggers");
            throw new ItemInUseException("You cannot move the template because it is being used by one or more triggers", new Object[0]);
        }
    }

    @Subscribe
    public void onTemplateDeleting(TemplateDeletingAction action) {
        int numberOfTemplateTriggers = this.triggerRepository.numberOfTemplateTriggers(action.templateId());
        if (numberOfTemplateTriggers > 0) {
            this.triggerRepository.findByTemplateId(action.templateId(), (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).forEach(t -> $this.triggerService.deleteTrigger(t.getId()));
            return;
        }
    }

    private void doDeleteOperation(FolderAction action) {
        PageRequest all = PageRequest.of((int)0, (int)Integer.MAX_VALUE);
        Seq triggers = CollectionConverters$.MODULE$.ListHasAsScala(this.triggerRepository.findByFolderId(action.folderId(), true, (Pageable)all).getContent()).asScala().toSeq();
        triggers.foreach((Function1 & Serializable)t -> {
            this.triggerService.deleteTrigger(t.getId());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$onTemplateVariableSync$1(Trigger x$1) {
        return x$1 instanceof ReleaseTrigger;
    }

    public static final /* synthetic */ void $anonfun$onTemplateVariableSync$3(TriggerEventHandler $this, TemplateVariablesChangedEvent event$1, ReleaseTrigger trigger) {
        Map templateVarsMap = (Map)Map$.MODULE$.apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(event$1.templateVariables()).asScala().map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.getKey()), (Object)CiCloneHelper.cloneCi((ConfigurationItem)v)))).toSeq());
        Buffer triggerVariablesNeededForTemplate = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(trigger.getVariables()).asScala().filter((Function1 & Serializable)trigVar -> BoxesRunTime.boxToBoolean((boolean)templateVarsMap.contains((Object)trigVar.getKey())));
        Buffer updatedTriggerVars = (Buffer)triggerVariablesNeededForTemplate.flatMap((Function1 & Serializable)triggerVar -> templateVarsMap.remove((Object)triggerVar.getKey()).map((Function1 & Serializable)templateVar -> {
            block0: {
                if (triggerVar.isValueEmpty()) break block0;
                templateVar.setUntypedValue(triggerVar.getValue());
            }
            return templateVar;
        }));
        Iterable newVariables = templateVarsMap.values();
        List newTriggerVars = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)updatedTriggerVars.$plus$plus((IterableOnce)newVariables)).asJava();
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(trigger.getId(), newTriggerVars, $this.ciIdService);
        trigger.setVariables(newTriggerVars);
        $this.triggerService.updateVariables((Trigger)trigger);
    }

    public static final /* synthetic */ void $anonfun$onConfigurationUpdated$1(TriggerEventHandler $this, ConfigurationReferenceRow triggerRow) {
        Trigger trigger = $this.triggerService.findById(triggerRow.id());
        $this.triggerService.refreshTrigger(trigger);
    }

    public TriggerEventHandler(TriggerRepository triggerRepository, TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence, CiIdService ciIdService, TriggerService triggerService) {
        this.triggerRepository = triggerRepository;
        this.triggerConfigurationReferencePersistence = triggerConfigurationReferencePersistence;
        this.ciIdService = ciIdService;
        this.triggerService = triggerService;
        Logging.$init$((Logging)this);
    }
}

