package com.xebialabs.xlrelease.triggers.events.handler

import com.xebialabs.xlrelease.api.v1.TriggersApi
import com.xebialabs.xlrelease.domain.events._
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.repository.Ids
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service


@Service
@EventListener
class TriggerManagementEventHandler @Autowired()(triggersApi: TriggersApi) {

  @Subscribe
  def releaseCreated(releaseCreatedEvent: ReleaseCreatedEvent): Unit = {
    if (releaseCreatedEvent.source.isInstanceOf[Imported] || releaseCreatedEvent.source.isInstanceOf[CreatedFromDsl]) {
      val templateId = releaseCreatedEvent.release.getId
      val parentId = releaseCreatedEvent.release.findFolderId();
      releaseCreatedEvent.release.getReleaseTriggers.forEach(trigger => {
        trigger.setEnabled(false)
        trigger.resetExecutionId()
        if (!Ids.isRoot(parentId)) {
          trigger.setFolderId(parentId);
          trigger.setTemplate(templateId)
          triggersApi.addTrigger(trigger);
        }
      })
    }
  }

}
