/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.triggers.event_based.EventFilter;
import com.xebialabs.xlrelease.triggers.event_based.EventFilterExpressionItem;
import com.xebialabs.xlrelease.triggers.event_based.ExpressionEventFilter;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty;
import java.io.Serializable;
import org.springframework.util.StringUtils;
import scala.Function1;
import scala.Option$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;

public final class TriggerPersistenceHelper$ {
    public static final TriggerPersistenceHelper$ MODULE$ = new TriggerPersistenceHelper$();

    public void fixPropertyIds(Trigger trigger, CiIdService ciIdService) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            VariablePersistenceHelper$.MODULE$.fixUpVariableIds(releaseTrigger.getId(), releaseTrigger.getVariables(), ciIdService);
            return;
        }
        if (trigger2 instanceof EventBasedTrigger) {
            EventBasedTrigger eventBasedTrigger = (EventBasedTrigger)trigger2;
            this.fixUpMappedPropertyIds(eventBasedTrigger, ciIdService);
            this.fixUpEventFilterIds(eventBasedTrigger, ciIdService);
            return;
        }
    }

    private void fixUpMappedPropertyIds(EventBasedTrigger trigger, CiIdService ciIdService) {
        Set ids = (Set)Set$.MODULE$.empty();
        trigger.getMappedProperties().forEach(mappedProperty -> {
            if (!StringUtils.hasText((String)mappedProperty.getId())) {
                String id = ciIdService.getUniqueId(Type.valueOf(MappedProperty.class), trigger.getId(), ids.toSet());
                ids.add((Object)id);
                mappedProperty.setId(id);
                return;
            }
            mappedProperty.setId(trigger.getId() + "/" + Ids.getName((String)mappedProperty.getId()));
        });
    }

    private void fixUpEventFilterIds(EventBasedTrigger trigger, CiIdService ciIdService) {
        Option$.MODULE$.apply((Object)trigger.eventFilter()).foreach((Function1 & Serializable)eventFilter -> {
            TriggerPersistenceHelper$.$anonfun$fixUpEventFilterIds$1(ciIdService, trigger, eventFilter);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$fixUpEventFilterIds$1(CiIdService ciIdService$2, EventBasedTrigger trigger$2, EventFilter eventFilter) {
        if (!StringUtils.hasText((String)eventFilter.getId())) {
            String id = ciIdService$2.getUniqueId(Type.valueOf(EventFilter.class), trigger$2.getId());
            eventFilter.setId(id);
        } else {
            eventFilter.setId(trigger$2.getId() + "/" + Ids.getName((String)eventFilter.getId()));
        }
        EventFilter eventFilter2 = eventFilter;
        if (eventFilter2 instanceof ExpressionEventFilter) {
            ExpressionEventFilter expressionEventFilter = (ExpressionEventFilter)eventFilter2;
            Set ids = (Set)Set$.MODULE$.empty();
            expressionEventFilter.expressions().forEach(expressionItem -> {
                if (!StringUtils.hasText((String)expressionItem.getId())) {
                    String id = ciIdService$2.getUniqueId(Type.valueOf(EventFilterExpressionItem.class), eventFilter.getId(), ids.toSet());
                    ids.add((Object)id);
                    expressionItem.setId(id);
                    return;
                }
                expressionItem.setId(eventFilter.getId() + "/" + Ids.getName((String)expressionItem.getId()));
            });
            return;
        }
    }

    private TriggerPersistenceHelper$() {
    }
}

