package com.xebialabs.xlrelease.triggers.actors

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.spring.configuration.ExecutorNames.RELEASE_TRIGGER_EXECUTOR_NAME
import com.xebialabs.xlrelease.support.pekko.spring.SpringActor
import com.xebialabs.xlrelease.triggers.actors.TriggerActor.TriggerAction
import org.apache.pekko.actor.{Actor, ActorLogging, ActorRef}
import org.springframework.beans.factory.annotation.Qualifier

import java.util.concurrent.ExecutorService

object TriggerProcessingActor {
  def name = "trigger-processing-actor"
}

@SpringActor
class TriggerProcessingActor(xlrConfig: XlrConfig,
                             triggerOperations: TriggerOperations,
                             @Qualifier(RELEASE_TRIGGER_EXECUTOR_NAME)
                             triggerExecutor: ExecutorService) extends Actor with ActorLogging {
  private def createOrFind(triggerId: String, msg: AnyRef): ActorRef = {
    context.child(triggerId.triggerActorName).getOrElse {
      log.debug(s"TriggerProcessingActor - creating an actor tree for $triggerId (triggered by $msg)")
      context.actorOf(
        TriggerActor.props(xlrConfig, triggerOperations, triggerExecutor),
        triggerId.triggerActorName
      )
    }
  }

  override def receive: Receive = {
    case msg: TriggerAction => createOrFind(msg.triggerId, msg) forward msg
  }

}
