package com.xebialabs.xlrelease.triggers.scheduled.quartz

import com.xebialabs.xlrelease.triggers.scheduled.ScheduledTriggerExecutionContext
import com.xebialabs.xlrelease.triggers.service.TriggerService
import grizzled.slf4j.Logging
import org.quartz._
import org.springframework.beans.factory.annotation.Autowired

import scala.util.{Failure, Success, Try}

class TriggerQuartzJob extends Job with Logging {

  @Autowired
  var triggerService: TriggerService = _

  override def execute(context: JobExecutionContext): Unit = {
    val jobKey = context.getJobDetail.getKey
    val triggerId = jobKey.getName
    Try {
      triggerService.execute(triggerId, ScheduledTriggerExecutionContext())
    } match {
      case Failure(ex) => logger.error(s"Unable to execute trigger $triggerId", ex)
      case Success(_) => logger.debug(s"Started trigger job $jobKey")
    }
  }

}
