/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.RemoveTriggeredReleaseCondition;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.repository.TriggerPersistenceHelper$;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggeredReleaseRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\t%b\u0001\u0002\n\u0014\u0001yA\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0001\"Aq\t\u0001BC\u0002\u0013\u0005\u0001\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003J\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u00151\u0006\u0001\"\u0011X\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!a\u0007\u0001\t\u0003\ni\u0002C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\t\u0019\r\u0001C!\u0003\u000bDq!!>\u0001\t\u0003\n9\u0010C\u0004\u0003\b\u0001!\tE!\u0003\t\u000f\t]\u0001\u0001\"\u0011\u0003\u001a\t!2+\u001d7Ue&<w-\u001a:SKB|7/\u001b;pefT!\u0001F\u000b\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0017/\u0005AAO]5hO\u0016\u00148O\u0003\u0002\u00193\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u00035m\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003q\t1aY8n\u0007\u0001\u0019R\u0001A\u0010&UY\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014)\u001b\u00059#B\u0001\u000b\u0018\u0013\tIsEA\tUe&<w-\u001a:SKB|7/\u001b;pef\u00042a\u000b\u00181\u001b\u0005a#BA\u0017(\u0003\r\u0019\u0018\u000f\\\u0005\u0003_1\u0012Q#\u00138uKJ\u001cW\r\u001d;fIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00022i5\t!G\u0003\u00024/\u00051Am\\7bS:L!!\u000e\u001a\u0003\u000fQ\u0013\u0018nZ4feB\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0006g24GG\u001b\u0006\u0002w\u0005AqM]5{u2,G-\u0003\u0002>q\t9Aj\\4hS:<\u0017A\u0005;sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016,\u0012\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007N\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011QI\u0011\u0002\u0013)JLwmZ3s!\u0016\u00148/[:uK:\u001cW-A\nue&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\u0006dS&#7+\u001a:wS\u000e,W#A%\u0011\u0005)kU\"A&\u000b\u00051;\u0012aB:feZL7-Z\u0005\u0003\u001d.\u00131bQ5JIN+'O^5dK\u0006a1-[%e'\u0016\u0014h/[2fA\u00051A(\u001b8jiz\"2A\u0015+V!\t\u0019\u0006!D\u0001\u0014\u0011\u0015qT\u00011\u0001A\u0011\u00159U\u00011\u0001J\u0003\u00111\u0017N\u001c3\u0016\u0005a[FCA-b!\tQ6\f\u0004\u0001\u0005\u000bq3!\u0019A/\u0003\u0003Q\u000b\"A\u0018\u0019\u0011\u0005\u0001z\u0016B\u00011\"\u0005\u001dqu\u000e\u001e5j]\u001eDQA\u0019\u0004A\u0002\r\f\u0011\u0002\u001e:jO\u001e,'/\u00133\u0011\u0005\u0011\\gBA3j!\t1\u0017%D\u0001h\u0015\tAW$\u0001\u0004=e>|GOP\u0005\u0003U\u0006\na\u0001\u0015:fI\u00164\u0017B\u00017n\u0005\u0019\u0019FO]5oO*\u0011!.\t\u0015\u0003\r=\u0004\"\u0001]=\u000e\u0003ET!A]:\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002uk\u0006!1m\u001c:f\u0015\t1x/\u0001\u0006nS\u000e\u0014x.\\3uKJT\u0011\u0001_\u0001\u0003S>L!A_9\u0003\u000bQKW.\u001a3)\u0005\u0019a\bcA?\u0002\b5\taPC\u0002\u0000\u0003\u0003\t1\u0002\u001e:b]N\f7\r^5p]*\u0019Q&a\u0001\u000b\u0007\u0005\u0015q#\u0001\u0002eE&\u0019\u0011\u0011\u0002@\u0003\u0015%\u001b(+Z1e\u001f:d\u00170\u0001\u0004de\u0016\fG/Z\u000b\u0005\u0003\u001f\t\u0019\u0002\u0006\u0003\u0002\u0012\u0005U\u0001c\u0001.\u0002\u0014\u0011)Al\u0002b\u0001;\"9\u0011qC\u0004A\u0002\u0005E\u0011a\u0002;sS\u001e<WM\u001d\u0015\u0003\u000f=\fa!\u001e9eCR,W\u0003BA\u0010\u0003G!B!!\t\u0002&A\u0019!,a\t\u0005\u000bqC!\u0019A/\t\u000f\u0005]\u0001\u00021\u0001\u0002\"!\u0012\u0001b\\\u0001\u0007I\u0016dW\r^3\u0015\t\u00055\u00121\u0007\t\u0004A\u0005=\u0012bAA\u0019C\t!QK\\5u\u0011\u0015\u0011\u0017\u00021\u0001dQ\tIq.\u0001\bgS:$')\u001f$pY\u0012,'/\u00133\u0015\u0011\u0005m\u0012\u0011KA+\u0003?\u0002R!!\u0010\u0002NAj!!a\u0010\u000b\u0007M\n\tE\u0003\u0003\u0002D\u0005\u0015\u0013\u0001\u00023bi\u0006TA!a\u0012\u0002J\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002L\u0005\u0019qN]4\n\t\u0005=\u0013q\b\u0002\u0005!\u0006<W\r\u0003\u0004\u0002T)\u0001\raY\u0001\tM>dG-\u001a:JI\"9\u0011q\u000b\u0006A\u0002\u0005e\u0013!\u00048fgR,GMR8mI\u0016\u00148\u000fE\u0002!\u00037J1!!\u0018\"\u0005\u001d\u0011un\u001c7fC:Dq!!\u0019\u000b\u0001\u0004\t\u0019'\u0001\u0005qC\u001e,\u0017M\u00197f!\u0011\ti$!\u001a\n\t\u0005\u001d\u0014q\b\u0002\t!\u0006<W-\u00192mK\"\u0012!b\u001c\u0015\u0003\u0015q\f\u0001D\\;nE\u0016\u0014xJ\u001a+f[Bd\u0017\r^3Ue&<w-\u001a:t)\u0011\t\t(a\u001e\u0011\u0007\u0001\n\u0019(C\u0002\u0002v\u0005\u00121!\u00138u\u0011\u0019\tIh\u0003a\u0001G\u0006QA/Z7qY\u0006$X-\u00133)\u0005-y\u0007FA\u0006}\u0003A1\u0017N\u001c3CsR+W\u000e\u001d7bi\u0016LE\r\u0006\u0004\u0002<\u0005\r\u0015Q\u0011\u0005\u0007\u0003sb\u0001\u0019A2\t\u000f\u0005\u0005D\u00021\u0001\u0002d!\u0012Ab\u001c\u0015\u0003\u0019q\f!BZ5oI\nKH+\u001f9f)\u0019\tY$a$\u0002>\"9\u0011\u0011S\u0007A\u0002\u0005M\u0015a\u0003;sS\u001e<WM\u001d+za\u0016\u0004b!!&\u0002 \u0006\u0015f\u0002BAL\u00037s1AZAM\u0013\u0005\u0011\u0013bAAOC\u00059\u0001/Y2lC\u001e,\u0017\u0002BAQ\u0003G\u0013A\u0001T5ti*\u0019\u0011QT\u0011\u0011\t\u0005\u001d\u0016\u0011X\u0007\u0003\u0003SSA!a+\u0002.\u00069!/\u001a4mK\u000e$(\u0002BAX\u0003c\u000b1!\u00199j\u0015\u0011\t\u0019,!.\u0002\rAdWoZ5o\u0015\r\t9,G\u0001\tI\u0016\u0004Hn\\=ji&!\u00111XAU\u0005\u0011!\u0016\u0010]3\t\u000f\u0005\u0005T\u00021\u0001\u0002d!\u0012Qb\u001c\u0015\u0003\u001bq\f\u0001eZ3u%Vtg.\u001b8h)JLwmZ3sK\u0012\u0014V\r\\3bg\u0016\u001c8i\\;oiR!\u0011\u0011OAd\u0011\u001d\tIM\u0004a\u0001\u0003\u0017\fQ\u0002^3na2\fG/Z\"j+&$\u0007\u0003BAg\u0003WtA!a4\u0002h:!\u0011\u0011[As\u001d\u0011\t\u0019.a9\u000f\t\u0005U\u0017\u0011\u001d\b\u0005\u0003/\fyN\u0004\u0003\u0002Z\u0006ugb\u00014\u0002\\&\tA$\u0003\u0002\u001b7%\u0011\u0001$G\u0005\u0003)]I!!L\u0014\n\u0005\rc\u0013\u0002BAO\u0003ST!a\u0011\u0017\n\t\u00055\u0018q\u001e\u0002\u0006\u0007&,\u0016\u000e\u001a\u0006\u0005\u0003;\u000bI\u000f\u000b\u0002\u000f_\"\u0012a\u0002`\u0001\u0017S:\u001cXM\u001d;Ue&<w-\u001a:fIJ+G.Z1tKRA\u0011QFA}\u0003{\u0014\t\u0001C\u0004\u0002|>\u0001\r!a3\u0002\u0017Q,W\u000e\u001d7bi\u0016,\u0016\u000e\u001a\u0005\b\u0003\u007f|\u0001\u0019AAf\u0003)!(/[4hKJ,\u0016\u000e\u001a\u0005\b\u0005\u0007y\u0001\u0019AAf\u0003M!(/[4hKJ,GMU3mK\u0006\u001cX-V5eQ\tyq.\u0001\fsK6|g/\u001a+sS\u001e<WM]3e%\u0016dW-Y:f)\u0011\tiCa\u0003\t\u000f\t5\u0001\u00031\u0001\u0003\u0010\u0005I1m\u001c8eSRLwN\u001c\t\u0004M\tE\u0011b\u0001B\nO\ty\"+Z7pm\u0016$&/[4hKJ,GMU3mK\u0006\u001cXmQ8oI&$\u0018n\u001c8)\u0005Ay\u0017!F4fiR+g.\u00198u\u0013\u00124uN\u001d+sS\u001e<WM\u001d\u000b\u0004G\nm\u0001\"\u00022\u0012\u0001\u0004\u0019\u0007FA\tpQ\t\tB\u0010K\u0002\u0001\u0005G\u00012! B\u0013\u0013\r\u00119C \u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlTriggerRepository
implements TriggerRepository,
Logging {
    private final TriggerPersistence triggerPersistence;
    private final CiIdService ciIdService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Trigger> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTriggerRepository sqlTriggerRepository = this;
        synchronized (sqlTriggerRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    @IsReadOnly
    public <T extends Trigger> T find(String triggerId) {
        Option maybeTrigger = Ids.isInRelease((String)triggerId) ? this.triggerPersistence().findById(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId)))) : this.triggerPersistence().findById(Ids.getName((String)triggerId));
        return (T)((Trigger)maybeTrigger.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{triggerId});
        }));
    }

    @Timed
    public <T extends Trigger> T create(T trigger) {
        if (!Ids.isTriggerId((String)trigger.getId())) {
            throw new IllegalArgumentException("Trigger Id [" + trigger.getId() + "] is not valid");
        }
        TriggerPersistenceHelper$.MODULE$.fixPropertyIds(trigger, this.ciIdService());
        this.interceptCreate((ConfigurationItem)trigger);
        this.triggerPersistence().insert(trigger);
        this.afterCreate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public <T extends Trigger> T update(T trigger) {
        TriggerPersistenceHelper$.MODULE$.fixPropertyIds(trigger, this.ciIdService());
        this.interceptUpdate((ConfigurationItem)trigger);
        this.triggerPersistence().update(trigger);
        this.afterUpdate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public void delete(String triggerId) {
        this.interceptDelete(triggerId);
        this.triggerPersistence().delete(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId))));
        this.afterDelete(triggerId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByFolderId(String folderId, boolean nestedFolders, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setFolderId(folderId);
        filter.setNestedFolders(Predef$.MODULE$.boolean2Boolean(nestedFolders));
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int numberOfTemplateTriggers(String templateId) {
        return this.triggerPersistence().numberOfTemplateTriggers(templateId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByTemplateId(String templateId, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTemplateId(templateId);
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByType(List<Type> triggerType, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTriggerType(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)triggerType.map((Function1 & Serializable)x$1 -> x$1.toString())).asJava());
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int getRunningTriggeredReleasesCount(Integer templateCiUid) {
        int total = this.triggerPersistence().getRunningTriggeredReleasesCount(templateCiUid);
        this.logger().debug((Function0 & Serializable)() -> "getRunningTriggeredReleasesCount: templateCiUid=" + templateCiUid + ", total=" + total);
        return total;
    }

    @Timed
    public void insertTriggeredRelease(Integer templateUid, Integer triggerUid, Integer triggeredReleaseUid) {
        this.logger().debug((Function0 & Serializable)() -> "insertTriggeredRelease: templateUid=" + templateUid + ", triggerUid=" + triggerUid + ", triggeredReleaseUid=" + triggeredReleaseUid);
        TriggeredReleaseRow row = new TriggeredReleaseRow(templateUid, triggerUid, triggeredReleaseUid);
        this.triggerPersistence().insertTriggeredReleaseRow(row);
    }

    @Timed
    public void removeTriggeredRelease(RemoveTriggeredReleaseCondition condition) {
        this.logger().debug((Function0 & Serializable)() -> "removeTriggeredRelease: " + condition);
        this.triggerPersistence().removeTriggeredReleasesRow(condition);
    }

    @Timed
    @IsReadOnly
    public String getTenantIdForTrigger(String triggerId) {
        return this.triggerPersistence().getTenantIdForTrigger(Ids.getName((String)triggerId));
    }

    public SqlTriggerRepository(TriggerPersistence triggerPersistence, CiIdService ciIdService) {
        this.triggerPersistence = triggerPersistence;
        this.ciIdService = ciIdService;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
    }
}

