/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.id.IdCreator$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.RemoveTriggeredReleaseCondition;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.repository.TriggerPersistenceHelper$;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggeredReleaseRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\tma\u0001B\t\u0013\u0001uA\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u007f!Aa\t\u0001BC\u0002\u0013\u0005q\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003I\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005U\u0002\u0001\"\u0011\u00028!9\u00111\u000e\u0001\u0005B\u00055\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\t\t\r\u0001C!\u0003\u0007Dq!!=\u0001\t\u0003\n\u0019\u0010C\u0004\u0003\u0004\u0001!\tE!\u0002\u0003)M\u000bH\u000e\u0016:jO\u001e,'OU3q_NLGo\u001c:z\u0015\t\u0019B#\u0001\u0006sKB|7/\u001b;pefT!!\u0006\f\u0002\u0011Q\u0014\u0018nZ4feNT!a\u0006\r\u0002\u0013ad'/\u001a7fCN,'BA\r\u001b\u0003%AXMY5bY\u0006\u00147OC\u0001\u001c\u0003\r\u0019w.\\\u0002\u0001'\u0015\u0001a\u0004J\u00156!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011QeJ\u0007\u0002M)\u00111CF\u0005\u0003Q\u0019\u0012\u0011\u0003\u0016:jO\u001e,'OU3q_NLGo\u001c:z!\rQSfL\u0007\u0002W)\u0011AFJ\u0001\u0004gFd\u0017B\u0001\u0018,\u0005UIe\u000e^3sG\u0016\u0004H/\u001a3SKB|7/\u001b;pef\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\f\u0002\r\u0011|W.Y5o\u0013\t!\u0014GA\u0004Ue&<w-\u001a:\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014!B:mMRR'\"\u0001\u001e\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001P\u001c\u0003\u000f1{wmZ5oO\u0006\u0011BO]5hO\u0016\u0014\b+\u001a:tSN$XM\\2f+\u0005y\u0004C\u0001!D\u001b\u0005\t%B\u0001\"\u0013\u0003-\u0001XM]:jgR,gnY3\n\u0005\u0011\u000b%A\u0005+sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016\f1\u0003\u001e:jO\u001e,'\u000fU3sg&\u001cH/\u001a8dK\u0002\n1bY5JIN+'O^5dKV\t\u0001\n\u0005\u0002J\u00196\t!J\u0003\u0002L-\u000591/\u001a:wS\u000e,\u0017BA'K\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0019\rL\u0017\nZ*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)\r\t6\u000b\u0016\t\u0003%\u0002i\u0011A\u0005\u0005\u0006{\u0015\u0001\ra\u0010\u0005\u0006\r\u0016\u0001\r\u0001S\u0001\u0005M&tG-\u0006\u0002X5R\u0011\u0001\f\u0019\t\u00033jc\u0001\u0001B\u0003\\\r\t\u0007ALA\u0001U#\tiv\u0006\u0005\u0002 =&\u0011q\f\t\u0002\b\u001d>$\b.\u001b8h\u0011\u0015\tg\u00011\u0001c\u0003%!(/[4hKJLE\r\u0005\u0002dU:\u0011A\r\u001b\t\u0003K\u0002j\u0011A\u001a\u0006\u0003Or\ta\u0001\u0010:p_Rt\u0014BA5!\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%\u0004\u0003F\u0001\u0004o!\ty\u00070D\u0001q\u0015\t\t(/\u0001\u0006b]:|G/\u0019;j_:T!a\u001d;\u0002\t\r|'/\u001a\u0006\u0003kZ\f!\"\\5de>lW\r^3s\u0015\u00059\u0018AA5p\u0013\tI\bOA\u0003US6,G\r\u000b\u0002\u0007wB\u0019A0!\u0002\u000e\u0003uT!A`@\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0004Y\u0005\u0005!bAA\u0002-\u0005\u0011AMY\u0005\u0004\u0003\u000fi(AC%t%\u0016\fGm\u00148ms\u000611M]3bi\u0016,B!!\u0004\u0002\u0012Q!\u0011qBA\n!\rI\u0016\u0011\u0003\u0003\u00067\u001e\u0011\r\u0001\u0018\u0005\b\u0003+9\u0001\u0019AA\b\u0003\u001d!(/[4hKJD#a\u00028\u0002\rU\u0004H-\u0019;f+\u0011\ti\"!\t\u0015\t\u0005}\u00111\u0005\t\u00043\u0006\u0005B!B.\t\u0005\u0004a\u0006bBA\u000b\u0011\u0001\u0007\u0011q\u0004\u0015\u0003\u00119\fa\u0001Z3mKR,G\u0003BA\u0016\u0003c\u00012aHA\u0017\u0013\r\ty\u0003\t\u0002\u0005+:LG\u000fC\u0003b\u0013\u0001\u0007!\r\u000b\u0002\n]\u0006qa-\u001b8e\u0005f4u\u000e\u001c3fe&#G\u0003CA\u001d\u0003\u001f\n\u0019&!\u0018\u0011\u000b\u0005m\u00121J\u0018\u000e\u0005\u0005u\"b\u0001\u001a\u0002@)!\u0011\u0011IA\"\u0003\u0011!\u0017\r^1\u000b\t\u0005\u0015\u0013qI\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011\u0011J\u0001\u0004_J<\u0017\u0002BA'\u0003{\u0011A\u0001U1hK\"1\u0011\u0011\u000b\u0006A\u0002\t\f\u0001BZ8mI\u0016\u0014\u0018\n\u001a\u0005\b\u0003+R\u0001\u0019AA,\u00035qWm\u001d;fI\u001a{G\u000eZ3sgB\u0019q$!\u0017\n\u0007\u0005m\u0003EA\u0004C_>dW-\u00198\t\u000f\u0005}#\u00021\u0001\u0002b\u0005A\u0001/Y4fC\ndW\r\u0005\u0003\u0002<\u0005\r\u0014\u0002BA3\u0003{\u0011\u0001\u0002U1hK\u0006\u0014G.\u001a\u0015\u0003\u00159D#AC>\u000219,XNY3s\u001f\u001a$V-\u001c9mCR,GK]5hO\u0016\u00148\u000f\u0006\u0003\u0002p\u0005U\u0004cA\u0010\u0002r%\u0019\u00111\u000f\u0011\u0003\u0007%sG\u000f\u0003\u0004\u0002x-\u0001\rAY\u0001\u000bi\u0016l\u0007\u000f\\1uK&#\u0007FA\u0006oQ\tY10\u0001\tgS:$')\u001f+f[Bd\u0017\r^3JIR1\u0011\u0011HAA\u0003\u0007Ca!a\u001e\r\u0001\u0004\u0011\u0007bBA0\u0019\u0001\u0007\u0011\u0011\r\u0015\u0003\u00199D#\u0001D>\u0002\u0015\u0019Lg\u000e\u001a\"z)f\u0004X\r\u0006\u0004\u0002:\u00055\u00151\u0018\u0005\b\u0003\u001fk\u0001\u0019AAI\u0003-!(/[4hKJ$\u0016\u0010]3\u0011\r\u0005M\u0015QTAR\u001d\u0011\t)*!'\u000f\u0007\u0015\f9*C\u0001\"\u0013\r\tY\nI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty*!)\u0003\t1K7\u000f\u001e\u0006\u0004\u00037\u0003\u0003\u0003BAS\u0003ok!!a*\u000b\t\u0005%\u00161V\u0001\be\u00164G.Z2u\u0015\u0011\ti+a,\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u00022\u0006M\u0016A\u00029mk\u001eLgNC\u0002\u00026b\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003s\u000b9K\u0001\u0003UsB,\u0007bBA0\u001b\u0001\u0007\u0011\u0011\r\u0015\u0003\u001b9D#!D>\u0002A\u001d,GOU;o]&tw\r\u0016:jO\u001e,'/\u001a3SK2,\u0017m]3t\u0007>,h\u000e\u001e\u000b\u0005\u0003_\n)\rC\u0004\u0002H:\u0001\r!!3\u0002\u001bQ,W\u000e\u001d7bi\u0016\u001c\u0015.V5e!\u0011\tY-a:\u000f\t\u00055\u00171\u001d\b\u0005\u0003\u001f\fyN\u0004\u0003\u0002R\u0006ug\u0002BAj\u00037tA!!6\u0002Z:\u0019Q-a6\n\u0003mI!!\u0007\u000e\n\u0005]A\u0012B\u0001\u001a\u0017\u0013\r\t\t/M\u0001\u0003S\u0012LA!a'\u0002f*\u0019\u0011\u0011]\u0019\n\t\u0005%\u00181\u001e\u0002\u0006\u0007&,\u0016\u000e\u001a\u0006\u0005\u00037\u000b)\u000f\u000b\u0002\u000f]\"\u0012ab_\u0001\u0017S:\u001cXM\u001d;Ue&<w-\u001a:fIJ+G.Z1tKRA\u00111FA{\u0003s\fi\u0010C\u0004\u0002x>\u0001\r!!3\u0002\u0017Q,W\u000e\u001d7bi\u0016,\u0016\u000e\u001a\u0005\b\u0003w|\u0001\u0019AAe\u0003)!(/[4hKJ,\u0016\u000e\u001a\u0005\b\u0003\u007f|\u0001\u0019AAe\u0003M!(/[4hKJ,GMU3mK\u0006\u001cX-V5eQ\tya.\u0001\fsK6|g/\u001a+sS\u001e<WM]3e%\u0016dW-Y:f)\u0011\tYCa\u0002\t\u000f\t%\u0001\u00031\u0001\u0003\f\u0005I1m\u001c8eSRLwN\u001c\t\u0004K\t5\u0011b\u0001B\bM\ty\"+Z7pm\u0016$&/[4hKJ,GMU3mK\u0006\u001cXmQ8oI&$\u0018n\u001c8)\u0005Aq\u0007f\u0001\u0001\u0003\u0016A\u0019APa\u0006\n\u0007\teQPA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class SqlTriggerRepository
implements TriggerRepository,
Logging {
    private final TriggerPersistence triggerPersistence;
    private final CiIdService ciIdService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Trigger> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTriggerRepository sqlTriggerRepository = this;
        synchronized (sqlTriggerRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Trigger>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    @IsReadOnly
    public <T extends Trigger> T find(String triggerId) {
        Option maybeTrigger = Ids.isInRelease((String)triggerId) ? this.triggerPersistence().findById(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId)))) : this.triggerPersistence().findById(Ids.getName((String)triggerId));
        return (T)((Trigger)maybeTrigger.getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{triggerId});
        }));
    }

    @Timed
    public <T extends Trigger> T create(T trigger) {
        if (!Ids.isTriggerId((String)trigger.getId())) {
            throw new IllegalArgumentException("Trigger Id [" + trigger.getId() + "] is not valid");
        }
        Long id = IdCreator$.MODULE$.generateId();
        trigger.setCiUid(id);
        TriggerPersistenceHelper$.MODULE$.fixPropertyIds(trigger, this.ciIdService());
        this.interceptCreate((ConfigurationItem)trigger);
        this.triggerPersistence().insert(trigger);
        this.afterCreate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public <T extends Trigger> T update(T trigger) {
        TriggerPersistenceHelper$.MODULE$.fixPropertyIds(trigger, this.ciIdService());
        this.interceptUpdate((ConfigurationItem)trigger);
        this.triggerPersistence().update(trigger);
        this.afterUpdate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public void delete(String triggerId) {
        this.interceptDelete(triggerId);
        this.triggerPersistence().delete(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId))));
        this.afterDelete(triggerId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByFolderId(String folderId, boolean nestedFolders, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setFolderId(folderId);
        filter.setNestedFolders(Predef$.MODULE$.boolean2Boolean(nestedFolders));
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int numberOfTemplateTriggers(String templateId) {
        return this.triggerPersistence().numberOfTemplateTriggers(templateId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByTemplateId(String templateId, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTemplateId(templateId);
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByType(List<Type> triggerType, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTriggerType(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)triggerType.map((Function1 & Serializable)x$1 -> x$1.toString())).asJava());
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int getRunningTriggeredReleasesCount(Long templateCiUid) {
        int total = this.triggerPersistence().getRunningTriggeredReleasesCount(templateCiUid);
        this.logger().debug((Function0 & Serializable)() -> "getRunningTriggeredReleasesCount: templateCiUid=" + templateCiUid + ", total=" + total);
        return total;
    }

    @Timed
    public void insertTriggeredRelease(Long templateUid, Long triggerUid, Long triggeredReleaseUid) {
        this.logger().debug((Function0 & Serializable)() -> "insertTriggeredRelease: templateUid=" + templateUid + ", triggerUid=" + triggerUid + ", triggeredReleaseUid=" + triggeredReleaseUid);
        TriggeredReleaseRow row = new TriggeredReleaseRow(templateUid, triggerUid, triggeredReleaseUid);
        this.triggerPersistence().insertTriggeredReleaseRow(row);
    }

    @Timed
    public void removeTriggeredRelease(RemoveTriggeredReleaseCondition condition) {
        this.logger().debug((Function0 & Serializable)() -> "removeTriggeredRelease: " + condition);
        this.triggerPersistence().removeTriggeredReleasesRow(condition);
    }

    public SqlTriggerRepository(TriggerPersistence triggerPersistence, CiIdService ciIdService) {
        this.triggerPersistence = triggerPersistence;
        this.ciIdService = ciIdService;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
    }
}

