package com.xebialabs.xlrelease.triggers.management

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.repository.ReleaseRepository
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport
import com.xebialabs.xlrelease.service.ReleaseSearchService
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerPersistence
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.UpgradeSupport.{BatchSupport, TransactionSupport}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component
import org.springframework.transaction.support.TransactionTemplate

import scala.jdk.CollectionConverters._

@Component
class XLRelease900TriggerTitleUpgrade @Autowired()(@Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                                   @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect,
                                                   @Qualifier("xlrRepositoryTransactionTemplate") val transactionTemplate: TransactionTemplate,
                                                   releaseSearchService: ReleaseSearchService,
                                                   releaseRepository: ReleaseRepository,
                                                   triggerPersistence: TriggerPersistence)
  extends Upgrade with PersistenceSupport with Logging with BatchSupport with TransactionSupport {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "9.0.0#1")

  override def doUpgrade(): Boolean = {
    logger.info("Starting trigger title extraction upgrade")
    val items = releaseSearchService.findAllTemplateIds.asScala
    doInBatch(items) { batch =>
      doInTransaction {
        batch.items.foreach(releaseId => {
          val template = releaseRepository.findById(releaseId)
          template.getReleaseTriggers.asScala.foreach { trigger =>
            triggerPersistence.update(trigger)
          }
        })
      }
    }

    true
  }

}
