/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository.persistence;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.RemoveByReleaseUid;
import com.xebialabs.xlrelease.repository.RemoveByTemplateUid;
import com.xebialabs.xlrelease.repository.RemoveTriggeredReleaseCondition;
import com.xebialabs.xlrelease.repository.sql.SqlRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.repository.sql.persistence.package$;
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper$;
import com.xebialabs.xlrelease.triggers.repository.persistence.TemplateTriggerRow;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerMapper;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerQueryBuilder;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggeredReleaseRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.support.SqlLobValue;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\t%g\u0001\u0002\u001a4\u0001\u0001C\u0001b\u0018\u0001\u0003\u0006\u0004%\t\u0001\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005C\"AQ\r\u0001BC\u0002\u0013\u0005a\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003h\u0011!Y\u0007A!b\u0001\n\u0007a\u0007\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u0011i\u0004!Q1A\u0005\u0004mD\u0011\"a\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002?\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBA2\u0001\u0011%\u0011Q\r\u0005\n\u0003[\u0002!\u0019!C\u0005\u0003_B\u0001\"!\u001d\u0001A\u0003%\u0011Q\t\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\ty\n\u0001C\u0001\u0003CC\u0011\"!5\u0001\u0005\u0004%I!a\u001c\t\u0011\u0005M\u0007\u0001)A\u0005\u0003\u000bBq!!6\u0001\t\u0003\t9\u000eC\u0005\u0002^\u0002\u0011\r\u0011\"\u0003\u0002p!A\u0011q\u001c\u0001!\u0002\u0013\t)\u0005C\u0004\u0002b\u0002!\t!a9\t\u000f\u00055\b\u0001\"\u0003\u0002p\"9\u0011q \u0001\u0005\n\t\u0005\u0001\"\u0003B\u0003\u0001\t\u0007I\u0011BA8\u0011!\u00119\u0001\u0001Q\u0001\n\u0005\u0015\u0003b\u0002B\u0005\u0001\u0011\u0005!1\u0002\u0005\n\u0005\u001f\u0001!\u0019!C\u0005\u0003_B\u0001B!\u0005\u0001A\u0003%\u0011Q\t\u0005\b\u0005'\u0001A\u0011\u0001B\u000b\u0011%\u0011Y\u0003\u0001b\u0001\n\u0013\ty\u0007\u0003\u0005\u0003.\u0001\u0001\u000b\u0011BA#\u0011%\u0011y\u0003\u0001b\u0001\n\u0013\u0011\t\u0004\u0003\u0005\u0003@\u0001\u0001\u000b\u0011\u0002B\u001a\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0007B\u0011Ba\u0019\u0001\u0005\u0004%I!a\u001c\t\u0011\t\u0015\u0004\u0001)A\u0005\u0003\u000bBqAa\u001a\u0001\t\u0003\u0011I\u0007C\u0005\u0003p\u0001\u0011\r\u0011\"\u0003\u0003r!A!\u0011\u0011\u0001!\u0002\u0013\u0011\u0019\bC\u0004\u0003\u0004\u0002!\tA!\"\t\u0013\t-\u0005A1A\u0005\n\u0005=\u0004\u0002\u0003BG\u0001\u0001\u0006I!!\u0012\t\u000f\t=\u0005\u0001\"\u0001\u0003\u0012\"I!1\u0014\u0001C\u0002\u0013%\u0011q\u000e\u0005\t\u0005;\u0003\u0001\u0015!\u0003\u0002F!I!q\u0014\u0001C\u0002\u0013%\u0011q\u000e\u0005\t\u0005C\u0003\u0001\u0015!\u0003\u0002F!9!1\u0015\u0001\u0005\u0002\t\u0015\u0006b\u0002BZ\u0001\u0011%!Q\u0017\u0002\u0013)JLwmZ3s!\u0016\u00148/[:uK:\u001cWM\u0003\u00025k\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t1t'\u0001\u0006sKB|7/\u001b;pefT!\u0001O\u001d\u0002\u0011Q\u0014\u0018nZ4feNT!AO\u001e\u0002\u0013ad'/\u001a7fCN,'B\u0001\u001f>\u0003%AXMY5bY\u0006\u00147OC\u0001?\u0003\r\u0019w.\\\u0002\u0001'\u0019\u0001\u0011i\u0012(T/B\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n1\u0011I\\=SK\u001a\u0004\"\u0001\u0013'\u000e\u0003%S!AS&\u0002\u0007M\fHN\u0003\u00027s%\u0011Q*\u0013\u0002\u000e'Fd'+\u001a9pg&$xN]=\u0011\u0005=\u000bV\"\u0001)\u000b\u0005QJ\u0015B\u0001*Q\u0005I\u0001VM]:jgR,gnY3TkB\u0004xN\u001d;\u0011\u0005Q+V\"A\u001a\n\u0005Y\u001b$!\u0004+sS\u001e<WM]'baB,'\u000f\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006)1\u000f\u001c45U*\tA,\u0001\u0005he&T(\u0010\\3e\u0013\tq\u0016LA\u0004M_\u001e<\u0017N\\4\u0002#\u0019|G\u000eZ3s!\u0016\u00148/[:uK:\u001cW-F\u0001b!\ty%-\u0003\u0002d!\n\tbi\u001c7eKJ\u0004VM]:jgR,gnY3\u0002%\u0019|G\u000eZ3s!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0015gFd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0016\u0003\u001d\u0004\"\u0001\u00135\n\u0005%L%\u0001F*rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'/A\u000btc2\u0014V\r]8tSR|'/_!eCB$XM\u001d\u0011\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u00035\u0004\"A\\<\u000e\u0003=T!\u0001]9\u0002\t\r|'/\u001a\u0006\u0003eN\fAA\u001b3cG*\u0011A/^\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta/A\u0002pe\u001eL!\u0001_8\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0003\u001d!\u0017.\u00197fGR,\u0012\u0001 \t\u0004{\u0006\u0005bb\u0001@\u0002\u001c9\u0019q0a\u0006\u000f\t\u0005\u0005\u00111\u0003\b\u0005\u0003\u0007\t\tB\u0004\u0003\u0002\u0006\u0005=a\u0002BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-q(\u0001\u0004=e>|GOP\u0005\u0002}%\u0011A(P\u0005\u0003umJ1!!\u0006:\u0003\t!'-C\u0002K\u00033Q1!!\u0006:\u0013\u0011\ti\"a\b\u0002\u0015M\u000bHNQ;jY\u0012,'OC\u0002K\u00033IA!a\t\u0002&\t9A)[1mK\u000e$(\u0002BA\u000f\u0003?\t\u0001\u0002Z5bY\u0016\u001cG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u00055\u0012qFA\u0019\u0003g\t)\u0004\u0005\u0002U\u0001!)q,\u0003a\u0001C\")Q-\u0003a\u0001O\")1.\u0003a\u0002[\")!0\u0003a\u0002y\u0006Ab.^7cKJ|e\rV3na2\fG/\u001a+sS\u001e<WM]:\u0015\t\u0005m\u0012\u0011\t\t\u0004\u0005\u0006u\u0012bAA \u0007\n\u0019\u0011J\u001c;\t\u000f\u0005\r#\u00021\u0001\u0002F\u0005QA/Z7qY\u0006$X-\u00133\u0011\t\u0005\u001d\u0013q\n\b\u0005\u0003\u0013\nY\u0005E\u0002\u0002\b\rK1!!\u0014D\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011KA*\u0005\u0019\u0019FO]5oO*\u0019\u0011QJ\")\u0007)\t9\u0006\u0005\u0003\u0002Z\u0005}SBAA.\u0015\u0011\ti&a\b\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003C\nYF\u0001\u0006JgJ+\u0017\rZ(oYf\f1\u0003\u001e:jO\u001e,'/U;fef\u0014U/\u001b7eKJ,\"!a\u001a\u0011\u0007Q\u000bI'C\u0002\u0002lM\u00121\u0003\u0016:jO\u001e,'/U;fef\u0014U/\u001b7eKJ\f1$U+F%f{FKU%H\u000f\u0016\u0013vLQ-`)JKuiR#S?&#UCAA#\u0003q\tV+\u0012*Z?R\u0013\u0016jR$F%~\u0013\u0015l\u0018+S\u0013\u001e;UIU0J\t\u0002\n\u0001BZ5oI\nK\u0018\nZ\u000b\u0005\u0003o\n\u0019\t\u0006\u0003\u0002z\u0005m\u0005#\u0002\"\u0002|\u0005}\u0014bAA?\u0007\n1q\n\u001d;j_:\u0004B!!!\u0002\u00042\u0001AaBAC\u001d\t\u0007\u0011q\u0011\u0002\u0002)F!\u0011\u0011RAH!\r\u0011\u00151R\u0005\u0004\u0003\u001b\u001b%a\u0002(pi\"Lgn\u001a\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011QS\u001d\u0002\r\u0011|W.Y5o\u0013\u0011\tI*a%\u0003\u000fQ\u0013\u0018nZ4fe\"9\u0011Q\u0014\bA\u0002\u0005\u0015\u0013!\u0003;sS\u001e<WM]%e\u0003\u00191\u0017N\u001c3CsR1\u00111UAY\u0003\u000f\u0004b!!*\u0002.\u0006=UBAAT\u0015\u0011\t)*!+\u000b\u0007\u0005-6/\u0001\u0003eCR\f\u0017\u0002BAX\u0003O\u0013A\u0001U1hK\"9\u00111W\bA\u0002\u0005U\u0016A\u00024jYR,'\u000f\u0005\u0003\u00028\u0006\rWBAA]\u0015\u0011\t\u0019,a/\u000b\t\u0005u\u0016qX\u0001\u0003mFR1!!1:\u0003\r\t\u0007/[\u0005\u0005\u0003\u000b\fIL\u0001\bUe&<w-\u001a:GS2$XM]:\t\u000f\u0005%w\u00021\u0001\u0002L\u0006A\u0001/Y4fC\ndW\r\u0005\u0003\u0002&\u00065\u0017\u0002BAh\u0003O\u0013\u0001\u0002U1hK\u0006\u0014G.Z\u0001\u0014'RkEkX%O'\u0016\u0013Fk\u0018+S\u0013\u001e;UIU\u0001\u0015'RkEkX%O'\u0016\u0013Fk\u0018+S\u0013\u001e;UI\u0015\u0011\u0002\r%t7/\u001a:u)\u0011\ty)!7\t\u000f\u0005m'\u00031\u0001\u0002\u0010\u00069AO]5hO\u0016\u0014\u0018aE*U\u001bR{V\u000b\u0015#B)\u0016{FKU%H\u000f\u0016\u0013\u0016\u0001F*U\u001bR{V\u000b\u0015#B)\u0016{FKU%H\u000f\u0016\u0013\u0006%\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003K\fY\u000fE\u0002C\u0003OL1!!;D\u0005\u0011)f.\u001b;\t\u000f\u0005mW\u00031\u0001\u0002\u0010\u0006aQ\u000f]:feR\u0004\u0016M]1ngR!\u0011\u0011_A\u007f!\u0011\t\u00190!?\u000e\u0005\u0005U(bAA|_\u0006Qa.Y7fIB\f'/Y7\n\t\u0005m\u0018Q\u001f\u0002\u0016\u001b\u0006\u00048+\u001d7QCJ\fW.\u001a;feN{WO]2f\u0011\u001d\tYN\u0006a\u0001\u0003\u001f\u000b\u0011b]3sS\u0006d\u0017N_3\u0015\t\u0005\u0015#1\u0001\u0005\b\u00037<\u0002\u0019AAH\u0003M\u0019F+\u0014+`\t\u0016cU\tV#`)JKuiR#S\u0003Q\u0019F+\u0014+`\t\u0016cU\tV#`)JKuiR#SA\u00051A-\u001a7fi\u0016$B!!:\u0003\u000e!9\u0011Q\u0014\u000eA\u0002\u0005\u0015\u0013\u0001L*U\u001bR{v)\u0012+`\u000b:\u000b%\tT#E?R\u0013\u0016jR$F%~KEiU0G\u001fJ{F+R'Q\u0019\u0006#ViX%E\u00035\u001aF+\u0014+`\u000f\u0016#v,\u0012(B\u00052+Ei\u0018+S\u0013\u001e;UIU0J\tN{fi\u0014*`)\u0016k\u0005\u000bT!U\u000b~KE\tI\u0001\u001cO\u0016$XI\\1cY\u0016$'+\u001a7fCN,GK]5hO\u0016\u0014\u0018\nZ:\u0015\t\t]!\u0011\u0006\t\u0007\u00053\u0011\u0019#!\u0012\u000f\t\tm!q\u0004\b\u0005\u0003\u000f\u0011i\"C\u0001E\u0013\r\u0011\tcQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Ca\n\u0003\u0007M+\u0017OC\u0002\u0003\"\rCq!a\u0011\u001e\u0001\u0004\t)%\u0001\u0015T)6#vlR#U?R+U\n\u0015'B)\u0016{FKU%H\u000f\u0016\u0013vLU(X?\nKvLU#M\u000b\u0006\u001bV)A\u0015T)6#vlR#U?R+U\n\u0015'B)\u0016{FKU%H\u000f\u0016\u0013vLU(X?\nKvLU#M\u000b\u0006\u001bV\tI\u0001\u0019i\u0016l\u0007\u000f\\1uKR\u0013\u0018nZ4feJ{w/T1qa\u0016\u0014XC\u0001B\u001a!\u0015q'Q\u0007B\u001d\u0013\r\u00119d\u001c\u0002\n%><X*\u00199qKJ\u00042\u0001\u0016B\u001e\u0013\r\u0011id\r\u0002\u0013)\u0016l\u0007\u000f\\1uKR\u0013\u0018nZ4feJ{w/A\ruK6\u0004H.\u0019;f)JLwmZ3s%><X*\u00199qKJ\u0004\u0013AF4fiR+W\u000e\u001d7bi\u0016$&/[4hKJ\u0014vn^:\u0015\t\t\u0015#q\t\t\u0007\u00053\u0011\u0019C!\u000f\t\u000f\t%#\u00051\u0001\u0003L\u0005a!/\u001a7fCN,7)[+jIB!!Q\nB/\u001d\u0011\u0011yEa\u0017\u000f\t\tE#\u0011\f\b\u0005\u0005'\u00129F\u0004\u0003\u0002\u0002\tU\u0013B\u0001\u001c:\u0013\tQ5*\u0003\u00025\u0013&\u0019!\u0011\u0005)\n\t\t}#\u0011\r\u0002\u0006\u0007&,\u0016\u000e\u001a\u0006\u0004\u0005C\u0001\u0016aG%O'\u0016\u0013Fk\u0018+F\u001bBc\u0015\tV#`)JKuiR#S?J{u+\u0001\u000fJ\u001dN+%\u000bV0U\u000b6\u0003F*\u0011+F?R\u0013\u0016jR$F%~\u0013vj\u0016\u0011\u00021%t7/\u001a:u)\u0016l\u0007\u000f\\1uKR\u0013\u0018nZ4feJ{w\u000f\u0006\u0003\u0002f\n-\u0004b\u0002B7K\u0001\u0007!\u0011H\u0001\u0004e><\u0018!I*U\u001bR{v)\u0012+`)JKuiR#S\u000b\u0012{&+\u0012'F\u0003N+5kX\"P+:#VC\u0001B:!\u0011\u0011)Ha \u000e\u0005\t]$\u0002\u0002B=\u0005w\nA\u0001\\1oO*\u0011!QP\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\t]\u0014AI*U\u001bR{v)\u0012+`)JKuiR#S\u000b\u0012{&+\u0012'F\u0003N+5kX\"P+:#\u0006%\u0001\u0011hKR\u0014VO\u001c8j]\u001e$&/[4hKJ,GMU3mK\u0006\u001cXm]\"pk:$H\u0003BA\u001e\u0005\u000fCqA!#)\u0001\u0004\u0011Y%A\u0006uK6\u0004H.\u0019;f+&$\u0017\u0001H%O'\u0016\u0013Fk\u0018+S\u0013\u001e;UIU#E?J+E*R!T\u000b~\u0013vjV\u0001\u001e\u0013:\u001bVI\u0015+`)JKuiR#S\u000b\u0012{&+\u0012'F\u0003N+uLU(XA\u0005I\u0012N\\:feR$&/[4hKJ,GMU3mK\u0006\u001cXMU8x)\u0011\t)Oa%\t\u000f\t54\u00061\u0001\u0003\u0016B\u0019AKa&\n\u0007\te5GA\nUe&<w-\u001a:fIJ+G.Z1tKJ{w/\u0001\u0017T)6#v\fR#M\u000bR+u\f\u0016*J\u000f\u001e+%+\u0012#`%\u0016cU)Q*F?\nKvLU#M\u000b\u0006\u001bViX+J\t\u0006i3\u000bV'U?\u0012+E*\u0012+F?R\u0013\u0016jR$F%\u0016#uLU#M\u000b\u0006\u001bVi\u0018\"Z?J+E*R!T\u000b~+\u0016\n\u0012\u0011\u0002[M#V\nV0E\u000b2+E+R0U%&;u)\u0012*F\t~\u0013V\tT#B'\u0016{&)W0U\u000b6\u0003F*\u0011+F?VKE)\u0001\u0018T)6#v\fR#M\u000bR+u\f\u0016*J\u000f\u001e+%+\u0012#`%\u0016cU)Q*F?\nKv\fV#N!2\u000bE+R0V\u0013\u0012\u0003\u0013A\u0007:f[>4X\r\u0016:jO\u001e,'/\u001a3SK2,\u0017m]3t%><H\u0003BAs\u0005OCqA!+1\u0001\u0004\u0011Y+A\u0005d_:$\u0017\u000e^5p]B!!Q\u0016BX\u001b\u0005Y\u0015b\u0001BY\u0017\ny\"+Z7pm\u0016$&/[4hKJ,GMU3mK\u0006\u001cXmQ8oI&$\u0018n\u001c8\u0002#\rDWmY6EK2,G/\u001a*fgVdG\u000f\u0006\u0003\u00038\nu\u0006c\u0002\"\u0003:\u0006m\u0012Q]\u0005\u0004\u0005w\u001b%!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\u0011y,\ra\u0001\u0003\u000b\n1!\\:hQ\r\u0001!1\u0019\t\u0005\u00033\u0012)-\u0003\u0003\u0003H\u0006m#aD%t)J\fgn]1di&|g.\u00197")
public class TriggerPersistence
implements SqlRepository,
PersistenceSupport,
TriggerMapper,
Logging {
    private final FolderPersistence folderPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final String QUERY_TRIGGER_BY_TRIGGER_ID;
    private final String STMT_INSERT_TRIGGER;
    private final String STMT_UPDATE_TRIGGER;
    private final String STMT_DELETE_TRIGGER;
    private final String STMT_GET_ENABLED_TRIGGER_IDS_FOR_TEMPLATE_ID;
    private final String STMT_GET_TEMPLATE_TRIGGER_ROW_BY_RELEASE;
    private final RowMapper<TemplateTriggerRow> templateTriggerRowMapper;
    private final String INSERT_TEMPLATE_TRIGGER_ROW;
    private final String STMT_GET_TRIGGERED_RELEASES_COUNT;
    private final String INSERT_TRIGGERED_RELEASE_ROW;
    private final String STMT_DELETE_TRIGGERED_RELEASE_BY_RELEASE_UID;
    private final String STMT_DELETE_TRIGGERED_RELEASE_BY_TEMPLATE_UID;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public <T extends Trigger> Function2<SqlRepositoryAdapter, FolderPersistence, RowMapper<T>> triggerMapper() {
        return TriggerMapper.triggerMapper$(this);
    }

    @Override
    public RowMapper<String> triggerIdRowMapper() {
        return TriggerMapper.triggerIdRowMapper$(this);
    }

    public MapSqlParameterSource paramMap2MapSqlParameterSource(scala.collection.immutable.Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$((PersistenceSupport)this, params);
    }

    public Integer sqlInsert(String pkColumn, String sqlStatement, scala.collection.immutable.Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, scala.collection.immutable.Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params);
    }

    public <R> R sqlExec(String sqlStatement, scala.collection.immutable.Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, scala.collection.immutable.Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, scala.collection.immutable.Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, scala.collection.immutable.Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, scala.collection.immutable.Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, scala.collection.immutable.Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, Set<scala.collection.immutable.Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<scala.collection.immutable.Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$((PersistenceSupport)this, pairs);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$((Utils)this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerPersistence triggerPersistence = this;
        synchronized (triggerPersistence) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        TriggerPersistence triggerPersistence = this;
        synchronized (triggerPersistence) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    public FolderPersistence folderPersistence() {
        return this.folderPersistence;
    }

    public SqlRepositoryAdapter sqlRepositoryAdapter() {
        return this.sqlRepositoryAdapter;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @IsReadOnly
    public int numberOfTemplateTriggers(String templateId) {
        String QUERY_COUNT_TEMPLATE_TRIGGERS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT COUNT(1)\n         | FROM\n         | " + Schema.RELEASES$.MODULE$.TABLE() + " r\n         | JOIN " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE() + " tt on tt." + Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID() + " = r." + Schema.RELEASES$.MODULE$.CI_UID() + "\n         | JOIN " + Schema.TRIGGERS$.MODULE$.TABLE() + " tr on tt." + Schema.TEMPLATE_TRIGGERS$.MODULE$.TRIGGER_UID() + " = tr." + Schema.TRIGGERS$.MODULE$.CI_UID() + "\n         | WHERE r." + Schema.RELEASES$.MODULE$.RELEASE_ID() + " = :" + Schema.RELEASES$.MODULE$.RELEASE_ID() + "\n         |"));
        return BoxesRunTime.unboxToInt((Object)this.namedTemplate().queryForObject(QUERY_COUNT_TEMPLATE_TRIGGERS, (SqlParameterSource)this.paramSource((Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.RELEASES$.MODULE$.RELEASE_ID()), (Object)Ids.getName((String)templateId))})), Integer.TYPE));
    }

    private TriggerQueryBuilder triggerQueryBuilder() {
        return new TriggerQueryBuilder(this.folderPersistence(), this.sqlRepositoryAdapter(), this.dialect(), this.namedTemplate());
    }

    private String QUERY_TRIGGER_BY_TRIGGER_ID() {
        return this.QUERY_TRIGGER_BY_TRIGGER_ID;
    }

    public <T extends Trigger> Option<T> findById(String triggerId) {
        Some some;
        try {
            some = new Some(this.namedTemplate().queryForObject(this.QUERY_TRIGGER_BY_TRIGGER_ID(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERS$.MODULE$.ID()), (Object)triggerId)}))).asJava(), (RowMapper)this.triggerMapper().apply((Object)this.sqlRepositoryAdapter(), (Object)this.folderPersistence())));
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public Page<Trigger> findBy(TriggerFilters filter, Pageable pageable) {
        return this.triggerQueryBuilder().from(filter).withPageable(pageable).build().execute();
    }

    private String STMT_INSERT_TRIGGER() {
        return this.STMT_INSERT_TRIGGER;
    }

    public Trigger insert(Trigger trigger) {
        MapSqlParameterSource params = this.upsertParams(trigger);
        return (Trigger)this.sqlInsert(this.pkName(Schema.TRIGGERS$.MODULE$.CI_UID()), this.STMT_INSERT_TRIGGER(), params, (Function1 & Serializable)ciUid -> {
            trigger.setCiUid(ciUid);
            return trigger;
        });
    }

    private String STMT_UPDATE_TRIGGER() {
        return this.STMT_UPDATE_TRIGGER;
    }

    public void update(Trigger trigger) {
        MapSqlParameterSource params = this.upsertParams(trigger);
        this.sqlUpdate(this.STMT_UPDATE_TRIGGER(), params, this.checkCiUpdated(trigger.getId()));
    }

    private MapSqlParameterSource upsertParams(Trigger trigger) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        Integer folderUid = this.folderPersistence().getUid(trigger.getFolderId());
        params.addValue(Schema.TRIGGERS$.MODULE$.FOLDER_UID(), (Object)folderUid);
        params.addValue(Schema.TRIGGERS$.MODULE$.ENABLED(), (Object)Utils.RichBooleanAsInt$.MODULE$.asInteger$extension(Utils$.MODULE$.RichBooleanAsInt(trigger.isEnabled())));
        params.addValue(Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE(), (Object)Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(trigger.getTitle()), package$.MODULE$.LONG_VARCHAR_LENGTH()));
        params.addValue(Schema.TRIGGERS$.MODULE$.CI_TYPE(), (Object)trigger.getType().toString());
        params.addValue(Schema.TRIGGERS$.MODULE$.DESCRIPTION(), (Object)Utils.RichStringAsTruncatable$.MODULE$.trimAndTruncate$extension(Utils$.MODULE$.RichStringAsTruncatable(trigger.getDescription()), package$.MODULE$.LONG_VARCHAR_LENGTH()));
        params.addValue(Schema.TRIGGERS$.MODULE$.CONTENT(), (Object)new SqlLobValue(this.serialize(trigger).getBytes(StandardCharsets.UTF_8)), 2004);
        params.addValue(Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE(), (Object)trigger.getLastRunDate());
        params.addValue(Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS(), Option$.MODULE$.apply((Object)trigger.getLastRunStatus()).map((Function1 & Serializable)x$1 -> x$1.value()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (Ids.isInRelease((String)trigger.getId())) {
            v0 = params.addValue(Schema.TRIGGERS$.MODULE$.ID(), (Object)Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(trigger.getId()))));
        } else {
            String triggerId = Ids.getName((String)Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(trigger.getId()))));
            trigger.setId(Ids.formatWithFolderId((String)trigger.getFolderId(), (String)triggerId));
            v0 = params.addValue(Schema.TRIGGERS$.MODULE$.ID(), (Object)triggerId);
        }
        return params;
    }

    private String serialize(Trigger trigger) {
        Trigger triggerCopy = (Trigger)CiCloneHelper.cloneCi((ConfigurationItem)trigger);
        triggerCopy.setId(Ids.getFolderlessId((String)trigger.getId()));
        triggerCopy.setFolderId(null);
        return CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)triggerCopy);
    }

    private String STMT_DELETE_TRIGGER() {
        return this.STMT_DELETE_TRIGGER;
    }

    public void delete(String triggerId) {
        this.sqlUpdate(this.STMT_DELETE_TRIGGER(), this.paramMap2MapSqlParameterSource((scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERS$.MODULE$.ID()), (Object)Ids.getFolderlessId((String)triggerId))}))), this.checkCiUpdated(triggerId));
    }

    private String STMT_GET_ENABLED_TRIGGER_IDS_FOR_TEMPLATE_ID() {
        return this.STMT_GET_ENABLED_TRIGGER_IDS_FOR_TEMPLATE_ID;
    }

    public Seq<String> getEnabledReleaseTriggerIds(String templateId) {
        return this.sqlQuery(this.STMT_GET_ENABLED_TRIGGER_IDS_FOR_TEMPLATE_ID(), (scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"templateId"), (Object)Ids.getName((String)templateId))})), this.triggerIdRowMapper()).toSeq();
    }

    private String STMT_GET_TEMPLATE_TRIGGER_ROW_BY_RELEASE() {
        return this.STMT_GET_TEMPLATE_TRIGGER_ROW_BY_RELEASE;
    }

    private RowMapper<TemplateTriggerRow> templateTriggerRowMapper() {
        return this.templateTriggerRowMapper;
    }

    public Seq<TemplateTriggerRow> getTemplateTriggerRows(Integer releaseCiUid) {
        return this.sqlQuery(this.STMT_GET_TEMPLATE_TRIGGER_ROW_BY_RELEASE(), (scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseCiUid"), (Object)releaseCiUid)})), this.templateTriggerRowMapper()).toSeq();
    }

    private String INSERT_TEMPLATE_TRIGGER_ROW() {
        return this.INSERT_TEMPLATE_TRIGGER_ROW;
    }

    public void insertTemplateTriggerRow(TemplateTriggerRow row) {
        this.sqlInsert(this.INSERT_TEMPLATE_TRIGGER_ROW(), this.paramMap2MapSqlParameterSource((scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"releaseCiUid"), (Object)row.releaseCiUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"triggerCiUid"), (Object)row.triggerCiUid())}))));
    }

    private String STMT_GET_TRIGGERED_RELEASES_COUNT() {
        return this.STMT_GET_TRIGGERED_RELEASES_COUNT;
    }

    public int getRunningTriggeredReleasesCount(Integer templateUid) {
        return BoxesRunTime.unboxToInt((Object)this.namedTemplate().queryForObject(this.STMT_GET_TRIGGERED_RELEASES_COUNT(), (SqlParameterSource)this.paramSource((Seq<Tuple2<String, Object>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID()), (Object)templateUid)})), Integer.TYPE));
    }

    private String INSERT_TRIGGERED_RELEASE_ROW() {
        return this.INSERT_TRIGGERED_RELEASE_ROW;
    }

    public void insertTriggeredReleaseRow(TriggeredReleaseRow row) {
        this.sqlInsert(this.INSERT_TRIGGERED_RELEASE_ROW(), this.paramMap2MapSqlParameterSource((scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID()), (Object)row.templateUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.TRIGGER_UID()), (Object)row.triggerUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID()), (Object)row.releaseUid())}))));
    }

    private String STMT_DELETE_TRIGGERED_RELEASE_BY_RELEASE_UID() {
        return this.STMT_DELETE_TRIGGERED_RELEASE_BY_RELEASE_UID;
    }

    private String STMT_DELETE_TRIGGERED_RELEASE_BY_TEMPLATE_UID() {
        return this.STMT_DELETE_TRIGGERED_RELEASE_BY_TEMPLATE_UID;
    }

    public void removeTriggeredReleasesRow(RemoveTriggeredReleaseCondition condition) {
        RemoveTriggeredReleaseCondition removeTriggeredReleaseCondition = condition;
        if (removeTriggeredReleaseCondition instanceof RemoveByReleaseUid) {
            RemoveByReleaseUid removeByReleaseUid = (RemoveByReleaseUid)removeTriggeredReleaseCondition;
            Integer releaseUid = removeByReleaseUid.releaseUid();
            this.sqlUpdate(this.STMT_DELETE_TRIGGERED_RELEASE_BY_RELEASE_UID(), this.paramMap2MapSqlParameterSource((scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID()), (Object)releaseUid)}))), this.checkDeleteResult("No rows were deleted for releaseUid[" + releaseUid + "]"));
            return;
        }
        if (removeTriggeredReleaseCondition instanceof RemoveByTemplateUid) {
            RemoveByTemplateUid removeByTemplateUid = (RemoveByTemplateUid)removeTriggeredReleaseCondition;
            Integer templateUid = removeByTemplateUid.templateUid();
            this.sqlUpdate(this.STMT_DELETE_TRIGGERED_RELEASE_BY_TEMPLATE_UID(), this.paramMap2MapSqlParameterSource((scala.collection.immutable.Map<String, Object>)Utils$.MODULE$.params((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID()), (Object)templateUid)}))), this.checkDeleteResult("No rows were deleted for templateUid[" + templateUid + "]"));
            return;
        }
        throw new MatchError((Object)removeTriggeredReleaseCondition);
    }

    private Function1<Object, BoxedUnit> checkDeleteResult(String msg) {
        return (JFunction1.mcVI.sp & Serializable)x0$1 -> {
            int n = x0$1;
            switch (n) {
                case 0: {
                    this.logger().debug((Function0 & Serializable)() -> msg);
                    return;
                }
            }
        };
    }

    public TriggerPersistence(FolderPersistence folderPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.folderPersistence = folderPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
        TriggerMapper.$init$(this);
        Logging.$init$((Logging)this);
        this.QUERY_TRIGGER_BY_TRIGGER_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT t." + Schema.TRIGGERS$.MODULE$.ID() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.CI_UID() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.ENABLED() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.CI_TYPE() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.DESCRIPTION() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.CONTENT() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE() + ",\n       | t." + Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS() + ",\n       | f." + Schema.FOLDERS$.MODULE$.FOLDER_PATH() + ",\n       | f." + Schema.FOLDERS$.MODULE$.FOLDER_ID() + "\n       | FROM " + Schema.TRIGGERS$.MODULE$.TABLE() + " t\n       | INNER JOIN " + Schema.FOLDERS$.MODULE$.TABLE() + " f on t." + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + " = f." + Schema.FOLDERS$.MODULE$.CI_UID() + "\n       | WHERE " + Schema.TRIGGERS$.MODULE$.ID() + " = :" + Schema.TRIGGERS$.MODULE$.ID() + "\n       |"));
        this.STMT_INSERT_TRIGGER = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + Schema.TRIGGERS$.MODULE$.TABLE() + "\n       | ( " + Schema.TRIGGERS$.MODULE$.ID() + "\n       | , " + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + "\n       | , " + Schema.TRIGGERS$.MODULE$.ENABLED() + "\n       | , " + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + "\n       | , " + Schema.TRIGGERS$.MODULE$.CI_TYPE() + "\n       | , " + Schema.TRIGGERS$.MODULE$.DESCRIPTION() + "\n       | , " + Schema.TRIGGERS$.MODULE$.CONTENT() + "\n       | , " + Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE() + "\n       | , " + Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS() + "\n       | ) VALUES\n       | ( :" + Schema.TRIGGERS$.MODULE$.ID() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.ENABLED() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.CI_TYPE() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.DESCRIPTION() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.CONTENT() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE() + "\n       | , :" + Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS() + "\n       | )\n     "));
        this.STMT_UPDATE_TRIGGER = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("UPDATE " + Schema.TRIGGERS$.MODULE$.TABLE() + "\n       | SET " + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + " = :" + Schema.TRIGGERS$.MODULE$.FOLDER_UID() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.ENABLED() + " = :" + Schema.TRIGGERS$.MODULE$.ENABLED() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + " = :" + Schema.TRIGGERS$.MODULE$.TRIGGER_TITLE() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.CI_TYPE() + " = :" + Schema.TRIGGERS$.MODULE$.CI_TYPE() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.DESCRIPTION() + " = :" + Schema.TRIGGERS$.MODULE$.DESCRIPTION() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.CONTENT() + " = :" + Schema.TRIGGERS$.MODULE$.CONTENT() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE() + " = :" + Schema.TRIGGERS$.MODULE$.LAST_RUN_DATE() + ",\n       |  " + Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS() + " = :" + Schema.TRIGGERS$.MODULE$.LAST_RUN_STATUS() + "\n       | WHERE " + Schema.TRIGGERS$.MODULE$.ID() + " = :" + Schema.TRIGGERS$.MODULE$.ID() + "\n     "));
        this.STMT_DELETE_TRIGGER = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("DELETE FROM " + Schema.TRIGGERS$.MODULE$.TABLE() + "\n       | WHERE " + Schema.TRIGGERS$.MODULE$.ID() + " = :" + Schema.TRIGGERS$.MODULE$.ID() + "\n     "));
        this.STMT_GET_ENABLED_TRIGGER_IDS_FOR_TEMPLATE_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT " + Schema.TRIGGERS$.MODULE$.ID() + "\n       | FROM " + Schema.TRIGGERS$.MODULE$.TABLE() + " t\n       | JOIN " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE() + " tt ON tt." + Schema.TEMPLATE_TRIGGERS$.MODULE$.TRIGGER_UID() + " = t." + Schema.TRIGGERS$.MODULE$.CI_UID() + "\n       | JOIN " + Schema.RELEASES$.MODULE$.TABLE() + " r ON tt." + Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID() + " = r." + Schema.RELEASES$.MODULE$.CI_UID() + "\n       |WHERE\n       | r." + Schema.RELEASES$.MODULE$.RELEASE_ID() + " = :templateId\n       | AND t." + Schema.TRIGGERS$.MODULE$.ENABLED() + " = 1\n     "));
        this.STMT_GET_TEMPLATE_TRIGGER_ROW_BY_RELEASE = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT " + Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID() + ", " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TRIGGER_UID() + "\n       | FROM " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE() + "\n       | WHERE " + Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID() + " = :releaseCiUid\n       |"));
        this.templateTriggerRowMapper = (rs, x$2) -> new TemplateTriggerRow(Predef$.MODULE$.int2Integer(rs.getInt(Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID())), Predef$.MODULE$.int2Integer(rs.getInt(Schema.TEMPLATE_TRIGGERS$.MODULE$.TRIGGER_UID())));
        this.INSERT_TEMPLATE_TRIGGER_ROW = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TABLE() + "\n       | (" + Schema.TEMPLATE_TRIGGERS$.MODULE$.RELEASE_UID() + ", " + Schema.TEMPLATE_TRIGGERS$.MODULE$.TRIGGER_UID() + ")\n       | VALUES (:releaseCiUid, :triggerCiUid)\n       |"));
        this.STMT_GET_TRIGGERED_RELEASES_COUNT = "SELECT COUNT(1) FROM " + Schema.TRIGGERED_RELEASES$.MODULE$.TABLE() + " WHERE " + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID() + "=:" + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID();
        this.INSERT_TRIGGERED_RELEASE_ROW = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("INSERT INTO " + Schema.TRIGGERED_RELEASES$.MODULE$.TABLE() + "\n       | (" + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID() + ", " + Schema.TRIGGERED_RELEASES$.MODULE$.TRIGGER_UID() + ", " + Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID() + ")\n       | VALUES (:" + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID() + ", :" + Schema.TRIGGERED_RELEASES$.MODULE$.TRIGGER_UID() + ", :" + Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID() + ")\n       |"));
        this.STMT_DELETE_TRIGGERED_RELEASE_BY_RELEASE_UID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("DELETE FROM " + Schema.TRIGGERED_RELEASES$.MODULE$.TABLE() + "\n       | WHERE " + Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID() + " = :" + Schema.TRIGGERED_RELEASES$.MODULE$.RELEASE_UID() + "\n       |"));
        this.STMT_DELETE_TRIGGERED_RELEASE_BY_TEMPLATE_UID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("DELETE FROM " + Schema.TRIGGERED_RELEASES$.MODULE$.TABLE() + "\n       | WHERE " + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID() + " = :" + Schema.TRIGGERED_RELEASES$.MODULE$.TEMPLATE_UID() + "\n       |"));
    }
}

