/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.events.handler;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderAction;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.TemplateDeletingAction;
import com.xebialabs.xlrelease.domain.events.TemplateMovingAction;
import com.xebialabs.xlrelease.domain.events.TemplateVariablesChangedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.TriggerConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerLifecycle;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001\u0002\b\u0010\u0001qA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!Q\u0005A!b\u0001\n\u0003Y\u0005\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000be\u0003A\u0011\u0001.\t\u000b\t\u0004A\u0011A2\t\u000bQ\u0004A\u0011A;\t\u000bm\u0004A\u0011\u0001?\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0001bBA\u0012\u0001\u0011%\u0011Q\u0005\u0002\u0014)JLwmZ3s\u000bZ,g\u000e\u001e%b]\u0012dWM\u001d\u0006\u0003!E\tq\u0001[1oI2,'O\u0003\u0002\u0013'\u00051QM^3oiNT!\u0001F\u000b\u0002\u0011Q\u0014\u0018nZ4feNT!AF\f\u0002\u0013ad'/\u001a7fCN,'B\u0001\r\u001a\u0003%AXMY5bY\u0006\u00147OC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\r\u0001Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013!B:mMRR'\"\u0001\u0015\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AK\u0013\u0003\u000f1{wmZ5oO\u0006\tBO]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=*\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011G\f\u0002\u0012)JLwmZ3s%\u0016\u0004xn]5u_JL\u0018\u0001\u000b;sS\u001e<WM]\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007C\u0001\u001b<\u001b\u0005)$B\u0001\u001c8\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]*\u0011\u0001(O\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002;]\u0005\u00191/\u001d7\n\u0005q*$\u0001\u000b+sS\u001e<WM]\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"a\u0010\"\u000e\u0003\u0001S!!Q\u000b\u0002\u000fM,'O^5dK&\u00111\t\u0011\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\bue&<w-\u001a:TKJ4\u0018nY3\u0011\u0005\u0019CU\"A$\u000b\u0005\u0005\u001b\u0012BA%H\u00059!&/[4hKJ\u001cVM\u001d<jG\u0016\f\u0001\u0003\u001e:jO\u001e,'\u000fT5gK\u000eL8\r\\3\u0016\u00031\u00032!\u0014)S\u001b\u0005q%BA(H\u0003\u0011IW\u000e\u001d7\n\u0005Es%\u0001\u0005+sS\u001e<WM\u001d'jM\u0016\u001c\u0017p\u00197f!\t\u0019f+D\u0001U\u0015\t)V#\u0001\u0004e_6\f\u0017N\\\u0005\u0003/R\u0013q\u0001\u0016:jO\u001e,'/A\tue&<w-\u001a:MS\u001a,7-_2mK\u0002\na\u0001P5oSRtDCB.^=~\u0003\u0017\r\u0005\u0002]\u00015\tq\u0002C\u0003,\u000f\u0001\u0007A\u0006C\u00033\u000f\u0001\u00071\u0007C\u0003>\u000f\u0001\u0007a\bC\u0003E\u000f\u0001\u0007Q\tC\u0003K\u000f\u0001\u0007A*\u0001\fp]R+W\u000e\u001d7bi\u00164\u0016M]5bE2,7+\u001f8d)\t!w\r\u0005\u0002\u001fK&\u0011am\b\u0002\u0005+:LG\u000fC\u0003i\u0011\u0001\u0007\u0011.A\u0003fm\u0016tG\u000f\u0005\u0002kY6\t1N\u0003\u0002\u0013)&\u0011Qn\u001b\u0002\u001e)\u0016l\u0007\u000f\\1uKZ\u000b'/[1cY\u0016\u001c8\t[1oO\u0016$WI^3oi\"\u0012\u0001b\u001c\t\u0003aJl\u0011!\u001d\u0006\u0003%UI!a]9\u0003\u0013M+(m]2sS\n,\u0017AF8o\u0007>tg-[4ve\u0006$\u0018n\u001c8Va\u0012\fG/\u001a3\u0015\u0005\u00114\b\"\u00025\n\u0001\u00049\bC\u00016y\u0013\tI8NA\rD_:4\u0017nZ;sCRLwN\\+qI\u0006$X\rZ#wK:$\bFA\u0005p\u0003AygNR8mI\u0016\u0014H)\u001a7fi&tw\r\u0006\u0002e{\")aP\u0003a\u0001\u007f\u00061\u0011m\u0019;j_:\u00042A[A\u0001\u0013\r\t\u0019a\u001b\u0002\u0015\r>dG-\u001a:EK2,G/\u001b8h\u0003\u000e$\u0018n\u001c8)\u0005)y\u0017\u0001E8o)\u0016l\u0007\u000f\\1uK6{g/\u001b8h)\r!\u00171\u0002\u0005\u0007}.\u0001\r!!\u0004\u0011\u0007)\fy!C\u0002\u0002\u0012-\u0014A\u0003V3na2\fG/Z'pm&tw-Q2uS>t\u0007FA\u0006p\u0003Iyg\u000eV3na2\fG/\u001a#fY\u0016$\u0018N\\4\u0015\u0007\u0011\fI\u0002\u0003\u0004\u007f\u0019\u0001\u0007\u00111\u0004\t\u0004U\u0006u\u0011bAA\u0010W\n1B+Z7qY\u0006$X\rR3mKRLgnZ!di&|g\u000e\u000b\u0002\r_\u0006\tBm\u001c#fY\u0016$Xm\u00149fe\u0006$\u0018n\u001c8\u0015\u0007\u0011\f9\u0003\u0003\u0004\u007f\u001b\u0001\u0007\u0011\u0011\u0006\t\u0004U\u0006-\u0012bAA\u0017W\naai\u001c7eKJ\f5\r^5p]\"\u001a\u0001!!\r\u0011\u0007A\f\u0019$C\u0002\u00026E\u0014Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\b")
public class TriggerEventHandler
implements Logging {
    private final TriggerRepository triggerRepository;
    private final TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence;
    private final CiIdService ciIdService;
    private final TriggerService triggerService;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerEventHandler triggerEventHandler = this;
        synchronized (triggerEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public TriggerLifecycle<Trigger> triggerLifecycle() {
        return this.triggerLifecycle;
    }

    @Subscribe
    public void onTemplateVariableSync(TemplateVariablesChangedEvent event) {
        String templateId = event.templateId();
        Buffer releaseTriggers = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.triggerRepository.findByTemplateId(templateId, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).getContent()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TriggerEventHandler.$anonfun$onTemplateVariableSync$1(x$1)))).map((Function1 & Serializable)x$2 -> (ReleaseTrigger)x$2);
        releaseTriggers.foreach((Function1 & Serializable)trigger -> {
            TriggerEventHandler.$anonfun$onTemplateVariableSync$3(this, event, trigger);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onConfigurationUpdated(ConfigurationUpdatedEvent event) {
        Seq triggers = this.triggerConfigurationReferencePersistence.getReferencingEntities(event.updated().getId());
        triggers.foreach((Function1 & Serializable)triggerRow -> {
            TriggerEventHandler.$anonfun$onConfigurationUpdated$1(this, triggerRow);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onFolderDeleting(FolderDeletingAction action) {
        this.doDeleteOperation((FolderAction)action);
    }

    @Subscribe
    public void onTemplateMoving(TemplateMovingAction action) {
        int numberOfTemplateTriggers = this.triggerRepository.numberOfTemplateTriggers(action.templateId());
        if (numberOfTemplateTriggers > 0) {
            this.logger().warn((Function0 & Serializable)() -> "Tried to move template " + action.templateId() + " with triggers");
            throw new ItemInUseException("You cannot move the template because it is being used by one or more triggers", new Object[0]);
        }
    }

    @Subscribe
    public void onTemplateDeleting(TemplateDeletingAction action) {
        int numberOfTemplateTriggers = this.triggerRepository.numberOfTemplateTriggers(action.templateId());
        if (numberOfTemplateTriggers > 0) {
            this.triggerRepository.findByTemplateId(action.templateId(), (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).forEach(t -> $this.triggerService.deleteTrigger(t.getId()));
            return;
        }
    }

    private void doDeleteOperation(FolderAction action) {
        PageRequest all = PageRequest.of((int)0, (int)Integer.MAX_VALUE);
        Seq triggers = CollectionConverters$.MODULE$.ListHasAsScala(this.triggerRepository.findByFolderId(action.folderId(), true, (Pageable)all).getContent()).asScala().toSeq();
        triggers.foreach((Function1 & Serializable)t -> {
            this.triggerService.deleteTrigger(t.getId());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$onTemplateVariableSync$1(Trigger x$1) {
        return x$1 instanceof ReleaseTrigger;
    }

    public static final /* synthetic */ void $anonfun$onTemplateVariableSync$3(TriggerEventHandler $this, TemplateVariablesChangedEvent event$1, ReleaseTrigger trigger) {
        Map templateVarsMap = (Map)Map$.MODULE$.apply(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(event$1.templateVariables()).asScala().map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.getKey()), (Object)CiCloneHelper.cloneCi((ConfigurationItem)v)))).toSeq());
        Buffer triggerVariablesNeededForTemplate = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(trigger.getVariables()).asScala().filter((Function1 & Serializable)trigVar -> BoxesRunTime.boxToBoolean((boolean)templateVarsMap.contains((Object)trigVar.getKey())));
        Buffer updatedTriggerVars = (Buffer)triggerVariablesNeededForTemplate.flatMap((Function1 & Serializable)triggerVar -> templateVarsMap.remove((Object)triggerVar.getKey()).map((Function1 & Serializable)templateVar -> {
            block0: {
                if (triggerVar.isValueEmpty()) break block0;
                templateVar.setUntypedValue(triggerVar.getValue());
            }
            return templateVar;
        }));
        Iterable newVariables = templateVarsMap.values();
        List newTriggerVars = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)updatedTriggerVars.$plus$plus((IterableOnce)newVariables)).asJava();
        VariablePersistenceHelper$.MODULE$.fixUpVariableIds(trigger.getId(), newTriggerVars, $this.ciIdService);
        trigger.setVariables(newTriggerVars);
        $this.triggerService.updateVariables((Trigger)trigger);
    }

    public static final /* synthetic */ void $anonfun$onConfigurationUpdated$1(TriggerEventHandler $this, ConfigurationReferenceRow triggerRow) {
        Trigger trigger = $this.triggerService.findById(triggerRow.id());
        $this.triggerService.refreshTrigger(trigger);
    }

    public TriggerEventHandler(TriggerRepository triggerRepository, TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence, CiIdService ciIdService, TriggerService triggerService, TriggerLifecycle<Trigger> triggerLifecycle) {
        this.triggerRepository = triggerRepository;
        this.triggerConfigurationReferencePersistence = triggerConfigurationReferencePersistence;
        this.ciIdService = ciIdService;
        this.triggerService = triggerService;
        this.triggerLifecycle = triggerLifecycle;
        Logging.$init$((Logging)this);
    }
}

