/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.actors;

import com.google.common.base.Objects;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.triggers.action.TriggerActionExecuted;
import com.xebialabs.xlrelease.triggers.action.TriggerActionResult;
import com.xebialabs.xlrelease.triggers.action.TriggerActionSkipped;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDisabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerEnabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerExecutedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerFailedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerSkippedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatingActionEvent;
import com.xebialabs.xlrelease.triggers.package$;
import com.xebialabs.xlrelease.triggers.scheduled.ScheduledTriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionResult;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerLifecycle;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0006\"\u0002,\u0001\t\u00039\u0006\"B0\u0001\t\u0003\u0001\u0007\"\u00028\u0001\t\u0003y\u0007\"\u0002:\u0001\t\u0003\u0019\b\"CA\u001b\u0001E\u0005I\u0011AA\u001c\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001bBq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x!I\u0011Q\u0010\u0001\u0012\u0002\u0013%\u0011q\u0010\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!!#\u0001\t\u0013\tY\fC\u0004\u0002D\u0002!I!!2\u0003#Q\u0013\u0018nZ4fe>\u0003XM]1uS>t7O\u0003\u0002\u0017/\u00051\u0011m\u0019;peNT!\u0001G\r\u0002\u0011Q\u0014\u0018nZ4feNT!AG\u000e\u0002\u0013ad'/\u001a7fCN,'B\u0001\u000f\u001e\u0003%AXMY5bY\u0006\u00147OC\u0001\u001f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013!B:mMRR'\"\u0001\u0017\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AL\u0015\u0003\u000f1{wmZ5oO\u0006\tBO]5hO\u0016\u0014(+\u001a9pg&$xN]=\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005MJ\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011QG\r\u0002\u0012)JLwmZ3s%\u0016\u0004xn]5u_JL\u0018!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u0007O\u0005\u0003sI\u0012\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003!)g/\u001a8u\u0005V\u001c\bC\u0001\u001f@\u001b\u0005i$B\u0001 \u001a\u0003\u0019)g/\u001a8ug&\u0011\u0001)\u0010\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018\u0001\u0005;sS\u001e<WM\u001d'jM\u0016\u001c\u0017p\u00197f!\r\u0019\u0005JS\u0007\u0002\t*\u0011QIR\u0001\u0005S6\u0004HN\u0003\u0002H/\u000591/\u001a:wS\u000e,\u0017BA%E\u0005A!&/[4hKJd\u0015NZ3ds\u000edW\r\u0005\u0002L\u001d6\tAJ\u0003\u0002N3\u00051Am\\7bS:L!a\u0014'\u0003\u000fQ\u0013\u0018nZ4fe\u0006a2m\u001c8gS\u001e,(/\u0019;j_:4\u0016M]5bE2,7+\u001a:wS\u000e,\u0007C\u0001*U\u001b\u0005\u0019&BA$\u001a\u0013\t)6K\u0001\u000fD_:4\u0017nZ;sCRLwN\u001c,be&\f'\r\\3TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0019A&l\u0017/^=B\u0011\u0011\fA\u0007\u0002+!)qF\u0002a\u0001a!)aG\u0002a\u0001o!)!H\u0002a\u0001w!)\u0011I\u0002a\u0001\u0005\")\u0001K\u0002a\u0001#\u0006!a-\u001b8e)\tQ\u0015\rC\u0003c\u000f\u0001\u00071-A\u0005ue&<w-\u001a:JIB\u0011Am\u001b\b\u0003K&\u0004\"AZ\u0012\u000e\u0003\u001dT!\u0001[\u0010\u0002\rq\u0012xn\u001c;?\u0013\tQ7%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016$\u0003)\tG\r\u001a+sS\u001e<WM\u001d\u000b\u0003\u0015BDQ!\u001d\u0005A\u0002)\u000bq\u0001\u001e:jO\u001e,'/A\u0007va\u0012\fG/\u001a+sS\u001e<WM\u001d\u000b\u000b\u0015R4x\u000f @\u0002\u0002\u0005\u0015\u0001\"B;\n\u0001\u0004Q\u0015\u0001C8sS\u001eLg.\u00197\t\u000bEL\u0001\u0019\u0001&\t\u000baL\u0001\u0019A=\u0002\u0011Y\fG.\u001b3bi\u0016\u0004\"A\t>\n\u0005m\u001c#a\u0002\"p_2,\u0017M\u001c\u0005\u0006{&\u0001\r!_\u0001\u000bK6LG/\u0012<f]R\u001c\b\"B@\n\u0001\u0004I\u0018\u0001C5oi\u0016\u0014h.\u00197\t\r\u0005\r\u0011\u00021\u0001z\u0003e\u0019\u0007.Z2l%\u00164WM]3oG\u0016\u0004VM]7jgNLwN\\:\t\u0013\u0005\u001d\u0011\u0002%AA\u0002\u0005%\u0011A\u00039s_B,'\u000f^5fgB)\u00111BA\u000bG:!\u0011QBA\t\u001d\r1\u0017qB\u0005\u0002I%\u0019\u00111C\u0012\u0002\u000fA\f7m[1hK&!\u0011qCA\r\u0005\r\u0019V-\u001d\u0006\u0004\u0003'\u0019\u0003fA\u0005\u0002\u001eA!\u0011qDA\u0019\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012AC1o]>$\u0018\r^5p]*!\u0011qEA\u0015\u0003\u0011\u0019wN]3\u000b\t\u0005-\u0012QF\u0001\u000b[&\u001c'o\\7fi\u0016\u0014(BAA\u0018\u0003\tIw.\u0003\u0003\u00024\u0005\u0005\"!\u0002+j[\u0016$\u0017aF;qI\u0006$X\r\u0016:jO\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\tID\u000b\u0003\u0002\n\u0005m2FAA\u001f!\u0011\ty$a\u0012\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r2%\u0003\u0003\u0002J\u0005\u0005#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y2/\u001a;SK2,\u0017m]3Ue&<w-\u001a:Qe>\u0004XM\u001d;jKN$b!a\u0014\u0002V\u0005e\u0003c\u0001\u0012\u0002R%\u0019\u00111K\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003/Z\u0001\u0019\u0001&\u0002\u0011Q|W\u000b\u001d3bi\u0016DQ!]\u0006A\u0002)\u000bQ\u0002Z3mKR,GK]5hO\u0016\u0014H\u0003BA(\u0003?BQ!\u001d\u0007A\u0002)C3\u0001DA\u000f\u0003\u001d)\u00070Z2vi\u0016$RASA4\u0003SBQ!]\u0007A\u0002)Cq!a\u001b\u000e\u0001\u0004\ti'\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB\u00191)a\u001c\n\u0007\u0005EDIA\fUe&<w-\u001a:Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"\u001aQ\"!\b\u0002\u001b\u0015t\u0017M\u00197f)JLwmZ3s)\u0019\ty%!\u001f\u0002|!)\u0011O\u0004a\u0001\u0015\"9QP\u0004I\u0001\u0002\u0004I\u0018aF3oC\ndW\r\u0016:jO\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tIK\u0002z\u0003w\t\u0001C^1mS\u0012\fG/\u001a$pY\u0012,'/\u00133\u0015\t\u0005=\u0013q\u0011\u0005\u0006cB\u0001\rAS\u0001\u0010G\",7m\u001b,bY&$\u0017\r^5p]R1\u0011qJAG\u0003\u001fCQ!]\tA\u0002)Cq!!%\u0012\u0001\u0004\t\u0019*\u0001\u0003ng\u001e\u001c\bCBAK\u0003?\u000b\u0019+\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u0011)H/\u001b7\u000b\u0005\u0005u\u0015\u0001\u00026bm\u0006LA!!)\u0002\u0018\n!A*[:u!\u0011\t)+a.\u000e\u0005\u0005\u001d&\u0002BAU\u0003W\u000b!B^1mS\u0012\fG/[8o\u0015\u0011\ti+a,\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u00022\u0006M\u0016A\u00029mk\u001eLgNC\u0002\u00026n\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003s\u000b9KA\tWC2LG-\u0019;j_:lUm]:bO\u0016$b!a\u0014\u0002>\u0006\u0005\u0007BBA`%\u0001\u0007!*\u0001\u0002dS\"1\u00111\u0001\nA\u0002e\fq\"\u001e9eCR,g+\u0019:jC\ndWm\u001d\u000b\u0005\u0003\u001f\n9\rC\u0003r'\u0001\u0007!\n")
public class TriggerOperations
implements Logging {
    private final TriggerRepository triggerRepository;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private final ConfigurationVariableService configurationVariableService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerOperations triggerOperations = this;
        synchronized (triggerOperations) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Trigger find(String triggerId) {
        return this.triggerRepository.find(triggerId);
    }

    public Trigger addTrigger(Trigger trigger) {
        this.validateFolderId(trigger);
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)None$.MODULE$, (ConfigurationItem)trigger);
        this.checkValidation(trigger, true);
        this.updateVariables(trigger);
        CiHelper.fixUpInternalReferences((ConfigurationItem)trigger);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerCreatingActionEvent(trigger));
        Trigger addedTrigger = this.triggerRepository.create(trigger);
        this.eventBus.publish((XLReleaseEvent)new TriggerCreatedEvent(addedTrigger));
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        return addedTrigger;
    }

    @Timed
    public Trigger updateTrigger(Trigger original, Trigger trigger, boolean validate2, boolean emitEvents, boolean internal, boolean checkReferencePermissions, scala.collection.immutable.Seq<String> properties) {
        Trigger updated;
        block5: {
            Trigger trigger2;
            this.trace((Function0<Object>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Updating trigger " + original + " properties: '" + properties.mkString(",") + "'\n         |previous: " + package$.MODULE$.TriggerExtensions(original).toJson() + "\n         |new: " + package$.MODULE$.TriggerExtensions(trigger).toJson())));
            if (properties.isEmpty()) {
                CollectionConverters$.MODULE$.ListHasAsScala(trigger.getInternalProperties()).asScala().foreach((Function1 & Serializable)internalProperty -> {
                    trigger.setProperty(internalProperty, original.getProperty(internalProperty));
                    return BoxedUnit.UNIT;
                });
                trigger2 = trigger;
            } else {
                trigger2 = (Trigger)CiCloneHelper.cloneCi((ConfigurationItem)original);
            }
            Trigger toUpdate = trigger2;
            toUpdate.setCiUid(original.getCiUid());
            toUpdate.setFolderId(new FolderId(trigger.getFolderId()).absolute());
            toUpdate.setId(Ids.formatWithFolderId((String)trigger.getFolderId(), (String)Ids.getName((String)trigger.getId())));
            CiHelper.fixUpInternalReferences((ConfigurationItem)toUpdate);
            if (!new FolderId(original.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
                this.validateFolderId(toUpdate);
            }
            properties.foreach((Function1 & Serializable)propertyToUpdate -> {
                toUpdate.setProperty(propertyToUpdate, trigger.getProperty(propertyToUpdate));
                return BoxedUnit.UNIT;
            });
            this.setReleaseTriggerProperties(toUpdate, trigger);
            if (validate2) {
                PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)new Some((Object)original), (ConfigurationItem)toUpdate);
                this.checkValidation(toUpdate, checkReferencePermissions);
                this.updateVariables(toUpdate);
                this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerUpdatingActionEvent(original, toUpdate));
            }
            updated = this.triggerRepository.update(toUpdate);
            if (!internal) {
                boolean emitStateEvent = emitEvents && (!Objects.equal((Object)BoxesRunTime.boxToBoolean((boolean)original.isEnabled()), (Object)BoxesRunTime.boxToBoolean((boolean)updated.isEnabled())) || properties.contains((Object)"enabled"));
                this.enableTrigger(updated, emitStateEvent);
            }
            if (!emitEvents) break block5;
            this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedEvent(original, updated));
        }
        return updated;
    }

    public scala.collection.immutable.Seq<String> updateTrigger$default$7() {
        return (scala.collection.immutable.Seq)Nil$.MODULE$;
    }

    private void setReleaseTriggerProperties(Trigger toUpdate, Trigger trigger) {
        Trigger trigger2 = toUpdate;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            releaseTrigger.setReleaseFolder(((ReleaseTrigger)trigger).getReleaseFolder());
            return;
        }
    }

    @Timed
    public void deleteTrigger(Trigger trigger) {
        trigger.setEnabled(false);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerDeletingActionEvent(trigger));
        this.triggerRepository.delete(trigger.getId());
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        this.eventBus.publish((XLReleaseEvent)new TriggerDeletedEvent(trigger));
    }

    @Timed
    public Trigger execute(Trigger trigger, TriggerExecutionContext executionContext) {
        Try result;
        Trigger x$1 = trigger;
        GlobalVariables x$2 = this.configurationVariableService.resolveFromCi$default$2();
        Function1 x$3 = this.configurationVariableService.resolveFromCi$default$3((ConfigurationItem)x$1, x$2);
        this.configurationVariableService.resolveFromCi((ConfigurationItem)x$1, x$2, x$3);
        TriggerExecutionResult<Trigger> triggerExecutionResult = this.triggerLifecycle.execute(trigger, executionContext);
        if (triggerExecutionResult == null) {
            throw new MatchError(triggerExecutionResult);
        }
        Trigger maybeExecutedTrigger = triggerExecutionResult.trigger();
        Try<TriggerActionResult> result2 = triggerExecutionResult.results();
        Tuple2 tuple2 = new Tuple2((Object)maybeExecutedTrigger, result2);
        Trigger maybeExecutedTrigger2 = (Trigger)tuple2._1();
        Try try_ = result = (Try)tuple2._2();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.eventBus.publish((XLReleaseEvent)new TriggerFailedEvent(trigger, e.getMessage(), executionContext.getExecutionDataId()));
            throw e;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            TriggerActionResult actionResult = (TriggerActionResult)success.value();
            TriggerActionResult triggerActionResult = actionResult;
            if (triggerActionResult instanceof TriggerActionExecuted) {
                TriggerActionExecuted triggerActionExecuted = (TriggerActionExecuted)triggerActionResult;
                String result3 = triggerActionExecuted.result();
                this.eventBus.publish((XLReleaseEvent)new TriggerExecutedEvent(maybeExecutedTrigger2, result3, executionContext.getExecutionDataId()));
            } else if (triggerActionResult instanceof TriggerActionSkipped) {
                TriggerActionSkipped triggerActionSkipped = (TriggerActionSkipped)triggerActionResult;
                String message = triggerActionSkipped.message();
                if (!(executionContext instanceof ScheduledTriggerExecutionContext)) {
                    this.eventBus.publish((XLReleaseEvent)new TriggerSkippedEvent(maybeExecutedTrigger2, message, executionContext.getExecutionDataId()));
                }
            }
            return maybeExecutedTrigger2;
        }
        throw new MatchError((Object)try_);
    }

    private void enableTrigger(Trigger trigger, boolean emitEvents) {
        if (trigger.isEnabled()) {
            this.triggerLifecycle.enable(trigger, true);
            if (emitEvents) {
                this.eventBus.publish((XLReleaseEvent)new TriggerEnabledEvent(trigger));
                return;
            }
            return;
        }
        this.triggerLifecycle.disable(trigger);
        if (emitEvents) {
            this.eventBus.publish((XLReleaseEvent)new TriggerDisabledEvent(trigger));
            return;
        }
    }

    private boolean enableTrigger$default$2() {
        return true;
    }

    private void validateFolderId(Trigger trigger) {
        if (new FolderId(trigger.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
            trigger.get$validationMessages().add(new ValidationMessage(trigger.getId(), "folderId", "You cannot create trigger on the root folder. The root folder path is not supported."));
            return;
        }
    }

    private void checkValidation(Trigger trigger, List<ValidationMessage> msgs) {
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(msgs).asScala().nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)trigger.get$validationMessages().addAll(msgs)) : BoxedUnit.UNIT;
        if (CollectionConverters$.MODULE$.ListHasAsScala(trigger.get$validationMessages()).asScala().nonEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)trigger);
        }
    }

    private void checkValidation(Trigger ci, boolean checkReferencePermissions) {
        this.checkValidation(ci, this.triggerLifecycle.validate(ci, checkReferencePermissions));
    }

    private void updateVariables(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            List variables = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.findById(releaseTrigger.getTemplate(), ResolveOptions$.MODULE$.WITH_DECORATORS()).getVariables()).asScala().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$1(releaseTrigger, v)))).toList()).asJava();
            Release variableHolderTemplate = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate()).withVariables(variables).build();
            variableHolderTemplate.setVariableValues(CollectionConverters$.MODULE$.MutableMapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(releaseTrigger.getTemplateVariableValues(x$2 -> !x$2.isPassword())).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$3(x$3)))).asJava());
            variableHolderTemplate.setPasswordVariableValues(releaseTrigger.getTemplatePasswordVariables());
            releaseTrigger.setVariables(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variableHolderTemplate.getVariables()).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$4(x$4)))).toList()).asJava());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$1(ReleaseTrigger x2$1, Variable v) {
        return x2$1.getVariablesByKeys().containsKey(v.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 x$3) {
        return x$3._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Variable x$4) {
        return x$4.getId() != null;
    }

    public TriggerOperations(TriggerRepository triggerRepository, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, TriggerLifecycle<Trigger> triggerLifecycle, ConfigurationVariableService configurationVariableService) {
        this.triggerRepository = triggerRepository;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.triggerLifecycle = triggerLifecycle;
        this.configurationVariableService = configurationVariableService;
        Logging.$init$((Logging)this);
    }
}

