package com.xebialabs.xlrelease.triggers.events.handler

import com.xebialabs.xlrelease.domain.Trigger
import com.xebialabs.xlrelease.domain.status.TriggerExecutionStatus
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.triggers.events.{TriggerExecutedEvent, TriggerFailedEvent, TriggerFilterFailedEvent}
import com.xebialabs.xlrelease.triggers.service.TriggerService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.Date

@Service
@EventListener
class TriggerLastRunEventHandler @Autowired()(triggerService: TriggerService) {

  @Subscribe
  def triggerExecuted(event: TriggerExecutedEvent): Unit =
    updateState(event.trigger, TriggerExecutionStatus.SUCCESS)

  @Subscribe
  def triggerFailed(event: TriggerFailedEvent): Unit =
    updateState(event.trigger, TriggerExecutionStatus.FAILURE)

  @Subscribe
  def filterFailed(event: TriggerFilterFailedEvent): Unit =
    updateState(event.trigger, TriggerExecutionStatus.FAILURE)

  def updateState(trigger: Trigger, status: TriggerExecutionStatus): Unit = {
    trigger.setLastRunDate(new Date())
    trigger.setLastRunStatus(status)

    triggerService.updateInternalState(trigger, Seq("lastRunDate", "lastRunStatus"))
  }
}
