/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.internal.BaseActivityLogsResource;
import com.xebialabs.xlrelease.service.BaseActivityLogsService;
import com.xebialabs.xlrelease.triggers.activity.TriggerActivityLogsService;
import com.xebialabs.xlrelease.triggers.security.TriggerPermissionChecker;
import com.xebialabs.xlrelease.views.ActivityLogEntryView;
import com.xebialabs.xlrelease.views.LogsFilters;
import com.xebialabs.xlrelease.views.converters.UserViewConverter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;

@Path(value="/activity")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class TriggerActivityLogsResource
extends BaseActivityLogsResource {
    private final TriggerPermissionChecker triggerPermissionChecker;
    private final TriggerActivityLogsService triggerActivityLogsService;

    @Autowired
    public TriggerActivityLogsResource(TriggerActivityLogsService triggerActivityLogsService, UserViewConverter userViewConverter, TriggerPermissionChecker triggerPermissionChecker) {
        super((BaseActivityLogsService)triggerActivityLogsService, userViewConverter);
        this.triggerPermissionChecker = triggerPermissionChecker;
        this.triggerActivityLogsService = triggerActivityLogsService;
    }

    @POST
    @Path(value="/{triggerId:.*Trigger[^/-]*}/logs/search")
    public List<ActivityLogEntryView> searchTriggerLogs(@PathParam(value="triggerId") String triggerId, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage, LogsFilters filters) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than %d", (Object[])new Object[]{100L});
        this.triggerPermissionChecker.checkViewTrigger(triggerId);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage, (Sort)Sort.unsorted());
        return this.searchLogs(triggerId, filters, (Pageable)pageable);
    }

    @GET
    @Path(value="/data/{dataId}")
    public String getTriggerActivityLogEntryData(@PathParam(value="dataId") String dataId) {
        return this.triggerActivityLogsService.getTriggerActivityLogData(dataId);
    }
}

