package com.xebialabs.xlrelease.triggers.activity

import com.xebialabs.xlrelease.domain.ActivityLogEntry
import com.xebialabs.xlrelease.handler.BaseActivityLogsApiHandler
import com.xebialabs.xlrelease.triggers.security.TriggerPermissionChecker
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util

@Component
class TriggerActivityLogsApiHandler @Autowired()(triggerActivityLogsService: TriggerActivityLogsService, permissions: TriggerPermissionChecker)
  extends BaseActivityLogsApiHandler(triggerActivityLogsService, "trigger") {
  
  override def getActivityLogs(triggerId: String): util.List[ActivityLogEntry] = {
    permissions.checkViewTrigger(triggerId)
    searchLogs(triggerId)
  }
}
