package com.xebialabs.xlrelease.triggers.event_based

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventConsumer}
import com.xebialabs.xlrelease.repository.Ids.SEPARATOR
import com.xebialabs.xlrelease.webhooks.consumers.BaseConsumer.CONSUMER_ID_SUFFIX

case class EventBasedTriggerConsumer(targetId: String, _eventType: Type, enabled: Boolean)
  extends BaseConfigurationItem with EventConsumer {

  def this() = this(null, Type.valueOf(classOf[Event]), false)

  def this(trigger: EventBasedTrigger) = this(trigger.getId, Type.valueOf(trigger.eventType), trigger.isEnabled)

  Option(targetId).foreach { id =>
    setId(id + SEPARATOR + CONSUMER_ID_SUFFIX)
  }

  setInputEventType(_eventType.toString)
  setConsumerEnabled(enabled)
}
