/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.scheduled.quartz;

import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.domain.PollType;
import com.xebialabs.xlrelease.domain.ScheduledTrigger;
import com.xebialabs.xlrelease.quartz.release.scheduler.ReleaseSchedulerService;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.triggers.scheduled.ScheduledJobService;
import com.xebialabs.xlrelease.triggers.scheduled.quartz.QuartzScheduledJobService$;
import com.xebialabs.xlrelease.triggers.scheduled.quartz.TriggerQuartzJob;
import com.xebialabs.xlrelease.utils.QuartzUtils;
import com.xebialabs.xlrelease.utils.QuartzUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Marker;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.retry.support.RetryTemplateBuilder;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001\u0002\t\u0012\u0001yA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\u0006w\u0001!\t\u0001\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0011\u0019q\u0005\u0001)A\u0005\u0005\")q\n\u0001C!!\")A\f\u0001C!;\")q\f\u0001C\u0005A\u001e)A/\u0005E\u0001k\u001a)\u0001#\u0005E\u0001m\")1(\u0003C\u0001o\u001a!\u00010C\u0001z\u0011!Q8B!A!\u0002\u00131\u0006\"B\u001e\f\t\u0003Y\bBB@\f\t\u0003\t\t\u0001C\u0005\u0002\u001a%\t\t\u0011b\u0001\u0002\u001c\tI\u0012+^1sij\u001c6\r[3ek2,GMS8c'\u0016\u0014h/[2f\u0015\t\u00112#\u0001\u0004rk\u0006\u0014HO\u001f\u0006\u0003)U\t\u0011b]2iK\u0012,H.\u001a3\u000b\u0005Y9\u0012\u0001\u0003;sS\u001e<WM]:\u000b\u0005aI\u0012!\u0003=me\u0016dW-Y:f\u0015\tQ2$A\u0005yK\nL\u0017\r\\1cg*\tA$A\u0002d_6\u001c\u0001a\u0005\u0003\u0001?\u0015J\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'O5\t1#\u0003\u0002)'\t\u00192k\u00195fIVdW\r\u001a&pEN+'O^5dKB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0006g24GG\u001b\u0006\u0002]\u0005AqM]5{u2,G-\u0003\u00021W\t9Aj\\4hS:<\u0017a\u0006:fY\u0016\f7/Z*dQ\u0016$W\u000f\\3s'\u0016\u0014h/[2f!\t\u0019\u0014(D\u00015\u0015\t)d'A\u0005tG\",G-\u001e7fe*\u0011q\u0007O\u0001\be\u0016dW-Y:f\u0015\t\u0011r#\u0003\u0002;i\t9\"+\u001a7fCN,7k\u00195fIVdWM]*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005uz\u0004C\u0001 \u0001\u001b\u0005\t\u0002\"B\u0019\u0003\u0001\u0004\u0011\u0014!\u0004:fiJLH+Z7qY\u0006$X-F\u0001C!\t\u0019E*D\u0001E\u0015\t)e)A\u0004tkB\u0004xN\u001d;\u000b\u0005\u001dC\u0015!\u0002:fiJL(BA%K\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A&\u0002\u0007=\u0014x-\u0003\u0002N\t\ni!+\u001a;ssR+W\u000e\u001d7bi\u0016\faB]3uef$V-\u001c9mCR,\u0007%\u0001\u0005tG\",G-\u001e7f)\t\tF\u000b\u0005\u0002!%&\u00111+\t\u0002\u0005+:LG\u000fC\u0003V\u000b\u0001\u0007a+\u0001\ttG\",G-\u001e7fIR\u0013\u0018nZ4feB\u0011qKW\u0007\u00021*\u0011\u0011lF\u0001\u0007I>l\u0017-\u001b8\n\u0005mC&\u0001E*dQ\u0016$W\u000f\\3e)JLwmZ3s\u0003))hn]2iK\u0012,H.\u001a\u000b\u0003#zCQ!\u0016\u0004A\u0002Y\u000bq\u0002\u001e:jO\u001e,'oU2iK\u0012,H.\u001a\u000b\u0003CJ\u0004$AY5\u0011\u0007\r,w-D\u0001e\u0015\t\u0011\"*\u0003\u0002gI\ny1k\u00195fIVdWMQ;jY\u0012,'\u000f\u0005\u0002iS2\u0001A!\u00036\b\u0003\u0003\u0005\tQ!\u0001l\u0005\ryF%M\t\u0003Y>\u0004\"\u0001I7\n\u00059\f#a\u0002(pi\"Lgn\u001a\t\u0003GBL!!\u001d3\u0003\u000fQ\u0013\u0018nZ4fe\")1o\u0002a\u0001-\u0006q!/\u001a7fCN,GK]5hO\u0016\u0014\u0018!G)vCJ$(pU2iK\u0012,H.\u001a3K_\n\u001cVM\u001d<jG\u0016\u0004\"AP\u0005\u0014\u0005%yB#A;\u0003!Q\u0013\u0018nZ4fe\u0016CH/\u001a8tS>t7CA\u0006 \u0003\u001d!(/[4hKJ$\"\u0001 @\u0011\u0005u\\Q\"A\u0005\t\u000bil\u0001\u0019\u0001,\u0002\u00199|'/\\1mSj,G-\u00133\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003'qA!a\u0002\u0002\u0010A\u0019\u0011\u0011B\u0011\u000e\u0005\u0005-!bAA\u0007;\u00051AH]8pizJ1!!\u0005\"\u0003\u0019\u0001&/\u001a3fM&!\u0011QCA\f\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011C\u0011\u0002!Q\u0013\u0018nZ4fe\u0016CH/\u001a8tS>tGc\u0001?\u0002\u001e!)!p\u0004a\u0001-\u0002")
public class QuartzScheduledJobService
implements ScheduledJobService,
Logging {
    private final ReleaseSchedulerService releaseSchedulerService;
    private final RetryTemplate retryTemplate;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static TriggerExtension TriggerExtension(ScheduledTrigger trigger) {
        return QuartzScheduledJobService$.MODULE$.TriggerExtension(trigger);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        QuartzScheduledJobService quartzScheduledJobService = this;
        synchronized (quartzScheduledJobService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public RetryTemplate retryTemplate() {
        return this.retryTemplate;
    }

    @Override
    public void schedule(ScheduledTrigger scheduledTrigger) {
        this.logger().debug((Function0 & Serializable)() -> "Schedule trigger " + QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId());
        String triggerType = scheduledTrigger.getType().toString();
        Class<TriggerQuartzJob> jobClass = TriggerQuartzJob.class;
        JobDetail job = JobBuilder.newJob(jobClass).withDescription("Trigger '" + QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId() + "'").withIdentity(QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId(), triggerType).storeDurably(true).build();
        Trigger quartzTrigger = TriggerBuilder.newTrigger().withIdentity(QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId(), triggerType).withDescription("Trigger '" + QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId() + "'").withSchedule(this.triggerSchedule(scheduledTrigger)).startNow().build();
        this.releaseSchedulerService.schedule(job, quartzTrigger);
    }

    @Override
    public void unschedule(ScheduledTrigger scheduledTrigger) {
        this.logger().debug((Function0 & Serializable)() -> "Unschedule trigger " + QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId());
        JobKey jobKey = new JobKey(scheduledTrigger.getName(), scheduledTrigger.getType().toString());
        RetryCallback retryCallback = x$1 -> BoxesRunTime.boxToBoolean((boolean)this.releaseSchedulerService.unschedule(jobKey));
        this.retryTemplate().execute(retryCallback);
    }

    private ScheduleBuilder<? extends Trigger> triggerSchedule(ScheduledTrigger releaseTrigger) {
        SimpleScheduleBuilder simpleScheduleBuilder;
        PollType pollType = releaseTrigger.getPollType();
        if (PollType.REPEAT.equals(pollType)) {
            simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(releaseTrigger.getPeriodicity()))).withMisfireHandlingInstructionNextWithRemainingCount().repeatForever();
        } else if (PollType.CRON.equals(pollType)) {
            String timezoneName = XlrConfig$.MODULE$.getInstance().quartz().timezone();
            TimeZone timezone = timezoneName.isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(timezoneName);
            simpleScheduleBuilder = CronScheduleBuilder.cronSchedule((String)QuartzUtils.QuartzCron$.MODULE$.asQuartzCron$extension(QuartzUtils$.MODULE$.QuartzCron(releaseTrigger.getPeriodicity()))).inTimeZone(timezone).withMisfireHandlingInstructionDoNothing();
        } else {
            throw new MatchError((Object)pollType);
        }
        SimpleScheduleBuilder scheduleBuilder = simpleScheduleBuilder;
        return scheduleBuilder;
    }

    public QuartzScheduledJobService(ReleaseSchedulerService releaseSchedulerService) {
        this.releaseSchedulerService = releaseSchedulerService;
        Logging.$init$((Logging)this);
        this.retryTemplate = new RetryTemplateBuilder().fixedBackoff(250L).maxAttempts(8).build();
    }

    public static class TriggerExtension {
        private final ScheduledTrigger trigger;

        public String normalizedId() {
            return Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(this.trigger.getId())));
        }

        public TriggerExtension(ScheduledTrigger trigger) {
            this.trigger = trigger;
        }
    }
}

