/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.api.v1.TriggersApi;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.triggers.security.TriggerPermissionChecker;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.utils.SortSupport;
import com.xebialabs.xlrelease.view.ReleaseTriggerOverview;
import com.xebialabs.xlrelease.views.BulkActionResultView;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;

@Controller
public class TriggersApiImpl
implements TriggersApi {
    private final TriggerPermissionChecker triggerPermissionChecker;
    private final TriggerService triggerService;

    @Autowired
    public TriggersApiImpl(TriggerPermissionChecker triggerPermissionChecker, TriggerService triggerService) {
        this.triggerPermissionChecker = triggerPermissionChecker;
        this.triggerService = triggerService;
    }

    @Timed
    public Page<ReleaseTriggerOverview> searchTriggers(TriggerFilters triggerFilters, int page, int resultsPerPage, UriInfo uriInfo) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than %d", (Object[])new Object[]{100L});
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage, (Sort)SortSupport.toSort((UriInfo)uriInfo));
        return this.searchTriggers(triggerFilters, (Pageable)pageable);
    }

    @Timed
    public List<ReleaseTriggerOverview> searchTriggers(TriggerFilters triggerFilters, int page, int resultsPerPage, Sort sort) {
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage, (Sort)sort);
        return this.searchTriggers(triggerFilters, (Pageable)pageable).getContent();
    }

    @Timed
    public List<ReleaseTriggerOverview> searchTriggers(TriggerFilters triggerFilters, int page, int resultsPerPage) {
        return this.searchTriggers(triggerFilters, page, resultsPerPage, Sort.unsorted());
    }

    private Page<ReleaseTriggerOverview> searchTriggers(TriggerFilters triggerFilters, Pageable pageable) {
        if (triggerFilters == null) {
            triggerFilters = new TriggerFilters();
        }
        return this.triggerService.findBy(triggerFilters, pageable);
    }

    @Timed
    public void enableTrigger(String triggerId) {
        this.triggerPermissionChecker.checkEditTrigger(triggerId);
        this.triggerService.updateTriggerStatus(triggerId, true, true);
    }

    @Timed
    public BulkActionResultView enableTriggers(List<String> triggerIds) {
        List<String> allowedTriggers = this.triggerPermissionChecker.filterEditableTriggers(triggerIds);
        List<String> enabledTriggers = this.triggerService.enableTriggers(allowedTriggers);
        return new BulkActionResultView(enabledTriggers);
    }

    @Timed
    public BulkActionResultView enableAllTriggers() {
        List<String> enabledTriggers = this.triggerService.enableAllAccessibleTriggers();
        return new BulkActionResultView(enabledTriggers);
    }

    @Timed
    public void disableTrigger(String triggerId) {
        this.triggerPermissionChecker.checkEditTrigger(triggerId);
        this.triggerService.updateTriggerStatus(triggerId, false, true);
    }

    @Timed
    public BulkActionResultView disableTriggers(List<String> triggerIds) {
        List<String> allowedTriggers = this.triggerPermissionChecker.filterEditableTriggers(triggerIds);
        List<String> disabledTriggers = this.triggerService.disableTriggers(allowedTriggers);
        return new BulkActionResultView(disabledTriggers);
    }

    @Timed
    public BulkActionResultView disableAllTriggers() {
        List<String> disabledTriggers = this.triggerService.disableAllAccessibleTriggers();
        return new BulkActionResultView(disabledTriggers);
    }

    @Timed
    public void removeTrigger(String triggerId) {
        this.triggerPermissionChecker.checkEditTrigger(triggerId);
        this.triggerService.deleteTrigger(triggerId);
    }

    @Timed
    public void runTrigger(String triggerId) {
        this.triggerPermissionChecker.checkEditTrigger(triggerId);
        this.triggerService.runNowTrigger(triggerId);
    }

    @Timed
    public List<Descriptor> getTypes() {
        return DescriptorRegistry.getSubtypes((Type)Type.valueOf(Trigger.class)).stream().map(Type::getDescriptor).filter(desc -> !desc.isVirtual() && !desc.getType().equals((Object)Type.valueOf(ReleaseTrigger.class))).collect(Collectors.toList());
    }

    @Timed
    public Trigger addTrigger(Trigger trigger) {
        this.triggerPermissionChecker.checkEditTrigger(trigger);
        return this.triggerService.addTrigger(trigger);
    }

    @Timed
    public Trigger getTrigger(String triggerId) {
        Trigger trigger = this.triggerService.findById(triggerId);
        this.triggerPermissionChecker.checkViewTrigger(trigger);
        return trigger;
    }

    @Timed
    public Trigger updateTrigger(String triggerId, Trigger trigger) {
        this.triggerPermissionChecker.checkEditTrigger(triggerId);
        trigger.setId(triggerId);
        return this.triggerService.updateTrigger(trigger);
    }
}

