/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.management.repository;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.repository.query.PageableQuery;
import com.xebialabs.xlrelease.repository.query.Query;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.triggers.management.repository.QueryBuilder$;
import com.xebialabs.xlrelease.triggers.management.repository.SqlTriggerFiltersQueryBuilder;
import com.xebialabs.xlrelease.triggers.management.repository.TriggerListQueryBuilder;
import com.xebialabs.xlrelease.triggers.management.repository.TriggerListQueryBuilder$;
import com.xebialabs.xlrelease.triggers.security.TriggerPermissions$;
import com.xebialabs.xlrelease.view.ReleaseTriggerOverview;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001\u0002\b\u0010\u0001qA\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tm\u0001\u0011\t\u0011)A\u0005]!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003:\u0011!i\u0004A!b\u0001\n\u0003q\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B \t\u00111\u0003!Q1A\u0005\u00045C\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006M\u0002!\ta\u001a\u0005\u0006]\u0002!\ta\u001c\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\t\u0019\u0005\u0001C\u0005\u0003\u000bBq!!\u0017\u0001\t\u0013\t)EA\u000eUe&<w-\u001a:NC:\fw-Z7f]R\u0014V\r]8tSR|'/\u001f\u0006\u0003!E\t!B]3q_NLGo\u001c:z\u0015\t\u00112#\u0001\u0006nC:\fw-Z7f]RT!\u0001F\u000b\u0002\u0011Q\u0014\u0018nZ4feNT!AF\f\u0002\u0013ad'/\u001a7fCN,'B\u0001\r\u001a\u0003%AXMY5bY\u0006\u00147OC\u0001\u001b\u0003\r\u0019w.\\\u0002\u0001'\r\u0001Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011RS\"A\u0013\u000b\u0005\u0019:\u0013a\u00039feNL7\u000f^3oG\u0016T!\u0001K\u0015\u0002\u0007M\fHN\u0003\u0002\u0011+%\u00111&\n\u0002\u0013!\u0016\u00148/[:uK:\u001cWmU;qa>\u0014H/\u0001\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014X#\u0001\u0018\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005M:\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005U\u0002$A\u0005)fe6L7o]5p]\u0016sgm\u001c:dKJ\f1\u0003]3s[&\u001c8/[8o\u000b:4wN]2fe\u0002\n1B]8mKN+'O^5dKV\t\u0011\b\u0005\u00020u%\u00111\b\r\u0002\f%>dWmU3sm&\u001cW-\u0001\u0007s_2,7+\u001a:wS\u000e,\u0007%\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u0001@!\t\u0001\u0015*D\u0001B\u0015\t\u00115)\u0001\u0003d_J,'B\u0001#F\u0003\u0011QGMY2\u000b\u0005\u0019;\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003!\u000b1a\u001c:h\u0013\tQ\u0015I\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\bI&\fG.Z2u+\u0005q\u0005CA(c\u001d\t\u0001vL\u0004\u0002R;:\u0011!k\u0017\b\u0003'js!\u0001V-\u000f\u0005UCV\"\u0001,\u000b\u0005][\u0012A\u0002\u001fs_>$h(C\u0001\u001b\u0013\tA\u0012$\u0003\u0002\u0017/%\u0011A,F\u0001\u0003I\nL!\u0001\u000b0\u000b\u0005q+\u0012B\u00011b\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003QyK!a\u00193\u0003\u000f\u0011K\u0017\r\\3di*\u0011\u0001-Y\u0001\tI&\fG.Z2uA\u00051A(\u001b8jiz\"R\u0001\u001b6lY6\u0004\"!\u001b\u0001\u000e\u0003=AQ\u0001L\u0005A\u00029BQaN\u0005A\u0002eBQ!P\u0005A\u0002}BQ\u0001T\u0005A\u00049\u000baAZ5oI\nKH\u0003\u00029\u007f\u0003+\u00012!\u001d<y\u001b\u0005\u0011(BA:u\u0003\u0019!w.\\1j]*\u0011Q/R\u0001\u0005I\u0006$\u0018-\u0003\u0002xe\n!\u0001+Y4f!\tIH0D\u0001{\u0015\tYX#\u0001\u0003wS\u0016<\u0018BA?{\u0005Y\u0011V\r\\3bg\u0016$&/[4hKJ|e/\u001a:wS\u0016<\bBB@\u000b\u0001\u0004\t\t!\u0001\bue&<w-\u001a:GS2$XM]:\u0011\t\u0005\r\u0011\u0011C\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u00051a-\u001b7uKJTA!a\u0003\u0002\u000e\u0005\u0011a/\r\u0006\u0004\u0003\u001f)\u0012aA1qS&!\u00111CA\u0003\u00059!&/[4hKJ4\u0015\u000e\u001c;feNDq!a\u0006\u000b\u0001\u0004\tI\"\u0001\u0005qC\u001e,\u0017M\u00197f!\r\t\u00181D\u0005\u0004\u0003;\u0011(\u0001\u0003)bO\u0016\f'\r\\3\u00023\u0019Lg\u000eZ!mY\u0016#\u0017\u000e^1cY\u0016$&/[4hKJLEm\u001d\u000b\u0003\u0003G\u0001b!!\n\u00020\u0005MRBAA\u0014\u0015\u0011\tI#a\u000b\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003[\tAA[1wC&!\u0011\u0011GA\u0014\u0005\u0011a\u0015n\u001d;\u0011\t\u0005U\u0012Q\b\b\u0005\u0003o\tI\u0004\u0005\u0002V?%\u0019\u00111H\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\rM#(/\u001b8h\u0015\r\tYdH\u0001\u0012GV\u0014(/\u001a8u!JLgnY5qC2\u001cHCAA$!\u0019\tI%a\u0015\u000249!\u00111JA(\u001d\r)\u0016QJ\u0005\u0002A%\u0019\u0011\u0011K\u0010\u0002\u000fA\f7m[1hK&!\u0011QKA,\u0005!IE/\u001a:bE2,'bAA)?\u0005q1-\u001e:sK:$(k\u001c7f\u0013\u0012\u001c\b")
public class TriggerManagementRepository
implements PersistenceSupport {
    private final PermissionEnforcer permissionEnforcer;
    private final RoleService roleService;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;

    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$((PersistenceSupport)this, params);
    }

    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params);
    }

    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$((PersistenceSupport)this, (String)sqlStatement, params, callback);
    }

    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$((PersistenceSupport)this, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$((PersistenceSupport)this, (String)pkColumn, (String)sqlStatement, params, contentParam, mapper);
    }

    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$((PersistenceSupport)this, (String)sqlStatement, (MapSqlParameterSource)params, mapper);
    }

    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$((PersistenceSupport)this, (String)sqlStatement, setup, callback);
    }

    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (String)entityId);
    }

    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$((PersistenceSupport)this, (Integer)uid, token, (UUID)freshToken);
    }

    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$((PersistenceSupport)this, (Integer)uid);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, mapper);
    }

    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, (String)sqlStatement, params, extractor);
    }

    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$((PersistenceSupport)this, (String)sqlStatement, parameters);
    }

    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$((PersistenceSupport)this, (String)sqlStatement, params);
    }

    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$((PersistenceSupport)this, (String)pkColumn);
    }

    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$((PersistenceSupport)this, pairs);
    }

    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, (String)text);
    }

    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, (InputStream)inputStream);
    }

    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, (byte[])byteArray);
    }

    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, (byte[])byteArray);
    }

    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$((Utils)this, body, (JdbcTemplate)jdbcTemplate);
    }

    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$((Utils)this, body);
    }

    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$((Utils)this, body);
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        TriggerManagementRepository triggerManagementRepository = this;
        synchronized (triggerManagementRepository) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$((PersistenceSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public Page<ReleaseTriggerOverview> findBy(TriggerFilters triggerFilters, Pageable pageable) {
        SqlTriggerFiltersQueryBuilder builder = (SqlTriggerFiltersQueryBuilder)QueryBuilder$.MODULE$.apply(this.dialect(), this.namedTemplate()).from(triggerFilters);
        if (!this.permissionEnforcer().isCurrentUserAdmin()) {
            builder.withEditableFlag(this.currentPrincipals(), this.currentRoleIds());
            v0 = builder.withPermissions(TriggerPermissions$.MODULE$.VIEW_TRIGGER_PERMISSION_SET(), this.currentPrincipals(), this.currentRoleIds());
        } else {
            v0 = BoxedUnit.UNIT;
        }
        PageableQuery pageableQuery = builder.withPageable(pageable).build();
        return pageableQuery.execute();
    }

    public List<String> findAllEditableTriggerIds() {
        TriggerListQueryBuilder<List<String>> builder = TriggerListQueryBuilder$.MODULE$.apply(this.dialect(), this.namedTemplate());
        Object object = !this.permissionEnforcer().isCurrentUserAdmin() ? builder.withPermissions(TriggerPermissions$.MODULE$.EDIT_TRIGGER_PERMISSION_SET(), this.currentPrincipals(), this.currentRoleIds()) : BoxedUnit.UNIT;
        Query<List<String>> query = builder.build();
        return (List)query.execute();
    }

    private Iterable<String> currentPrincipals() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Iterable<String> currentRoleIds() {
        return (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService().getRolesFor(Permissions.getAuthentication())).asScala().map((Function1 & Serializable)x$1 -> x$1.getId());
    }

    public TriggerManagementRepository(PermissionEnforcer permissionEnforcer, RoleService roleService, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.permissionEnforcer = permissionEnforcer;
        this.roleService = roleService;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Utils.$init$((Utils)this);
        CompressionSupport.$init$((CompressionSupport)this);
        PersistenceSupport.$init$((PersistenceSupport)this);
    }
}

