package com.xebialabs.xlrelease.triggers.api.internal

import com.codahale.metrics.annotation.Timed
import com.xebialabs.xlplatform.webhooks.domain.HttpRequestEvent
import com.xebialabs.xlrelease.triggers.api.form.EventBasedTriggerTestRunForm
import com.xebialabs.xlrelease.triggers.api.view.EventBasedTriggerTestRunResult
import com.xebialabs.xlrelease.triggers.service.EventTriggerTestRunService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import java.util.Date
import javax.ws.rs.core.MediaType
import javax.ws.rs.{Consumes, POST, Path, Produces}

@Path("/triggers")
@Consumes(Array(MediaType.APPLICATION_JSON))
@Produces(Array(MediaType.APPLICATION_JSON))
@Controller
class TriggerResource @Autowired()(eventTriggerTestRunService: EventTriggerTestRunService){

  @POST
  @Path("event-based/test-run")
  @Timed
  def testRunTrigger(form: EventBasedTriggerTestRunForm): EventBasedTriggerTestRunResult = {
    val event = new HttpRequestEvent
    event.setId("TestRunEventId")
    event.setSourceId("TestRunSourceId")
    event.setReceived(new Date())
    event.setHeaders(form.event.getHeaders)
    event.setParameters(form.event.getParameters)
    event.setContent(form.event.getContent)
    eventTriggerTestRunService.testRun(form.trigger, event)
  }

}
