package com.xebialabs.xlrelease.triggers.activity

import com.xebialabs.xlrelease.domain.ActivityCategory._
import com.xebialabs.xlrelease.domain.{ActivityCategory, ActivityLogEntry, TriggerActivity}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import com.xebialabs.xlrelease.service.{BaseActivityLogsService, ExecutionDataFindService, UserInfoResolver}
import com.xebialabs.xlrelease.views.LogsFilters
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.data.domain.Pageable
import org.springframework.stereotype.Service

import java.util.{List => JList}
import scala.collection.mutable.ListBuffer
import scala.jdk.CollectionConverters._

@Service
class TriggerActivityLogsService @Autowired()(userInfoResolver: UserInfoResolver,
                                              executionDataFindService: ExecutionDataFindService,
                                              val activityLogRepository: ActivityLogRepository
                                             ) extends BaseActivityLogsService(userInfoResolver) {
  private lazy val triggerActivityOps = TriggerActivity.values().toList.asJava

  override def withCategories(logEntry: ActivityLogEntry, filters: LogsFilters): Boolean = {
    val allowedCategories = ListBuffer.empty[ActivityCategory]
    if (filters.withTriggerEdit) allowedCategories += TRIGGER_EDIT
    if (filters.withLifecycle) allowedCategories += LIFECYCLE
    if (filters.withExecution) allowedCategories += EXECUTION
    if (filters.withOther) allowedCategories += OTHER

    val activityCategories = TriggerActivity.safeValueOf(logEntry.getActivityType).getCategories.asScala
    allowedCategories exists activityCategories
  }

  override def fetchLogs(containerId: String, logsFilters: LogsFilters, pageable: Pageable): List[ActivityLogEntry] = {
    activityLogRepository.findAllLogsOf(containerId, logsFilters, triggerActivityOps, pageable).asScala.toList
  }

  def getFilteredLogs(containerId: String, logsFilters: LogsFilters, triggerActivityOps: List[TriggerActivity], pageable: Pageable): JList[ActivityLogEntry] = {
    activityLogRepository.findAllLogsOf(containerId, logsFilters, triggerActivityOps.asJava, pageable)
  }

  // Todo make generic for activity logs
  def getTriggerActivityLogData(dataId: String): String = {
    executionDataFindService.getExecutionData(dataId)
  }
}
