package com.xebialabs.xlrelease.triggers.actors

import akka.actor.{Actor, ActorLogging, ActorRef, Props}
import com.xebialabs.xlrelease.triggers.actors.TriggerActor.TriggerAction

object TriggerProcessingActor {
  def props(triggerActorMaker: TriggerActorMaker) = Props(new TriggerProcessingActor(triggerActorMaker))

  def name = "trigger-processing-actor"
}

class TriggerProcessingActor(triggerActorMaker: TriggerActorMaker) extends Actor with ActorLogging {

  def createOrFind(triggerId: String, msg: AnyRef): ActorRef = {
    context.child(triggerId.triggerActorName).getOrElse {
      log.debug(s"TriggerProcessingActor - creating an actor tree for $triggerId (triggered by $msg)")

      triggerActorMaker(context, triggerId.triggerActorName)
    }
  }

  override def receive: Receive = {
    case msg: TriggerAction => createOrFind(msg.triggerId, msg) forward msg
  }

}
