package com.xebialabs.xlrelease.triggers.service

import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters
import com.xebialabs.xlrelease.domain.Trigger
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionContext
import com.xebialabs.xlrelease.view.ReleaseTriggerOverview
import org.springframework.data.domain.{Page, Pageable}

import java.util.{List => JList}

trait TriggerService {

  def findBy(triggerFilters: TriggerFilters, pageable: Pageable): Page[ReleaseTriggerOverview]

  def findById(triggerId: String): Trigger

  def enableTriggers(triggerIds: JList[String]): JList[String]

  def disableTriggers(triggerIds: JList[String]): JList[String]

  def enableAllAccessibleTriggers(): JList[String]

  def disableAllAccessibleTriggers(): JList[String]

  def updateTriggerStatus(triggerId: String, enabled: Boolean, checkReferencePermissions: Boolean): Unit

  def addTrigger(trigger: Trigger): Trigger

  def updateTrigger(trigger: Trigger): Trigger

  def updateVariables(trigger: Trigger): Unit

  def updateInternalState(trigger: Trigger, updateProperties: Seq[String]): Unit

  def refreshTrigger(trigger: Trigger): Unit

  def deleteTrigger(triggerId: String): Unit

  def runNowTrigger(triggerId: String): Unit

  def getFolderId(triggerId: String): String

  def execute(triggerId: String, executionContext: TriggerExecutionContext): Unit

  def executeSync(triggerId: String, executionContext: TriggerExecutionContext): Trigger

}
