package com.xebialabs.xlrelease.triggers.scheduled.quartz

import com.xebialabs.xlrelease.activity.ActivityOps
import com.xebialabs.xlrelease.domain.{ActivityCategory, TriggerActivity}
import com.xebialabs.xlrelease.repository.ActivityLogRepository
import com.xebialabs.xlrelease.service.ConfigurationService
import com.xebialabs.xlrelease.triggers.scheduled.quartz.TriggerDataPurgeJob.{DATA_PURGE_AGE_KEY, TRIGGER_DATA_ACTIVITY_TYPES}
import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

import java.time.Instant
import java.time.temporal.ChronoUnit
import java.util.Date
import scala.jdk.CollectionConverters.SeqHasAsJava

object TriggerDataPurgeJob {
  final val DATA_PURGE_AGE_KEY = "dataPurgeAge"
  final val TRIGGER_DATA_ACTIVITY_TYPES: List[ActivityOps] = TriggerActivity.values().filter(_.getCategories.contains(ActivityCategory.EXECUTION)).toList
}

@DisallowConcurrentExecution
class TriggerDataPurgeJob @Autowired()(val activityLogRepository: ActivityLogRepository, val configuration: ConfigurationService)
  extends Job with Logging {

  override def execute(context: JobExecutionContext): Unit = {
    logger.debug("Executing trigger data purge job")
    val hoursThreshold = context.getMergedJobDataMap.getInt(DATA_PURGE_AGE_KEY)
    val cutoffDate = new Date(
      Instant.now().minus(hoursThreshold.toLong, ChronoUnit.HOURS).toEpochMilli
    )

    activityLogRepository.deleteByActivityTypesAndDate(TRIGGER_DATA_ACTIVITY_TYPES.asJava, cutoffDate)
  }

}
