/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.scheduled.quartz;

import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.domain.PollType;
import com.xebialabs.xlrelease.domain.ScheduledTrigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.triggers.scheduled.ScheduledJobService;
import com.xebialabs.xlrelease.triggers.scheduled.quartz.QuartzScheduledJobService$;
import com.xebialabs.xlrelease.triggers.scheduled.quartz.TriggerQuartzJob;
import com.xebialabs.xlrelease.utils.QuartzUtils;
import com.xebialabs.xlrelease.utils.QuartzUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Marker;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.retry.support.RetryTemplateBuilder;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\t\u0012\u0001yA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\u0006s\u0001!\tA\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u0019Q\u0005\u0001)A\u0005\u0001\")1\n\u0001C!\u0019\")\u0001\f\u0001C!3\")1\f\u0001C\u00059\u001e)a.\u0005E\u0001_\u001a)\u0001#\u0005E\u0001a\")\u0011(\u0003C\u0001c\u001a!!/C\u0001t\u0011!!8B!A!\u0002\u0013\u0011\u0006\"B\u001d\f\t\u0003)\b\"B=\f\t\u0003Q\b\"CA\u0007\u0013\u0005\u0005I1AA\b\u0005e\tV/\u0019:uuN\u001b\u0007.\u001a3vY\u0016$'j\u001c2TKJ4\u0018nY3\u000b\u0005I\u0019\u0012AB9vCJ$(P\u0003\u0002\u0015+\u0005I1o\u00195fIVdW\r\u001a\u0006\u0003-]\t\u0001\u0002\u001e:jO\u001e,'o\u001d\u0006\u00031e\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005iY\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005a\u0012aA2p[\u000e\u00011\u0003\u0002\u0001 K%\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014(\u001b\u0005\u0019\u0012B\u0001\u0015\u0014\u0005M\u00196\r[3ek2,GMS8c'\u0016\u0014h/[2f!\tQs&D\u0001,\u0015\taS&A\u0003tY\u001a$$NC\u0001/\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0019,\u0005\u001daunZ4j]\u001e\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005M:T\"\u0001\u001b\u000b\u0005I)$\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029i\tI1k\u00195fIVdWM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005mj\u0004C\u0001\u001f\u0001\u001b\u0005\t\u0002\"B\u0019\u0003\u0001\u0004\u0011\u0014!\u0004:fiJLH+Z7qY\u0006$X-F\u0001A!\t\t\u0005*D\u0001C\u0015\t\u0019E)A\u0004tkB\u0004xN\u001d;\u000b\u0005\u00153\u0015!\u0002:fiJL(BA$6\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017BA%C\u00055\u0011V\r\u001e:z)\u0016l\u0007\u000f\\1uK\u0006q!/\u001a;ssR+W\u000e\u001d7bi\u0016\u0004\u0013\u0001C:dQ\u0016$W\u000f\\3\u0015\u00055\u0003\u0006C\u0001\u0011O\u0013\ty\u0015E\u0001\u0003V]&$\b\"B)\u0006\u0001\u0004\u0011\u0016\u0001E:dQ\u0016$W\u000f\\3e)JLwmZ3s!\t\u0019f+D\u0001U\u0015\t)v#\u0001\u0004e_6\f\u0017N\\\u0005\u0003/R\u0013\u0001cU2iK\u0012,H.\u001a3Ue&<w-\u001a:\u0002\u0015Ut7o\u00195fIVdW\r\u0006\u0002N5\")\u0011K\u0002a\u0001%\u0006yAO]5hO\u0016\u00148k\u00195fIVdW\r\u0006\u0002^YB\u0012al\u0019\t\u0004g}\u000b\u0017B\u000115\u0005=\u00196\r[3ek2,')^5mI\u0016\u0014\bC\u00012d\u0019\u0001!\u0011\u0002Z\u0004\u0002\u0002\u0003\u0005)\u0011A3\u0003\u0007}#\u0013'\u0005\u0002gSB\u0011\u0001eZ\u0005\u0003Q\u0006\u0012qAT8uQ&tw\r\u0005\u00024U&\u00111\u000e\u000e\u0002\b)JLwmZ3s\u0011\u0015iw\u00011\u0001S\u00039\u0011X\r\\3bg\u0016$&/[4hKJ\f\u0011$U;beRT8k\u00195fIVdW\r\u001a&pEN+'O^5dKB\u0011A(C\n\u0003\u0013}!\u0012a\u001c\u0002\u0011)JLwmZ3s\u000bb$XM\\:j_:\u001c\"aC\u0010\u0002\u000fQ\u0014\u0018nZ4feR\u0011a\u000f\u001f\t\u0003o.i\u0011!\u0003\u0005\u0006i6\u0001\rAU\u0001\r]>\u0014X.\u00197ju\u0016$\u0017\nZ\u000b\u0002wB\u0019A0a\u0002\u000f\u0007u\f\u0019\u0001\u0005\u0002\u007fC5\tqPC\u0002\u0002\u0002u\ta\u0001\u0010:p_Rt\u0014bAA\u0003C\u00051\u0001K]3eK\u001aLA!!\u0003\u0002\f\t11\u000b\u001e:j]\u001eT1!!\u0002\"\u0003A!&/[4hKJ,\u0005\u0010^3og&|g\u000eF\u0002w\u0003#AQ\u0001^\bA\u0002I\u0003")
public class QuartzScheduledJobService
implements ScheduledJobService,
Logging {
    private final Scheduler scheduler;
    private final RetryTemplate retryTemplate;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static TriggerExtension TriggerExtension(ScheduledTrigger trigger) {
        return QuartzScheduledJobService$.MODULE$.TriggerExtension(trigger);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        QuartzScheduledJobService quartzScheduledJobService = this;
        synchronized (quartzScheduledJobService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public RetryTemplate retryTemplate() {
        return this.retryTemplate;
    }

    @Override
    public void schedule(ScheduledTrigger scheduledTrigger) {
        this.logger().debug((Function0 & Serializable)() -> "Schedule trigger " + QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId());
        String triggerType = scheduledTrigger.getType().toString();
        Class<TriggerQuartzJob> jobClass = TriggerQuartzJob.class;
        JobDetail job = JobBuilder.newJob(jobClass).withDescription("Trigger '" + QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId() + "'").withIdentity(QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId(), triggerType).build();
        Trigger quartzTrigger = TriggerBuilder.newTrigger().withIdentity(QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId(), triggerType).withDescription("Trigger '" + QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId() + "'").withSchedule(this.triggerSchedule(scheduledTrigger)).startNow().build();
        if (this.scheduler.checkExists(quartzTrigger.getKey())) {
            this.scheduler.rescheduleJob(quartzTrigger.getKey(), quartzTrigger);
            return;
        }
        this.scheduler.scheduleJob(job, CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Trigger[]{quartzTrigger}))).asJava(), true);
    }

    @Override
    public void unschedule(ScheduledTrigger scheduledTrigger) {
        this.logger().debug((Function0 & Serializable)() -> "Unschedule trigger " + QuartzScheduledJobService$.MODULE$.TriggerExtension(scheduledTrigger).normalizedId());
        JobKey jobKey = new JobKey(scheduledTrigger.getName(), scheduledTrigger.getType().toString());
        RetryCallback retryCallback = x$1 -> BoxesRunTime.boxToBoolean((boolean)this.scheduler.deleteJob(jobKey));
        this.retryTemplate().execute(retryCallback);
    }

    private ScheduleBuilder<? extends Trigger> triggerSchedule(ScheduledTrigger releaseTrigger) {
        SimpleScheduleBuilder simpleScheduleBuilder;
        PollType pollType = releaseTrigger.getPollType();
        if (PollType.REPEAT.equals(pollType)) {
            simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(releaseTrigger.getPeriodicity()))).withMisfireHandlingInstructionNextWithRemainingCount().repeatForever();
        } else if (PollType.CRON.equals(pollType)) {
            String timezoneName = XlrConfig$.MODULE$.getInstance().quartz().timezone();
            TimeZone timezone = timezoneName.isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(timezoneName);
            simpleScheduleBuilder = CronScheduleBuilder.cronSchedule((String)QuartzUtils.QuartzCron$.MODULE$.asQuartzCron$extension(QuartzUtils$.MODULE$.QuartzCron(releaseTrigger.getPeriodicity()))).inTimeZone(timezone).withMisfireHandlingInstructionDoNothing();
        } else {
            throw new MatchError((Object)pollType);
        }
        SimpleScheduleBuilder scheduleBuilder = simpleScheduleBuilder;
        return scheduleBuilder;
    }

    public QuartzScheduledJobService(Scheduler scheduler) {
        this.scheduler = scheduler;
        Logging.$init$((Logging)this);
        this.retryTemplate = new RetryTemplateBuilder().fixedBackoff(250L).maxAttempts(8).build();
    }

    public static class TriggerExtension {
        private final ScheduledTrigger trigger;

        public String normalizedId() {
            return Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(this.trigger.getId())));
        }

        public TriggerExtension(ScheduledTrigger trigger) {
            this.trigger = trigger;
        }
    }
}

