import { call, put } from 'redux-saga/effects';
import getAngularService from '../../../../../../../../core/xlr-ui/app/features/common/services/angular-accessor';
import { getFolderOrWaitForIt } from '../../../../../../../../core/xlr-ui/app/features/folders/ducks/folders.saga';
import { SagaIterator } from 'redux-saga';
import { TriggerSidebarProvider } from './trigger-sidebar-provider';
import { navigation } from '../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';

const { setSidebarMenu, setBackItem, setIsInTemplateOrRelease } = navigation.actions;

describe('TriggerSidebarProvider', () => {
    const triggerSidebarProvider = new TriggerSidebarProvider();
    const path = '/trigger-management/Trigger123/logs';

    describe('isSupported', () => {
        it('should be true for trigger page', () => {
            expect(triggerSidebarProvider.isSupported('/trigger-management/Trigger123')).toBe(true);
        });
    });

    describe('provide', () => {
        it('should set the menu and back item when trigger is in a folder', () => {
            const folder = { id: 'Applications/Folder1' };
            const params = { folderId: 'Applications/Folder1' };
            const $location = {
                search: () => params,
            };
            const gen: SagaIterator = triggerSidebarProvider.provide(path);
            expect(gen.next().value).toStrictEqual(call(getAngularService, '$location'));
            expect(gen.next($location).value).toStrictEqual(put(setIsInTemplateOrRelease(true)));
            expect(gen.next().value).toStrictEqual(call(triggerSidebarProvider.getPath, path, '', params));
            expect(gen.next('trigger-management/Trigger123').value).toStrictEqual(call(triggerSidebarProvider.getPath, path, '/logs', params));
            expect(gen.next('trigger-management/Trigger123/logs').value).toStrictEqual(
                put(
                    setSidebarMenu([
                        {
                            pathSuffix: 'trigger-management/Trigger123',
                            selected: false,
                            startIconId: 'configuration-preferences',
                            text: 'Properties',
                        },
                        {
                            pathSuffix: 'trigger-management/Trigger123/logs',
                            selected: true,
                            startIconId: 'progress',
                            text: 'Activity Logs',
                        },
                    ]),
                ),
            );
            expect(gen.next().value).toStrictEqual(call(getFolderOrWaitForIt));
            expect(gen.next(folder).value).toStrictEqual(
                put(
                    setBackItem({
                        pathSuffix: `folders/Applications/Folder1/triggers`,
                        title: 'triggers',
                        text: 'Triggers',
                    }),
                ),
            );
            expect(gen.next().done).toStrictEqual(true);
        });

        it('should set the menu and back item when trigger is in root template', () => {
            const params = { folderId: 'Applications' };
            const $location = {
                search: () => params,
            };
            const gen: SagaIterator = triggerSidebarProvider.provide(path);
            expect(gen.next().value).toStrictEqual(call(getAngularService, '$location'));
            expect(gen.next($location).value).toStrictEqual(put(setIsInTemplateOrRelease(true)));
            expect(gen.next().value).toStrictEqual(call(triggerSidebarProvider.getPath, path, '', params));
            expect(gen.next('trigger-management/Trigger123').value).toStrictEqual(call(triggerSidebarProvider.getPath, path, '/logs', params));
            expect(gen.next('trigger-management/Trigger123/logs').value).toStrictEqual(
                put(
                    setSidebarMenu([
                        {
                            pathSuffix: 'trigger-management/Trigger123',
                            selected: false,
                            startIconId: 'configuration-preferences',
                            text: 'Properties',
                        },
                        {
                            pathSuffix: 'trigger-management/Trigger123/logs',
                            selected: true,
                            startIconId: 'progress',
                            text: 'Activity Logs',
                        },
                    ]),
                ),
            );
            expect(gen.next().value).toStrictEqual(
                put(
                    setBackItem({
                        pathSuffix: `templates`,
                        title: 'templates',
                        text: 'Templates',
                    }),
                ),
            );
            expect(gen.next().done).toStrictEqual(true);
        });
    });

    describe('getPath', () => {
        describe('with folder', () => {
            const params = { folderId: 'Applications/Folder1' };
            it('should return proper path format for properties page', () => {
                const fixedPath = triggerSidebarProvider.getPath(path, '', params);
                expect(fixedPath).toBe('trigger-management/Trigger123?folderId=Applications/Folder1');
            });

            it('should return proper path format for logs page', () => {
                const fixedPath = triggerSidebarProvider.getPath(path, '/logs', params);
                expect(fixedPath).toBe('trigger-management/Trigger123/logs?folderId=Applications/Folder1');
            });
        });

        it('should return proper path format when no folder', () => {
            const fixedPath = triggerSidebarProvider.getPath(path, '/logs', {});
            expect(fixedPath).toBe('trigger-management/Trigger123/logs');
        });
    });
});
