package com.xebialabs.xlrelease.triggers.security

import com.xebialabs.deployit.security.permission.Permission
import com.xebialabs.xlrelease.domain.Trigger
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.triggers.security.TriggerPermissions._
import com.xebialabs.xlrelease.triggers.service.TriggerService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.{List => JList}

@Component
class TriggerPermissionChecker @Autowired()(permissions: PermissionChecker, triggerService: TriggerService) {

  def checkViewTrigger(triggerId: String): Unit = {
    val trigger = triggerService.findById(triggerId)
    checkViewTrigger(trigger)
  }

  def checkViewTrigger(trigger: Trigger): Unit = {
    checkViewTriggerOnContainer(trigger.getContainerId)
  }

  def checkEditTrigger(triggerId: String): Unit = {
    val trigger = triggerService.findById(triggerId)
    checkEditTrigger(trigger)
  }

  def checkEditTrigger(trigger: Trigger): Unit = {
    checkEditTriggerOnContainer(trigger.getContainerId)
  }

  def filterEditableTriggers(triggerIds: JList[String]): JList[String] = permissions.filterSilently(triggerIds, (triggerId: String) => {
    checkEditTrigger(triggerId)
  })

  private def checkViewTriggerOnContainer(containerId: String): Unit = {
    checkPermissionOnContainer(containerId, VIEW_TRIGGER_PERMISSION_SET: _*)
  }

  private def checkEditTriggerOnContainer(containerId: String): Unit = {
    checkPermissionOnContainer(containerId, EDIT_TRIGGER_PERMISSION_SET: _*)
  }

  private def checkPermissionOnContainer(containerId: String, permissionsToVerify: Permission*): Unit = {
    permissions.checkAny(containerId, permissionsToVerify: _*)
  }
}
