/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.scheduled.validators;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlrelease.domain.PollType;
import com.xebialabs.xlrelease.domain.ScheduledTrigger;
import com.xebialabs.xlrelease.utils.QuartzUtils;
import com.xebialabs.xlrelease.utils.QuartzUtils$;
import org.quartz.CronExpression;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005}2Aa\u0001\u0003\u0001#!)A\u0006\u0001C\u0001[!)\u0001\u0007\u0001C!c\tI2k\u00195fIVdW\r\u001a+sS\u001e<WM\u001d,bY&$\u0017\r^8s\u0015\t)a!\u0001\u0006wC2LG-\u0019;peNT!a\u0002\u0005\u0002\u0013M\u001c\u0007.\u001a3vY\u0016$'BA\u0005\u000b\u0003!!(/[4hKJ\u001c(BA\u0006\r\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u000e\u001d\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u001f\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0005\u000e\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001\u00027b]\u001eT\u0011aF\u0001\u0005U\u00064\u0018-\u0003\u0002\u001a)\t1qJ\u00196fGR\u00042a\u0007\u0013'\u001b\u0005a\"BA\u000f\u001f\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003?\u0001\n1!\u00199j\u0015\t\t#%\u0001\u0004qYV<\u0017N\u001c\u0006\u0003G1\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003Kq\u0011\u0011BV1mS\u0012\fGo\u001c:\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%R\u0011A\u00023p[\u0006Lg.\u0003\u0002,Q\t\u00012k\u00195fIVdW\r\u001a+sS\u001e<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0002\"a\f\u0001\u000e\u0003\u0011\t\u0001B^1mS\u0012\fG/\u001a\u000b\u0004eaR\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$\u0001B+oSRDQ!\u000f\u0002A\u0002\u0019\nq\u0001\u001e:jO\u001e,'\u000fC\u0003<\u0005\u0001\u0007A(A\u0004d_:$X\r\u001f;\u0011\u0005mi\u0014B\u0001 \u001d\u0005E1\u0016\r\\5eCRLwN\\\"p]R,\u0007\u0010\u001e")
public class ScheduledTriggerValidator
implements Validator<ScheduledTrigger> {
    public void validate(ScheduledTrigger trigger, ValidationContext context) {
        ExtendedValidationContext extendedContext = (ExtendedValidationContext)context;
        PollType pollType = trigger.getPollType();
        if (PollType.REPEAT.equals(pollType)) {
            BoxedUnit boxedUnit;
            String errorMsg = new StringBuilder(32).append("Trigger has wrong periodicity '").append(trigger.getPeriodicity()).append("'").toString();
            try {
                int period = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(trigger.getPeriodicity()));
                if (period <= 0) {
                    extendedContext.error((ConfigurationItem)trigger, "periodicity", errorMsg, new Object[0]);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Exception e) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", String.valueOf(errorMsg), new Object[0]);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        if (PollType.CRON.equals(pollType)) {
            BoxedUnit boxedUnit;
            String cron = trigger.getPeriodicity();
            String errorMsg = new StringBuilder(36).append("Trigger has wrong cron expression '").append(cron).append("'").toString();
            try {
                if (!CronExpression.isValidExpression((String)QuartzUtils.QuartzCron$.MODULE$.asQuartzCron$extension(QuartzUtils$.MODULE$.QuartzCron(cron)))) {
                    extendedContext.error((ConfigurationItem)trigger, "periodicity", errorMsg, new Object[0]);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Exception e) {
                extendedContext.error((ConfigurationItem)trigger, "periodicity", String.valueOf(errorMsg), new Object[0]);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)pollType);
    }
}

