/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.actors;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.triggers.action.TriggerActionExecuted;
import com.xebialabs.xlrelease.triggers.action.TriggerActionResult;
import com.xebialabs.xlrelease.triggers.action.TriggerActionSkipped;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDisabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerEnabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerExecutedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerFailedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerSkippedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatingActionEvent;
import com.xebialabs.xlrelease.triggers.package$;
import com.xebialabs.xlrelease.triggers.scheduled.ScheduledTriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionResult;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerLifecycle;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005ef\u0001B\n\u0015\u0001}A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\"B+\u0001\t\u00031\u0006\"\u00020\u0001\t\u0003y\u0006\"B7\u0001\t\u0003q\u0007\"B9\u0001\t\u0003\u0011\b\"CA\u0018\u0001E\u0005I\u0011AA\u0019\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002f\u0001!I!a\u001a\t\u0013\u00055\u0004!%A\u0005\n\u0005=\u0004bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003s\u0002A\u0011BA>\u0011\u001d\tI\b\u0001C\u0005\u0003WCq!a-\u0001\t\u0013\t)LA\tUe&<w-\u001a:Pa\u0016\u0014\u0018\r^5p]NT!!\u0006\f\u0002\r\u0005\u001cGo\u001c:t\u0015\t9\u0002$\u0001\u0005ue&<w-\u001a:t\u0015\tI\"$A\u0005yYJ,G.Z1tK*\u00111\u0004H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!H\u0001\u0004G>l7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005)1\u000f\u001c45U*\t1&\u0001\u0005he&T(\u0010\\3e\u0013\ti\u0003FA\u0004M_\u001e<\u0017N\\4\u0002#Q\u0014\u0018nZ4feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00021g5\t\u0011G\u0003\u000231\u0005Q!/\u001a9pg&$xN]=\n\u0005Q\n$!\u0005+sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ss\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005A:\u0014B\u0001\u001d2\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u00111HP\u0007\u0002y)\u0011Q\bG\u0001\u0007KZ,g\u000e^:\n\u0005}b$!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\u0001BO]5hO\u0016\u0014H*\u001b4fGf\u001cG.\u001a\t\u0004\u0005\u001eKU\"A\"\u000b\u0005\u0011+\u0015\u0001B5na2T!A\u0012\f\u0002\u000fM,'O^5dK&\u0011\u0001j\u0011\u0002\u0011)JLwmZ3s\u0019&4WmY=dY\u0016\u0004\"AS'\u000e\u0003-S!\u0001\u0014\r\u0002\r\u0011|W.Y5o\u0013\tq5JA\u0004Ue&<w-\u001a:\u00029\r|gNZ5hkJ\fG/[8o-\u0006\u0014\u0018.\u00192mKN+'O^5dKB\u0011\u0011kU\u0007\u0002%*\u0011a\tG\u0005\u0003)J\u0013AdQ8oM&<WO]1uS>tg+\u0019:jC\ndWmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0007/fS6\fX/\u0011\u0005a\u0003Q\"\u0001\u000b\t\u000b92\u0001\u0019A\u0018\t\u000bU2\u0001\u0019\u0001\u001c\t\u000be2\u0001\u0019\u0001\u001e\t\u000b\u00013\u0001\u0019A!\t\u000b=3\u0001\u0019\u0001)\u0002\t\u0019Lg\u000e\u001a\u000b\u0003\u0013\u0002DQ!Y\u0004A\u0002\t\f\u0011\u0002\u001e:jO\u001e,'/\u00133\u0011\u0005\rTgB\u00013i!\t)'%D\u0001g\u0015\t9g$\u0001\u0004=e>|GOP\u0005\u0003S\n\na\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011NI\u0001\u000bC\u0012$GK]5hO\u0016\u0014HCA%p\u0011\u0015\u0001\b\u00021\u0001J\u0003\u001d!(/[4hKJ\fQ\"\u001e9eCR,GK]5hO\u0016\u0014H#C%tkZ\\Xp`A\u0002\u0011\u0015!\u0018\u00021\u0001J\u0003!y'/[4j]\u0006d\u0007\"\u00029\n\u0001\u0004I\u0005\"B<\n\u0001\u0004A\u0018\u0001\u0003<bY&$\u0017\r^3\u0011\u0005\u0005J\u0018B\u0001>#\u0005\u001d\u0011un\u001c7fC:DQ\u0001`\u0005A\u0002a\f!\"Z7ji\u00163XM\u001c;t\u0011\u0015q\u0018\u00021\u0001y\u0003!Ig\u000e^3s]\u0006d\u0007BBA\u0001\u0013\u0001\u0007\u00010A\rdQ\u0016\u001c7NU3gKJ,gnY3QKJl\u0017n]:j_:\u001c\b\"CA\u0003\u0013A\u0005\t\u0019AA\u0004\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0006\u0003\u0013\t\u0019B\u0019\b\u0005\u0003\u0017\tyAD\u0002f\u0003\u001bI\u0011aI\u0005\u0004\u0003#\u0011\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003+\t9BA\u0002TKFT1!!\u0005#Q\rI\u00111\u0004\t\u0005\u0003;\tY#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003K\t9#A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005%B$\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\ti#a\b\u0003\u000bQKW.\u001a3\u0002/U\u0004H-\u0019;f)JLwmZ3sI\u0011,g-Y;mi\u0012:TCAA\u001aU\u0011\t9!!\u000e,\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0003j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\t#\u0013\u0011\t\u0019%a\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007eK2,G/\u001a+sS\u001e<WM\u001d\u000b\u0005\u0003\u0013\ny\u0005E\u0002\"\u0003\u0017J1!!\u0014#\u0005\u0011)f.\u001b;\t\u000bA\\\u0001\u0019A%)\u0007-\tY\"A\u0004fq\u0016\u001cW\u000f^3\u0015\u000b%\u000b9&!\u0017\t\u000bAd\u0001\u0019A%\t\u000f\u0005mC\u00021\u0001\u0002^\u0005\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0004\u0005\u0006}\u0013bAA1\u0007\n9BK]5hO\u0016\u0014X\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0015\u0004\u0019\u0005m\u0011!D3oC\ndW\r\u0016:jO\u001e,'\u000f\u0006\u0004\u0002J\u0005%\u00141\u000e\u0005\u0006a6\u0001\r!\u0013\u0005\by6\u0001\n\u00111\u0001y\u0003])g.\u00192mKR\u0013\u0018nZ4fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002r)\u001a\u00010!\u000e\u0002!Y\fG.\u001b3bi\u00164u\u000e\u001c3fe&#G\u0003BA%\u0003oBQ\u0001]\bA\u0002%\u000bqb\u00195fG.4\u0016\r\\5eCRLwN\u001c\u000b\u0007\u0003\u0013\ni(a \t\u000bA\u0004\u0002\u0019A%\t\u000f\u0005\u0005\u0005\u00031\u0001\u0002\u0004\u0006!Qn]4t!\u0019\t))a$\u0002\u00146\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bY)\u0001\u0003vi&d'BAAG\u0003\u0011Q\u0017M^1\n\t\u0005E\u0015q\u0011\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0016\u0006\u001dVBAAL\u0015\u0011\tI*a'\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0003\u0002\u001e\u0006}\u0015aA1qS*!\u0011\u0011UAR\u0003\u0019\u0001H.^4j]*\u0019\u0011Q\u0015\u000e\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!+\u0002\u0018\n\tb+\u00197jI\u0006$\u0018n\u001c8NKN\u001c\u0018mZ3\u0015\r\u0005%\u0013QVAY\u0011\u0019\ty+\u0005a\u0001\u0013\u0006\u00111-\u001b\u0005\u0007\u0003\u0003\t\u0002\u0019\u0001=\u0002\u001fU\u0004H-\u0019;f-\u0006\u0014\u0018.\u00192mKN$B!!\u0013\u00028\")\u0001O\u0005a\u0001\u0013\u0002")
public class TriggerOperations
implements Logging {
    private final TriggerRepository triggerRepository;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private final ConfigurationVariableService configurationVariableService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerOperations triggerOperations = this;
        synchronized (triggerOperations) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Trigger find(String triggerId) {
        return this.triggerRepository.find(triggerId);
    }

    public Trigger addTrigger(Trigger trigger) {
        this.validateFolderId(trigger);
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)None$.MODULE$, (ConfigurationItem)trigger);
        this.checkValidation(trigger, true);
        this.updateVariables(trigger);
        CiHelper.fixUpInternalReferences((ConfigurationItem)trigger);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerCreatingActionEvent(trigger));
        Trigger addedTrigger = this.triggerRepository.create(trigger);
        this.eventBus.publish((XLReleaseEvent)new TriggerCreatedEvent(addedTrigger));
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        return addedTrigger;
    }

    @Timed
    public Trigger updateTrigger(Trigger original, Trigger trigger, boolean validate2, boolean emitEvents, boolean internal, boolean checkReferencePermissions, scala.collection.immutable.Seq<String> properties) {
        Trigger updated;
        block5: {
            Trigger trigger2;
            this.trace((Function0<Object>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(69).append("Updating trigger ").append(original).append(" properties: '").append(properties.mkString(",")).append("'\n         |previous: ").append(package$.MODULE$.TriggerExtensions(original).toJson()).append("\n         |new: ").append(package$.MODULE$.TriggerExtensions(trigger).toJson()).toString())));
            if (properties.isEmpty()) {
                CollectionConverters$.MODULE$.ListHasAsScala(trigger.getInternalProperties()).asScala().foreach((Function1 & Serializable)internalProperty -> {
                    trigger.setProperty(internalProperty, original.getProperty(internalProperty));
                    return BoxedUnit.UNIT;
                });
                trigger2 = trigger;
            } else {
                trigger2 = (Trigger)CiCloneHelper.cloneCi((ConfigurationItem)original);
            }
            Trigger toUpdate = trigger2;
            toUpdate.setCiUid(original.getCiUid());
            toUpdate.setFolderId(new FolderId(trigger.getFolderId()).absolute());
            toUpdate.setId(Ids.formatWithFolderId((String)trigger.getFolderId(), (String)Ids.getName((String)trigger.getId())));
            CiHelper.fixUpInternalReferences((ConfigurationItem)toUpdate);
            if (!new FolderId(original.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
                this.validateFolderId(toUpdate);
            }
            properties.foreach((Function1 & Serializable)propertyToUpdate -> {
                toUpdate.setProperty(propertyToUpdate, trigger.getProperty(propertyToUpdate));
                return BoxedUnit.UNIT;
            });
            if (validate2) {
                PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)new Some((Object)original), (ConfigurationItem)toUpdate);
                this.checkValidation(toUpdate, checkReferencePermissions);
                this.updateVariables(toUpdate);
                this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerUpdatingActionEvent(original, toUpdate));
            }
            updated = this.triggerRepository.update(toUpdate);
            if (!internal) {
                boolean emitStateEvent = emitEvents && (!Objects.equal((Object)BoxesRunTime.boxToBoolean((boolean)original.isEnabled()), (Object)BoxesRunTime.boxToBoolean((boolean)updated.isEnabled())) || properties.contains((Object)"enabled"));
                this.enableTrigger(updated, emitStateEvent);
            }
            if (!emitEvents) break block5;
            this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedEvent(original, updated));
        }
        return updated;
    }

    public scala.collection.immutable.Seq<String> updateTrigger$default$7() {
        return (scala.collection.immutable.Seq)Nil$.MODULE$;
    }

    @Timed
    public void deleteTrigger(Trigger trigger) {
        trigger.setEnabled(false);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerDeletingActionEvent(trigger));
        this.triggerRepository.delete(trigger.getId());
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        this.eventBus.publish((XLReleaseEvent)new TriggerDeletedEvent(trigger));
    }

    @Timed
    public Trigger execute(Trigger trigger, TriggerExecutionContext executionContext) {
        Try result;
        Trigger x$1 = trigger;
        GlobalVariables x$2 = this.configurationVariableService.resolveFromCi$default$2();
        Function1 x$3 = this.configurationVariableService.resolveFromCi$default$3((ConfigurationItem)x$1, x$2);
        this.configurationVariableService.resolveFromCi((ConfigurationItem)x$1, x$2, x$3);
        TriggerExecutionResult<Trigger> triggerExecutionResult = this.triggerLifecycle.execute(trigger, executionContext);
        if (triggerExecutionResult == null) {
            throw new MatchError(triggerExecutionResult);
        }
        Trigger maybeExecutedTrigger = triggerExecutionResult.trigger();
        Try<TriggerActionResult> result2 = triggerExecutionResult.results();
        Tuple2 tuple2 = new Tuple2((Object)maybeExecutedTrigger, result2);
        Trigger maybeExecutedTrigger2 = (Trigger)tuple2._1();
        Try try_ = result = (Try)tuple2._2();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.eventBus.publish((XLReleaseEvent)new TriggerFailedEvent(trigger, e.getMessage(), executionContext.getExecutionDataId()));
            throw e;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            TriggerActionResult actionResult = (TriggerActionResult)success.value();
            TriggerActionResult triggerActionResult = actionResult;
            if (triggerActionResult instanceof TriggerActionExecuted) {
                TriggerActionExecuted triggerActionExecuted = (TriggerActionExecuted)triggerActionResult;
                String result3 = triggerActionExecuted.result();
                this.eventBus.publish((XLReleaseEvent)new TriggerExecutedEvent(maybeExecutedTrigger2, result3, executionContext.getExecutionDataId()));
            } else if (triggerActionResult instanceof TriggerActionSkipped) {
                TriggerActionSkipped triggerActionSkipped = (TriggerActionSkipped)triggerActionResult;
                String message = triggerActionSkipped.message();
                if (!(executionContext instanceof ScheduledTriggerExecutionContext)) {
                    this.eventBus.publish((XLReleaseEvent)new TriggerSkippedEvent(maybeExecutedTrigger2, message, executionContext.getExecutionDataId()));
                }
            }
            return maybeExecutedTrigger2;
        }
        throw new MatchError((Object)try_);
    }

    private void enableTrigger(Trigger trigger, boolean emitEvents) {
        if (trigger.isEnabled()) {
            this.triggerLifecycle.enable(trigger, true);
            if (emitEvents) {
                this.eventBus.publish((XLReleaseEvent)new TriggerEnabledEvent(trigger));
                return;
            }
            return;
        }
        this.triggerLifecycle.disable(trigger);
        if (emitEvents) {
            this.eventBus.publish((XLReleaseEvent)new TriggerDisabledEvent(trigger));
            return;
        }
    }

    private boolean enableTrigger$default$2() {
        return true;
    }

    private void validateFolderId(Trigger trigger) {
        if (new FolderId(trigger.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
            trigger.get$validationMessages().add(new ValidationMessage(trigger.getId(), "folderId", "You cannot create trigger on the root folder. The root folder path is not supported."));
            return;
        }
    }

    private void checkValidation(Trigger trigger, List<ValidationMessage> msgs) {
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(msgs).asScala().nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)trigger.get$validationMessages().addAll(msgs)) : BoxedUnit.UNIT;
        if (CollectionConverters$.MODULE$.ListHasAsScala(trigger.get$validationMessages()).asScala().nonEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)trigger);
        }
    }

    private void checkValidation(Trigger ci, boolean checkReferencePermissions) {
        this.checkValidation(ci, this.triggerLifecycle.validate(ci, checkReferencePermissions));
    }

    private void updateVariables(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            List variables = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.findById(releaseTrigger.getTemplate(), ResolveOptions$.MODULE$.WITH_DECORATORS()).getVariables()).asScala().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$1(releaseTrigger, v)))).toList()).asJava();
            Release variableHolderTemplate = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate()).withVariables(variables).build();
            variableHolderTemplate.setVariableValues(CollectionConverters$.MODULE$.MutableMapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(releaseTrigger.getTemplateVariableValues(x$2 -> !x$2.isPassword())).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$3(x$3)))).asJava());
            variableHolderTemplate.setPasswordVariableValues(releaseTrigger.getTemplatePasswordVariables());
            releaseTrigger.setVariables(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variableHolderTemplate.getVariables()).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$4(x$4)))).toList()).asJava());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$1(ReleaseTrigger x2$1, Variable v) {
        return x2$1.getVariablesByKeys().containsKey(v.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 x$3) {
        return x$3._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Variable x$4) {
        return x$4.getId() != null;
    }

    public TriggerOperations(TriggerRepository triggerRepository, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, TriggerLifecycle<Trigger> triggerLifecycle, ConfigurationVariableService configurationVariableService) {
        this.triggerRepository = triggerRepository;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.triggerLifecycle = triggerLifecycle;
        this.configurationVariableService = configurationVariableService;
        Logging.$init$((Logging)this);
    }
}

