/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.actors;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.ConfigurationVariableService;
import com.xebialabs.xlrelease.triggers.action.TriggerActionExecuted;
import com.xebialabs.xlrelease.triggers.action.TriggerActionResult;
import com.xebialabs.xlrelease.triggers.action.TriggerActionSkipped;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDeletingActionEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerDisabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerEnabledEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerExecutedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerFailedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerSkippedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatedEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatingActionEvent;
import com.xebialabs.xlrelease.triggers.package$;
import com.xebialabs.xlrelease.triggers.scheduled.ScheduledTriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerExecutionContext;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerLifecycle;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\n\u0015\u0001}A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\"B+\u0001\t\u00031\u0006\"\u00020\u0001\t\u0003y\u0006\"B7\u0001\t\u0003q\u0007\"B9\u0001\t\u0003\u0011\b\"CA\u0016\u0001E\u0005I\u0011AA\u0017\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007Bq!a\u0014\u0001\t\u0003\t\t\u0006C\u0004\u0002b\u0001!I!a\u0019\t\u0013\u0005%\u0004!%A\u0005\n\u0005-\u0004bBA8\u0001\u0011%\u0011\u0011\u000f\u0005\b\u0003k\u0002A\u0011BA<\u0011\u001d\t)\b\u0001C\u0005\u0003OCq!!,\u0001\t\u0013\tyKA\tUe&<w-\u001a:Pa\u0016\u0014\u0018\r^5p]NT!!\u0006\f\u0002\r\u0005\u001cGo\u001c:t\u0015\t9\u0002$\u0001\u0005ue&<w-\u001a:t\u0015\tI\"$A\u0005yYJ,G.Z1tK*\u00111\u0004H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!H\u0001\u0004G>l7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005)1\u000f\u001c45U*\t1&\u0001\u0005he&T(\u0010\\3e\u0013\ti\u0003FA\u0004M_\u001e<\u0017N\\4\u0002#Q\u0014\u0018nZ4feJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00021g5\t\u0011G\u0003\u000231\u0005Q!/\u001a9pg&$xN]=\n\u0005Q\n$!\u0005+sS\u001e<WM\u001d*fa>\u001c\u0018\u000e^8ss\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005A:\u0014B\u0001\u001d2\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u00111HP\u0007\u0002y)\u0011Q\bG\u0001\u0007KZ,g\u000e^:\n\u0005}b$!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\u0001BO]5hO\u0016\u0014H*\u001b4fGf\u001cG.\u001a\t\u0004\u0005\u001eKU\"A\"\u000b\u0005\u0011+\u0015\u0001B5na2T!A\u0012\f\u0002\u000fM,'O^5dK&\u0011\u0001j\u0011\u0002\u0011)JLwmZ3s\u0019&4WmY=dY\u0016\u0004\"AS'\u000e\u0003-S!\u0001\u0014\r\u0002\r\u0011|W.Y5o\u0013\tq5JA\u0004Ue&<w-\u001a:\u00029\r|gNZ5hkJ\fG/[8o-\u0006\u0014\u0018.\u00192mKN+'O^5dKB\u0011\u0011kU\u0007\u0002%*\u0011a\tG\u0005\u0003)J\u0013AdQ8oM&<WO]1uS>tg+\u0019:jC\ndWmU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0007/fS6\fX/\u0011\u0005a\u0003Q\"\u0001\u000b\t\u000b92\u0001\u0019A\u0018\t\u000bU2\u0001\u0019\u0001\u001c\t\u000be2\u0001\u0019\u0001\u001e\t\u000b\u00013\u0001\u0019A!\t\u000b=3\u0001\u0019\u0001)\u0002\t\u0019Lg\u000e\u001a\u000b\u0003\u0013\u0002DQ!Y\u0004A\u0002\t\f\u0011\u0002\u001e:jO\u001e,'/\u00133\u0011\u0005\rTgB\u00013i!\t)'%D\u0001g\u0015\t9g$\u0001\u0004=e>|GOP\u0005\u0003S\n\na\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011NI\u0001\u000bC\u0012$GK]5hO\u0016\u0014HCA%p\u0011\u0015\u0001\b\u00021\u0001J\u0003\u001d!(/[4hKJ\fQ\"\u001e9eCR,GK]5hO\u0016\u0014HcB%tkZ\\Xp \u0005\u0006i&\u0001\r!S\u0001\t_JLw-\u001b8bY\")\u0001/\u0003a\u0001\u0013\")q/\u0003a\u0001q\u0006Aa/\u00197jI\u0006$X\r\u0005\u0002\"s&\u0011!P\t\u0002\b\u0005>|G.Z1o\u0011\u0015a\u0018\u00021\u0001y\u0003))W.\u001b;Fm\u0016tGo\u001d\u0005\u0006}&\u0001\r\u0001_\u0001\tS:$XM\u001d8bY\"I\u0011\u0011A\u0005\u0011\u0002\u0003\u0007\u00111A\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b#BA\u0003\u0003\u001f\u0011g\u0002BA\u0004\u0003\u0017q1!ZA\u0005\u0013\u0005\u0019\u0013bAA\u0007E\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\t\u0003'\u00111aU3r\u0015\r\tiA\t\u0015\u0004\u0013\u0005]\u0001\u0003BA\r\u0003Oi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\u0011\u0003G\tq!\\3ue&\u001c7OC\u0002\u0002&q\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0003S\tYBA\u0003US6,G-A\fva\u0012\fG/\u001a+sS\u001e<WM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011q\u0006\u0016\u0005\u0003\u0007\t\td\u000b\u0002\u00024A!\u0011QGA\u001f\u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012!C;oG\",7m[3e\u0015\r\tiBI\u0005\u0005\u0003\u007f\t9DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002Z3mKR,GK]5hO\u0016\u0014H\u0003BA#\u0003\u0017\u00022!IA$\u0013\r\tIE\t\u0002\u0005+:LG\u000fC\u0003q\u0017\u0001\u0007\u0011\nK\u0002\f\u0003/\tq!\u001a=fGV$X\rF\u0003J\u0003'\n)\u0006C\u0003q\u0019\u0001\u0007\u0011\nC\u0004\u0002X1\u0001\r!!\u0017\u0002!\u0015DXmY;uS>t7i\u001c8uKb$\bc\u0001\"\u0002\\%\u0019\u0011QL\"\u0003/Q\u0013\u0018nZ4fe\u0016CXmY;uS>t7i\u001c8uKb$\bf\u0001\u0007\u0002\u0018\u0005iQM\\1cY\u0016$&/[4hKJ$b!!\u0012\u0002f\u0005\u001d\u0004\"\u00029\u000e\u0001\u0004I\u0005b\u0002?\u000e!\u0003\u0005\r\u0001_\u0001\u0018K:\f'\r\\3Ue&<w-\u001a:%I\u00164\u0017-\u001e7uII*\"!!\u001c+\u0007a\f\t$\u0001\twC2LG-\u0019;f\r>dG-\u001a:JIR!\u0011QIA:\u0011\u0015\u0001x\u00021\u0001J\u0003=\u0019\u0007.Z2l-\u0006d\u0017\u000eZ1uS>tGCBA#\u0003s\nY\bC\u0003q!\u0001\u0007\u0011\nC\u0004\u0002~A\u0001\r!a \u0002\t5\u001cxm\u001d\t\u0007\u0003\u0003\u000bY)a$\u000e\u0005\u0005\r%\u0002BAC\u0003\u000f\u000bA!\u001e;jY*\u0011\u0011\u0011R\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u000e\u0006\r%\u0001\u0002'jgR\u0004B!!%\u0002$6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*\u0001\u0006wC2LG-\u0019;j_:TA!!'\u0002\u001c\u0006\u0019\u0011\r]5\u000b\t\u0005u\u0015qT\u0001\u0007a2,x-\u001b8\u000b\u0007\u0005\u0005&$\u0001\u0005eKBdw._5u\u0013\u0011\t)+a%\u0003#Y\u000bG.\u001b3bi&|g.T3tg\u0006<W\r\u0006\u0003\u0002F\u0005%\u0006BBAV#\u0001\u0007\u0011*\u0001\u0002dS\u0006yQ\u000f\u001d3bi\u00164\u0016M]5bE2,7\u000f\u0006\u0003\u0002F\u0005E\u0006\"\u00029\u0013\u0001\u0004I\u0005")
public class TriggerOperations
implements Logging {
    private final TriggerRepository triggerRepository;
    private final ReleaseRepository releaseRepository;
    private final XLReleaseEventBus eventBus;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private final ConfigurationVariableService configurationVariableService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerOperations triggerOperations = this;
        synchronized (triggerOperations) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Trigger find(String triggerId) {
        return this.triggerRepository.find(triggerId);
    }

    /*
     * WARNING - void declaration
     */
    public Trigger addTrigger(Trigger trigger) {
        void var2_2;
        this.validateFolderId(trigger);
        PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)None$.MODULE$, (ConfigurationItem)trigger);
        this.checkValidation(trigger);
        this.updateVariables(trigger);
        CiHelper.fixUpInternalReferences((ConfigurationItem)trigger);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerCreatingActionEvent(trigger));
        Trigger addedTrigger = this.triggerRepository.create(trigger);
        this.eventBus.publish((XLReleaseEvent)new TriggerCreatedEvent(addedTrigger));
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        return var2_2;
    }

    @Timed
    public Trigger updateTrigger(Trigger original, Trigger trigger, boolean validate, boolean emitEvents, boolean internal, scala.collection.immutable.Seq<String> properties) {
        Trigger updated;
        block5: {
            Trigger trigger2;
            this.trace((Function0<Object>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(69).append("Updating trigger ").append(original).append(" properties: '").append(properties.mkString(",")).append("'\n         |previous: ").append(package$.MODULE$.TriggerExtensions(original).toJson()).append("\n         |new: ").append(package$.MODULE$.TriggerExtensions(trigger).toJson()).toString())));
            if (properties.isEmpty()) {
                CollectionConverters$.MODULE$.ListHasAsScala(trigger.getInternalProperties()).asScala().foreach((Function1 & Serializable)internalProperty -> {
                    trigger.setProperty(internalProperty, original.getProperty(internalProperty));
                    return BoxedUnit.UNIT;
                });
                trigger2 = trigger;
            } else {
                trigger2 = (Trigger)CiCloneHelper.cloneCi((ConfigurationItem)original);
            }
            Trigger toUpdate = trigger2;
            toUpdate.setCiUid(original.getCiUid());
            toUpdate.setFolderId(new FolderId(trigger.getFolderId()).absolute());
            toUpdate.setId(Ids.formatWithFolderId((String)trigger.getFolderId(), (String)Ids.getName((String)trigger.getId())));
            CiHelper.fixUpInternalReferences((ConfigurationItem)toUpdate);
            if (!new FolderId(original.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
                this.validateFolderId(toUpdate);
            }
            properties.foreach((Function1 & Serializable)propertyToUpdate -> {
                toUpdate.setProperty(propertyToUpdate, trigger.getProperty(propertyToUpdate));
                return BoxedUnit.UNIT;
            });
            if (validate) {
                PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option)new Some((Object)original), (ConfigurationItem)toUpdate);
                this.checkValidation(toUpdate);
                this.updateVariables(toUpdate);
                this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerUpdatingActionEvent(original, toUpdate));
            }
            updated = this.triggerRepository.update(toUpdate);
            if (!internal) {
                boolean emitStateEvent = emitEvents && (!Objects.equal((Object)BoxesRunTime.boxToBoolean((boolean)original.isEnabled()), (Object)BoxesRunTime.boxToBoolean((boolean)updated.isEnabled())) || properties.contains((Object)"enabled"));
                this.enableTrigger(updated, emitStateEvent);
            }
            if (!emitEvents) break block5;
            this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedEvent(original, updated));
        }
        return updated;
    }

    public scala.collection.immutable.Seq<String> updateTrigger$default$6() {
        return (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    @Timed
    public void deleteTrigger(Trigger trigger) {
        trigger.setEnabled(false);
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TriggerDeletingActionEvent(trigger));
        this.triggerRepository.delete(trigger.getId());
        this.enableTrigger(trigger, this.enableTrigger$default$2());
        this.eventBus.publish((XLReleaseEvent)new TriggerDeletedEvent(trigger));
    }

    /*
     * Unable to fully structure code
     */
    @Timed
    public Trigger execute(Trigger trigger, TriggerExecutionContext executionContext) {
        block6: {
            block4: {
                block5: {
                    x$1 = trigger;
                    x$2 = this.configurationVariableService.resolveFromCi$default$2();
                    x$3 = this.configurationVariableService.resolveFromCi$default$3((ConfigurationItem)x$1, x$2);
                    this.configurationVariableService.resolveFromCi((ConfigurationItem)x$1, x$2, x$3);
                    var10_6 = this.triggerLifecycle.execute(trigger, executionContext);
                    if (var10_6 == null) {
                        throw new MatchError(var10_6);
                    }
                    maybeExecutedTrigger = var10_6.trigger();
                    result = var10_6.results();
                    var5_9 = new Tuple2((Object)maybeExecutedTrigger, result);
                    var9_10 = var5_9;
                    maybeExecutedTrigger = (Trigger)var9_10._1();
                    var15_13 = result = (Try)var9_10._2();
                    if (var15_13 instanceof Failure) {
                        var16_14 = (Failure)var15_13;
                        e = var16_14.exception();
                        this.eventBus.publish((XLReleaseEvent)new TriggerFailedEvent(trigger, e.getMessage(), executionContext.getExecutionDataId()));
                        throw e;
                    }
                    if (!(var15_13 instanceof Success)) break block4;
                    var18_16 = (Success)var15_13;
                    actionResult = (TriggerActionResult)var18_16.value();
                    var20_18 = actionResult;
                    if (!(var20_18 instanceof TriggerActionExecuted)) break block5;
                    var21_19 = (TriggerActionExecuted)var20_18;
                    result = var21_19.result();
                    this.eventBus.publish((XLReleaseEvent)new TriggerExecutedEvent(maybeExecutedTrigger, result, executionContext.getExecutionDataId()));
                    var4_21 = BoxedUnit.UNIT;
                    break block6;
                }
                if (!(var20_18 instanceof TriggerActionSkipped)) ** GOTO lbl-1000
                var23_24 = (TriggerActionSkipped)var20_18;
                message = var23_24.message();
                if (!(executionContext instanceof ScheduledTriggerExecutionContext)) {
                    this.eventBus.publish((XLReleaseEvent)new TriggerSkippedEvent(maybeExecutedTrigger, message, executionContext.getExecutionDataId()));
                    var4_22 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    var4_23 = BoxedUnit.UNIT;
                }
                break block6;
            }
            throw new MatchError((Object)var15_13);
        }
        var3_26 = maybeExecutedTrigger;
        return var3_26;
    }

    private void enableTrigger(Trigger trigger, boolean emitEvents) {
        block1: {
            block0: {
                if (!trigger.isEnabled()) break block0;
                this.triggerLifecycle.enable(trigger);
                if (!emitEvents) break block1;
                this.eventBus.publish((XLReleaseEvent)new TriggerEnabledEvent(trigger));
                break block1;
            }
            this.triggerLifecycle.disable(trigger);
            if (!emitEvents) break block1;
            this.eventBus.publish((XLReleaseEvent)new TriggerDisabledEvent(trigger));
        }
    }

    private boolean enableTrigger$default$2() {
        return true;
    }

    private void validateFolderId(Trigger trigger) {
        block0: {
            if (!new FolderId(trigger.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) break block0;
            trigger.get$validationMessages().add(new ValidationMessage(trigger.getId(), "folderId", "You cannot create trigger on the root folder. The root folder path is not supported."));
        }
    }

    private void checkValidation(Trigger trigger, List<ValidationMessage> msgs) {
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(msgs).asScala().nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)trigger.get$validationMessages().addAll(msgs)) : BoxedUnit.UNIT;
        if (CollectionConverters$.MODULE$.ListHasAsScala(trigger.get$validationMessages()).asScala().nonEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)trigger);
        }
    }

    private void checkValidation(Trigger ci) {
        this.checkValidation(ci, this.triggerLifecycle.validate(ci));
    }

    private void updateVariables(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            List variables = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.findById(releaseTrigger.getTemplate(), ResolveOptions$.MODULE$.MINIMAL()).getVariables()).asScala().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$1(releaseTrigger, v)))).toList()).asJava();
            Release variableHolderTemplate = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate()).withVariables(variables).build();
            variableHolderTemplate.setVariableValues(CollectionConverters$.MODULE$.MutableMapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(releaseTrigger.getTemplateVariableValues(x$2 -> !x$2.isPassword())).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$3(x$3)))).asJava());
            variableHolderTemplate.setPasswordVariableValues(releaseTrigger.getTemplatePasswordVariables());
            releaseTrigger.setVariables(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variableHolderTemplate.getVariables()).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TriggerOperations.$anonfun$updateVariables$4(x$4)))).toList()).asJava());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$1(ReleaseTrigger x2$1, Variable v) {
        return x2$1.getVariablesByKeys().containsKey(v.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 x$3) {
        return x$3._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Variable x$4) {
        return x$4.getId() != null;
    }

    public TriggerOperations(TriggerRepository triggerRepository, ReleaseRepository releaseRepository, XLReleaseEventBus eventBus, TriggerLifecycle<Trigger> triggerLifecycle, ConfigurationVariableService configurationVariableService) {
        this.triggerRepository = triggerRepository;
        this.releaseRepository = releaseRepository;
        this.eventBus = eventBus;
        this.triggerLifecycle = triggerLifecycle;
        this.configurationVariableService = configurationVariableService;
        Logging.$init$((Logging)this);
    }
}

