/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.scheduled.validators;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionCheckerHolder$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005!3A\u0001B\u0003\u0001%!)Q\u0006\u0001C\u0001]!)\u0011\u0007\u0001C!e!)\u0001\t\u0001C\u0005\u0003\n9\"+\u001a7fCN,GK]5hO\u0016\u0014h+\u00197jI\u0006$xN\u001d\u0006\u0003\r\u001d\t!B^1mS\u0012\fGo\u001c:t\u0015\tA\u0011\"A\u0005tG\",G-\u001e7fI*\u0011!bC\u0001\tiJLwmZ3sg*\u0011A\"D\u0001\nq2\u0014X\r\\3bg\u0016T!AD\b\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u00192\u0004\u0005\u0002\u001535\tQC\u0003\u0002\u0017/\u0005!A.\u00198h\u0015\u0005A\u0012\u0001\u00026bm\u0006L!AG\u000b\u0003\r=\u0013'.Z2u!\raReJ\u0007\u0002;)\u0011adH\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'B\u0001\u0011\"\u0003\r\t\u0007/\u001b\u0006\u0003E\r\na\u0001\u001d7vO&t'B\u0001\u0013\u000e\u0003!!W\r\u001d7ps&$\u0018B\u0001\u0014\u001e\u0005%1\u0016\r\\5eCR|'\u000f\u0005\u0002)W5\t\u0011F\u0003\u0002+\u0017\u00051Am\\7bS:L!\u0001L\u0015\u0003\u001dI+G.Z1tKR\u0013\u0018nZ4fe\u00061A(\u001b8jiz\"\u0012a\f\t\u0003a\u0001i\u0011!B\u0001\tm\u0006d\u0017\u000eZ1uKR\u00191'O\u001e\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u0006u\t\u0001\raJ\u0001\biJLwmZ3s\u0011\u0015a$\u00011\u0001>\u0003\u001d\u0019wN\u001c;fqR\u0004\"\u0001\b \n\u0005}j\"!\u0005,bY&$\u0017\r^5p]\u000e{g\u000e^3yi\u0006\u0001b/\u00197jI\u0006$X\rV3na2\fG/\u001a\u000b\u0004g\t\u001b\u0005\"\u0002\u001e\u0004\u0001\u00049\u0003\"\u0002#\u0004\u0001\u0004)\u0015aD3yi\u0016tG-\u001a3D_:$X\r\u001f;\u0011\u0005q1\u0015BA$\u001e\u0005e)\u0005\u0010^3oI\u0016$g+\u00197jI\u0006$\u0018n\u001c8D_:$X\r\u001f;")
public class ReleaseTriggerValidator
implements Validator<ReleaseTrigger> {
    public void validate(ReleaseTrigger trigger, ValidationContext context) {
        ExtendedValidationContext extendedContext = (ExtendedValidationContext)context;
        if (Strings.isNullOrEmpty((String)trigger.getReleaseTitle())) {
            extendedContext.error((ConfigurationItem)trigger, "releaseTitle", "Release title cannot be blank", new Object[0]);
        }
        if (!Strings.isNullOrEmpty((String)trigger.getFolderId()) && !Ids.isRoot((String)trigger.getFolderId())) {
            try {
                PermissionCheckerHolder$.MODULE$.get().checkIsAllowedToCreateReleaseInFolder(trigger.getFolderId());
            }
            catch (Exception e) {
                extendedContext.error((ConfigurationItem)trigger, "folderId", e.getMessage(), new Object[0]);
            }
        }
        this.validateTemplate(trigger, extendedContext);
    }

    private void validateTemplate(ReleaseTrigger trigger, ExtendedValidationContext extendedContext) {
        block5: {
            if (Strings.isNullOrEmpty((String)trigger.getTemplate())) {
                extendedContext.error((ConfigurationItem)trigger, "template", "Trigger does not have associated template", new Object[0]);
            }
            if (Strings.isNullOrEmpty((String)trigger.getTemplate())) break block5;
            if (!Strings.isNullOrEmpty((String)trigger.getFolderId())) {
                String string = Ids.findFolderId((String)trigger.getTemplate());
                String string2 = trigger.getFolderId();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    extendedContext.error((ConfigurationItem)trigger, "template", "Trigger folder id does not match template folder id", new Object[0]);
                }
            }
            try {
                PermissionCheckerHolder$.MODULE$.get().checkIsAllowedToCreateReleaseFromTemplate(trigger.getTemplate());
            }
            catch (Exception e) {
                extendedContext.error((ConfigurationItem)trigger, "template", e.getMessage(), new Object[0]);
            }
        }
    }
}

